/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.MissingDependencyIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenFileAtLocationQuickFix;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016JD\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00170\u0016H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingDependencyIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "MISSING_DEPENDENCY_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "MISSING_MATCHING_DEPENDENCY_PATTERN", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "getBuildIssueDescription", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/BuildIssueComposer;", "projectPath", "intellij.android.projectSystem.gradle"})
public final class MissingDependencyIssueChecker
implements GradleIssueChecker {
    private final Pattern MISSING_MATCHING_DEPENDENCY_PATTERN = Pattern.compile("Could not find any version that matches (.*)\\.");
    private final Pattern MISSING_DEPENDENCY_PATTERN = Pattern.compile("Could not find (.*)\\.");

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        String string = ((Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first).getMessage();
        if (string == null) {
            return null;
        }
        String message2 = string;
        if (StringsKt.isBlank((CharSequence)message2)) {
            return null;
        }
        BuildIssueComposer buildIssueComposer = this.getBuildIssueDescription(message2, issueData.getProjectPath());
        if (buildIssueComposer == null) {
            return null;
        }
        BuildIssueComposer buildIssueComposer2 = buildIssueComposer;
        return buildIssueComposer2.composeBuildIssue();
    }

    private final BuildIssueComposer getBuildIssueDescription(String message2, String projectPath) {
        List lineSequence = StringsKt.lines((CharSequence)message2);
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message2, null, 2, null);
        Project ideaProject = BuildIssueUtilKt.fetchIdeaProjectForGradleProject(projectPath);
        Matcher matcher = this.MISSING_MATCHING_DEPENDENCY_PATTERN.matcher((CharSequence)lineSequence.get(0));
        if (matcher.matches()) {
            String dependency = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"dependency");
            MissingDependencyIssueCheckerKt.access$handleMissingDependency(ideaProject, dependency, buildIssueComposer);
            return buildIssueComposer;
        }
        Matcher matcherMissingDependency = this.MISSING_DEPENDENCY_PATTERN.matcher((CharSequence)lineSequence.get(0));
        if (matcherMissingDependency.matches() && lineSequence.size() > 1 && StringsKt.startsWith$default((String)((String)lineSequence.get(1)), (String)"Required by:", (boolean)false, (int)2, null)) {
            String dependency = matcherMissingDependency.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"dependency");
            if (((CharSequence)dependency).length() > 0) {
                Pair pair = GradleExecutionErrorHandler.getErrorLocation((String)((String)CollectionsKt.last((List)lineSequence)));
                if (pair != null) {
                    Pair pair2;
                    Pair it = pair2 = pair;
                    boolean bl = false;
                    buildIssueComposer.addQuickFix("Open file.", new OpenFileAtLocationQuickFix(new FilePosition(new File((String)it.first), ((Number)it.second).intValue() - 1, -1)));
                }
                MissingDependencyIssueCheckerKt.access$handleMissingDependency(ideaProject, dependency, buildIssueComposer);
                return buildIssueComposer;
            }
        }
        for (String line2 : lineSequence) {
            Matcher matcherMissingMatching = this.MISSING_MATCHING_DEPENDENCY_PATTERN.matcher(line2);
            if (!matcherMissingMatching.matches()) continue;
            String string = matcherMissingMatching.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcherMissingMatching.group(1)");
            MissingDependencyIssueCheckerKt.access$handleMissingDependency(ideaProject, string, buildIssueComposer);
            return buildIssueComposer;
        }
        return null;
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location2, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return this.MISSING_MATCHING_DEPENDENCY_PATTERN.matcher((CharSequence)StringsKt.lines((CharSequence)failureCause).get(0)).matches() || this.MISSING_DEPENDENCY_PATTERN.matcher((CharSequence)StringsKt.lines((CharSequence)failureCause).get(0)).matches() && StringsKt.lines((CharSequence)failureCause).size() > 1 && StringsKt.startsWith$default((String)((String)StringsKt.lines((CharSequence)failureCause).get(1)), (String)"Required by:", (boolean)false, (int)2, null);
    }
}

