/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvokerKt;
import com.android.tools.idea.gradle.project.sync.errors.GradleDistributionInstallIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/GradleDistributionInstallIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "DeleteFileAndSyncQuickFix", "intellij.android.projectSystem.gradle"})
public final class GradleDistributionInstallIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        PathAssembler pathAssembler;
        PathAssembler.LocalDistribution localDistribution;
        File zipFile;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        String string = issueData.getError().getMessage();
        if (string == null) {
            return null;
        }
        String message2 = string;
        if (!StringsKt.startsWith$default((String)message2, (String)GradleDistributionInstallIssueCheckerKt.COULD_NOT_INSTALL_GRADLE_DISTRIBUTION_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(issueData){
            final /* synthetic */ GradleIssueData $issueData$inlined;
            {
                this.$issueData$inlined = gradleIssueData;
            }

            public final void run() {
                boolean bl = false;
                BuildIssueUtilKt.updateUsageTracker(this.$issueData$inlined.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.GRADLE_DISTRIBUTION_INSTALL_ERROR);
            }
        }, ModalityState.defaultModalityState());
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message2, null, 2, null);
        WrapperConfiguration wrapperConfiguration = GradleUtil.getWrapperConfiguration((String)issueData.getProjectPath());
        if (wrapperConfiguration != null && (zipFile = (localDistribution = (pathAssembler = new PathAssembler(StartParameter.DEFAULT_GRADLE_USER_HOME, new File(issueData.getProjectPath()))).getDistribution(wrapperConfiguration)).getZipFile()).exists()) {
            try {
                zipFile = zipFile.getCanonicalFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            buildIssueComposer.addDescription("The cached zip file " + zipFile + " may be corrupted.");
            File file2 = zipFile;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"zipFile");
            buildIssueComposer.addQuickFix("Delete file and sync project", new DeleteFileAndSyncQuickFix(file2, GradleSyncStats.Trigger.TRIGGER_QF_GRADLE_DISTRIBUTION_DELETED));
            return buildIssueComposer.composeBuildIssue();
        }
        return null;
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location2, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return StringsKt.startsWith$default((String)failureCause, (String)GradleDistributionInstallIssueCheckerKt.COULD_NOT_INSTALL_GRADLE_DISTRIBUTION_PREFIX, (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/GradleDistributionInstallIssueChecker$DeleteFileAndSyncQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "file", "Ljava/io/File;", "syncTrigger", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$Trigger;", "(Ljava/io/File;Lcom/google/wireless/android/sdk/stats/GradleSyncStats$Trigger;)V", "getFile", "()Ljava/io/File;", "id", "", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle"})
    public static final class DeleteFileAndSyncQuickFix
    implements BuildIssueQuickFix {
        @NotNull
        private final File file;
        @NotNull
        private final GradleSyncStats.Trigger syncTrigger;
        @NotNull
        private final String id;

        public DeleteFileAndSyncQuickFix(@NotNull File file2, @NotNull GradleSyncStats.Trigger syncTrigger) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)syncTrigger, (String)"syncTrigger");
            this.file = file2;
            this.syncTrigger = syncTrigger;
            this.id = "delete.file.and.sync";
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            CompletableFuture future2 = new CompletableFuture();
            ModalityState modalityState$iv = null;
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(project, this, future2){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ DeleteFileAndSyncQuickFix this$0;
                final /* synthetic */ CompletableFuture $future$inlined;
                {
                    this.$project$inlined = project;
                    this.this$0 = deleteFileAndSyncQuickFix;
                    this.$future$inlined = completableFuture;
                }

                public final void run() {
                    boolean bl = false;
                    if (Messages.showYesNoDialog((Project)this.$project$inlined, (String)("Are you sure you want to delete this file?\n\n" + this.this$0.getFile().getPath()), (String)"Delete File", null) == 0) {
                        if (FileUtil.delete((File)this.this$0.getFile())) {
                            GradleSyncInvokerKt.requestProjectSync$default(GradleSyncInvoker.Companion.getInstance(), this.$project$inlined, DeleteFileAndSyncQuickFix.access$getSyncTrigger$p(this.this$0), null, 4, null);
                        } else {
                            Messages.showErrorDialog((Project)this.$project$inlined, (String)("Could not delete " + this.this$0.getFile().getPath()), (String)"Delete File");
                        }
                    }
                    this.$future$inlined.complete(null);
                }
            }, ModalityState.defaultModalityState());
            return future2;
        }

        public static final /* synthetic */ GradleSyncStats.Trigger access$getSyncTrigger$p(DeleteFileAndSyncQuickFix $this) {
            return $this.syncTrigger;
        }
    }
}

