/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ModalityUiUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkSync {
    private static final String ERROR_DIALOG_TITLE = "Sync Android SDKs";

    @NotNull
    public static SdkSync getInstance() {
        return (SdkSync)ApplicationManager.getApplication().getService(SdkSync.class);
    }

    public void syncIdeAndProjectAndroidSdks(@NotNull LocalProperties localProperties) {
        this.syncIdeAndProjectAndroidSdk(localProperties, new FindValidSdkPathTask(), null);
        this.syncIdeAndProjectAndroidNdk(localProperties);
    }

    @VisibleForTesting
    void syncIdeAndProjectAndroidSdk(@NotNull LocalProperties localProperties, @NotNull FindValidSdkPathTask findSdkPathTask, @Nullable Project project) {
        if (localProperties.hasAndroidDirProperty()) {
            return;
        }
        File ideAndroidSdkPath = IdeSdks.getInstance().getAndroidSdkPath();
        File projectAndroidSdkPath = localProperties.getAndroidSdkPath();
        if (ideAndroidSdkPath != null && projectAndroidSdkPath != null) {
            this.reconcileIdeAndProjectPaths(localProperties, project, ideAndroidSdkPath, projectAndroidSdkPath);
        } else if (ideAndroidSdkPath == null && projectAndroidSdkPath == null) {
            this.setIdeSdkFromLocalProperties(localProperties, findSdkPathTask);
        } else if (ideAndroidSdkPath != null) {
            this.setProjectSdkFromLocalProperties(localProperties, ideAndroidSdkPath);
        } else {
            this.setIdeSdkFromProjectSdk(localProperties, findSdkPathTask, projectAndroidSdkPath);
        }
    }

    private void setIdeSdkFromProjectSdk(@NotNull LocalProperties localProperties, @NotNull FindValidSdkPathTask findSdkPathTask, @NotNull File projectAndroidSdkPath) {
        if (IdeSdks.getInstance().isValidAndroidSdkPath(projectAndroidSdkPath)) {
            this.setIdeSdk(localProperties, projectAndroidSdkPath);
        } else {
            File selectedPath = findSdkPathTask.selectValidSdkPath();
            if (selectedPath == null) {
                throw new ExternalSystemException("Unable to continue until an Android SDK is specified");
            }
            this.setIdeSdk(localProperties, selectedPath);
        }
    }

    private void setProjectSdkFromLocalProperties(@NotNull LocalProperties localProperties, @NotNull File ideAndroidSdkPath) {
        if (localProperties.getPropertiesFilePath().exists() || IdeInfo.getInstance().isAndroidStudio()) {
            SdkSync.setProjectSdk(localProperties, ideAndroidSdkPath);
        }
    }

    private void setIdeSdkFromLocalProperties(@NotNull LocalProperties localProperties, @NotNull FindValidSdkPathTask findSdkPathTask) {
        if (localProperties.getPropertiesFilePath().exists() || IdeInfo.getInstance().isAndroidStudio()) {
            File selectedPath = findSdkPathTask.selectValidSdkPath();
            if (selectedPath == null) {
                throw new ExternalSystemException("Unable to continue until an Android SDK is specified");
            }
            this.setIdeSdk(localProperties, selectedPath);
        }
    }

    private void reconcileIdeAndProjectPaths(@NotNull LocalProperties localProperties, @Nullable Project project, @NotNull File ideAndroidSdkPath, @NotNull File projectAndroidSdkPath) {
        SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(projectAndroidSdkPath.toPath(), true);
        if (!validationResult.success) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    String error = validationResult.message;
                    if (StringUtil.isEmpty((String)error)) {
                        error = String.format("The path \n'%1$s'\ndoes not refer to a valid Android SDK.", projectAndroidSdkPath.getPath());
                    }
                    String format = "%1$s\n\n%3$s will use this Android SDK instead:\n'%2$s'\nand will modify the project's local.properties file.";
                    Messages.showErrorDialog((String)String.format(format, error, ideAndroidSdkPath.getPath(), ApplicationNamesInfo.getInstance().getFullProductName()), (String)ERROR_DIALOG_TITLE);
                }
                SdkSync.setProjectSdk(localProperties, ideAndroidSdkPath);
            });
            return;
        }
        if (!FileUtil.filesEqual((File)ideAndroidSdkPath, (File)projectAndroidSdkPath)) {
            String msg = String.format("The project and %3$s point to different Android SDKs.\n\n%3$s's default SDK is in:\n%1$s\n\nThe project's SDK (specified in local.properties) is in:\n%2$s\n\nTo keep results consistent between IDE and command line builds, only one path can be used. Do you want to:\n\n[1] Use %3$s's default SDK (modifies the project's local.properties file.)\n\n[2] Use the project's SDK (modifies %3$s's default.)\n\nNote that switching SDKs could cause compile errors if the selected SDK doesn't have the necessary Android platforms or build tools.", ideAndroidSdkPath.getPath(), projectAndroidSdkPath.getPath(), ApplicationNamesInfo.getInstance().getFullProductName());
            ApplicationManager.getApplication().invokeAndWait(() -> {
                boolean userChoseYes = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Android SDK Manager", (String)msg).yesText("Use " + ApplicationNamesInfo.getInstance().getFullProductName() + "'s SDK")).noText("Use Project's SDK")).ask(project);
                if (userChoseYes) {
                    SdkSync.setProjectSdk(localProperties, ideAndroidSdkPath);
                } else {
                    this.setIdeSdk(localProperties, projectAndroidSdkPath);
                }
            });
        }
    }

    private void syncIdeAndProjectAndroidNdk(@NotNull LocalProperties localProperties) {
        if (((Boolean)StudioFlags.NDK_SIDE_BY_SIDE_ENABLED.get()).booleanValue()) {
            return;
        }
        File projectAndroidNdkPath = localProperties.getAndroidNdkPath();
        File ideAndroidNdkPath = IdeSdks.getInstance().getAndroidNdkPath();
        if (projectAndroidNdkPath != null) {
            if (!SdkPaths.validateAndroidNdk((Path)projectAndroidNdkPath.toPath(), (boolean)false).success) {
                if (ideAndroidNdkPath != null) {
                    Logger.getInstance(SdkSync.class).warn(String.format("Replacing invalid NDK path %1$s with %2$s", projectAndroidNdkPath, ideAndroidNdkPath));
                    SdkSync.setProjectNdk(localProperties, ideAndroidNdkPath);
                    return;
                }
                Logger.getInstance(SdkSync.class).warn(String.format("Removing invalid NDK path: %s", projectAndroidNdkPath));
                SdkSync.setProjectNdk(localProperties, null);
            }
            return;
        }
        SdkSync.setProjectNdk(localProperties, ideAndroidNdkPath);
    }

    private static void setProjectNdk(@NotNull LocalProperties localProperties, @Nullable File ndkPath) {
        File currentNdkPath = localProperties.getAndroidNdkPath();
        if (FileUtil.filesEqual((File)currentNdkPath, (File)ndkPath)) {
            return;
        }
        localProperties.setAndroidNdkPath(ndkPath);
        try {
            localProperties.save();
        }
        catch (IOException e) {
            String msg = String.format("Unable to save '%1$s'", localProperties.getPropertiesFilePath().getPath());
            throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
        }
    }

    private void setIdeSdk(@NotNull LocalProperties localProperties, @NotNull File projectAndroidSdkPath) {
        SdkSync.setProjectSdk(localProperties, projectAndroidSdkPath);
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> ApplicationManager.getApplication().runWriteAction(() -> IdeSdks.getInstance().setAndroidSdkPath(projectAndroidSdkPath, null)));
    }

    private static void setProjectSdk(@NotNull LocalProperties localProperties, @NotNull File androidSdkPath) {
        if (FileUtil.filesEqual((File)localProperties.getAndroidSdkPath(), (File)androidSdkPath)) {
            return;
        }
        localProperties.setAndroidSdkPath(androidSdkPath);
        try {
            localProperties.save();
        }
        catch (IOException e) {
            String msg = String.format("Unable to save '%1$s'", localProperties.getPropertiesFilePath().getPath());
            throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
        }
    }

    @VisibleForTesting
    static class FindValidSdkPathTask {
        FindValidSdkPathTask() {
        }

        @Nullable
        File selectValidSdkPath() {
            Ref pathRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(() -> FindValidSdkPathTask.findValidSdkPath((Ref<File>)pathRef));
            return (File)pathRef.get();
        }

        private static void findValidSdkPath(@NotNull Ref<File> pathRef) {
            Sdk jdk = IdeSdks.getInstance().getJdk();
            String jdkPath = jdk != null ? jdk.getHomePath() : null;
            SelectSdkDialog dialog2 = new SelectSdkDialog(jdkPath, null);
            dialog2.setModal(true);
            if (!dialog2.showAndGet()) {
                String msg = "An Android SDK is needed to continue. Would you like to try again?";
                if (MessageDialogBuilder.yesNo((String)SdkSync.ERROR_DIALOG_TITLE, (String)msg).ask((Project)null)) {
                    FindValidSdkPathTask.findValidSdkPath(pathRef);
                }
                return;
            }
            File path2 = new File(dialog2.getAndroidHome());
            if (!IdeSdks.getInstance().isValidAndroidSdkPath(path2)) {
                String format = "The path\n'%1$s'\ndoes not refer to a valid Android SDK. Would you like to try again?";
                if (MessageDialogBuilder.yesNo((String)SdkSync.ERROR_DIALOG_TITLE, (String)String.format(format, path2.getPath())).ask((Project)null)) {
                    FindValidSdkPathTask.findValidSdkPath(pathRef);
                }
                return;
            }
            pathRef.set((Object)path2);
        }
    }
}

