/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.utils.FileUtils;
import java.io.File;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.jetbrains.annotations.NotNull;

public final class Modules {
    private Modules() {
    }

    @NotNull
    public static String createUniqueModuleId(@NotNull BasicGradleProject gradleProject) {
        File rootProjectFolderPath = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir();
        return Modules.createUniqueModuleId(rootProjectFolderPath.getPath(), gradleProject.getPath());
    }

    @NotNull
    public static String createUniqueModuleId(@NotNull File rootProjectFolderPath, @NotNull String gradlePath) {
        return Modules.createUniqueModuleId(rootProjectFolderPath.getPath(), gradlePath);
    }

    @NotNull
    public static String createUniqueModuleId(@NotNull String rootProjectFolderPath, @NotNull String gradlePath) {
        return FileUtils.toSystemDependentPath((String)rootProjectFolderPath) + ':' + gradlePath;
    }

    @NotNull
    public static String createUniqueModuleId(@NotNull GradleProject gradleProject) {
        File rootProjectFolderPath = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir();
        return Modules.createUniqueModuleId(rootProjectFolderPath.getPath(), gradleProject.getPath());
    }
}

