/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.gradle.model.impl.BuildFolderPaths;
import java.io.File;
import java.util.ArrayList;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;

public class ModelConverter {
    @NotNull
    public static BuildFolderPaths populateModuleBuildDirs(@NotNull BuildController controller2) {
        IdeaProject rootIdeaProject = (IdeaProject)controller2.findModel(IdeaProject.class);
        if (rootIdeaProject == null) {
            return new BuildFolderPaths();
        }
        BuildFolderPaths buildFolderPaths = new BuildFolderPaths();
        for (IdeaModule ideaModule : rootIdeaProject.getChildren()) {
            GradleProject gradleProject = ideaModule.getGradleProject();
            if (gradleProject == null) continue;
            File buildRootDirectory = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir();
            String rootBuildId = buildRootDirectory.getPath();
            buildFolderPaths.setRootBuildId(rootBuildId);
            buildFolderPaths.setBuildRootDirectory(buildRootDirectory);
            break;
        }
        ArrayList<IdeaProject> ideaProjects = new ArrayList<IdeaProject>();
        ideaProjects.add(rootIdeaProject);
        DomainObjectSet includedBuilds = controller2.getBuildModel().getIncludedBuilds();
        for (GradleBuild includedBuild : includedBuilds) {
            IdeaProject ideaProject = (IdeaProject)controller2.getModel((Model)includedBuild, IdeaProject.class);
            assert (ideaProject != null);
            ideaProjects.add(ideaProject);
        }
        for (IdeaProject ideaProject : ideaProjects) {
            for (IdeaModule ideaModule : ideaProject.getChildren()) {
                GradleProject gradleProject = ideaModule.getGradleProject();
                if (gradleProject == null) continue;
                try {
                    String buildId = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir().getPath();
                    buildFolderPaths.addBuildFolderMapping(buildId, gradleProject.getPath(), gradleProject.getBuildDirectory());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        return buildFolderPaths;
    }
}

