/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.intellij.util.MemoryDumpHelper;
import java.io.File;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u00a8\u0006\u0005"}, d2={"captureSnapshot", "", "outputPath", "", "name", "intellij.android.projectSystem.gradle.sync"})
public final class MemorySnapshotHelperKt {
    public static final void captureSnapshot(@NotNull String outputPath, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            String timestamp = DateTimeFormatter.ofPattern("yyyy.MM.dd-HH:mm").withZone(ZoneOffset.UTC).format(Instant.now());
            File file2 = FilesKt.resolve((File)new File(outputPath), (String)(timestamp + '-' + name + ".hprof"));
            System.out.println((Object)("Capturing memory snapshot at: " + file2.getAbsolutePath()));
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            MemoryDumpHelper.captureMemoryDump((String)file2.getAbsolutePath());
            long elapsedTime = System.currentTimeMillis() - start$iv;
            System.out.println((Object)("Done in " + elapsedTime));
        }
        catch (Exception e) {
            System.out.println((Object)("Error capturing snapshot:  " + ExceptionsKt.stackTraceToString((Throwable)e)));
        }
    }
}

