/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.gradle.model.IdeDependencies;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncEventLoggerKt;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.common.collect.Ordering;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.google.wireless.android.sdk.stats.KotlinSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\r\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0004J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/gradle/project/sync/GradleSyncEventLogger;", "", "now", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "getNow", "()Lkotlin/jvm/functions/Function0;", "syncEndedTimeStamp", "syncSetupStartedTimeStamp", "syncStartedTimeStamp", "syncType", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$GradleSyncType;", "trigger", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$Trigger;", "generateSyncEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "project", "Lcom/intellij/openapi/project/Project;", "rootProjectPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "kind", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$EventKind;", "setupStarted", "syncEnded", "syncStarted", "", "intellij.android.projectSystem.gradle"})
public final class GradleSyncEventLogger {
    @NotNull
    private final Function0<Long> now;
    private long syncStartedTimeStamp;
    private long syncSetupStartedTimeStamp;
    private long syncEndedTimeStamp;
    @Nullable
    private GradleSyncStats.GradleSyncType syncType;
    @Nullable
    private GradleSyncStats.Trigger trigger;

    public GradleSyncEventLogger(@NotNull Function0<Long> now) {
        Intrinsics.checkNotNullParameter(now, (String)"now");
        this.now = now;
        this.syncStartedTimeStamp = -1L;
        this.syncSetupStartedTimeStamp = -1L;
        this.syncEndedTimeStamp = -1L;
    }

    public /* synthetic */ GradleSyncEventLogger(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this((Function0<Long>)function0);
    }

    @NotNull
    public final Function0<Long> getNow() {
        return this.now;
    }

    public final void syncStarted(@NotNull GradleSyncStats.GradleSyncType syncType, @NotNull GradleSyncStats.Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)syncType, (String)"syncType");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        this.syncStartedTimeStamp = ((Number)this.now.invoke()).longValue();
        this.syncSetupStartedTimeStamp = -1L;
        this.syncEndedTimeStamp = -1L;
        this.syncType = syncType;
        this.trigger = trigger;
    }

    public final long setupStarted() {
        this.syncSetupStartedTimeStamp = ((Number)this.now.invoke()).longValue();
        return this.syncSetupStartedTimeStamp - this.syncStartedTimeStamp;
    }

    public final long syncEnded() {
        this.syncEndedTimeStamp = ((Number)this.now.invoke()).longValue();
        return this.syncEndedTimeStamp - this.syncStartedTimeStamp;
    }

    @NotNull
    public final AndroidStudioEvent.Builder generateSyncEvent(@NotNull Project project, @Nullable String rootProjectPath, @NotNull AndroidStudioEvent.EventKind kind) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
        GradleSyncStats.Builder syncStats = GradleSyncStats.newBuilder();
        Set<String> buildFileTypes = GradleUtil.projectBuildFilesTypes(project);
        syncStats.setTotalTimeMs(this.syncEndedTimeStamp >= 0L ? this.syncEndedTimeStamp - this.syncStartedTimeStamp : (this.syncSetupStartedTimeStamp >= 0L ? this.syncSetupStartedTimeStamp - this.syncStartedTimeStamp : 0L));
        syncStats.setIdeTimeMs(this.syncEndedTimeStamp < 0L ? -1L : (this.syncSetupStartedTimeStamp < 0L ? -1L : this.syncEndedTimeStamp - this.syncSetupStartedTimeStamp));
        syncStats.setGradleTimeMs(this.syncSetupStartedTimeStamp >= 0L ? this.syncSetupStartedTimeStamp - this.syncStartedTimeStamp : -1L);
        GradleSyncStats.Trigger trigger = this.trigger;
        if (trigger == null) {
            trigger = GradleSyncStats.Trigger.TRIGGER_UNKNOWN;
        }
        syncStats.setTrigger(trigger);
        GradleSyncStats.GradleSyncType gradleSyncType = this.syncType;
        if (gradleSyncType == null) {
            gradleSyncType = GradleSyncStats.GradleSyncType.GRADLE_SYNC_TYPE_UNKNOWN;
        }
        syncStats.setSyncType(gradleSyncType);
        syncStats.setUsesBuildGradle(buildFileTypes.contains(".gradle"));
        syncStats.setUsesBuildGradleKts(buildFileTypes.contains(".kts"));
        if (rootProjectPath != null) {
            Intrinsics.checkNotNullExpressionValue((Object)syncStats, (String)"syncStats");
            GradleSyncEventLoggerKt.access$updateUserRequestedParallelSyncMode(syncStats, project, rootProjectPath);
        }
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable(project, syncStats, event, kind){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ GradleSyncStats.Builder $syncStats$inlined;
            final /* synthetic */ AndroidStudioEvent.Builder $event$inlined;
            final /* synthetic */ AndroidStudioEvent.EventKind $kind$inlined;
            {
                this.$project$inlined = project;
                this.$syncStats$inlined = builder2;
                this.$event$inlined = builder3;
                this.$kind$inlined = eventKind;
            }

            public final T compute() {
                String lastSuccessfulVersion;
                boolean bl = false;
                String lastKnownVersion = GradleUtil.getLastKnownAndroidGradlePluginVersion(this.$project$inlined);
                if (lastKnownVersion != null) {
                    this.$syncStats$inlined.setLastKnownAndroidGradlePluginVersion(lastKnownVersion);
                }
                if ((lastSuccessfulVersion = GradleUtil.getLastSuccessfulAndroidGradlePluginVersion(this.$project$inlined)) != null) {
                    this.$syncStats$inlined.setAndroidGradlePluginVersion(lastSuccessfulVersion);
                }
                this.$event$inlined.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC);
                this.$event$inlined.setKind(this.$kind$inlined);
                if (this.$kind$inlined == AndroidStudioEvent.EventKind.GRADLE_SYNC_ENDED) {
                    Object object = GradleVersions.getInstance().getGradleVersion(this.$project$inlined);
                    if (object == null || (object = object.getVersion()) == null) {
                        object = "";
                    }
                    this.$event$inlined.setGradleVersion((String)object);
                    this.$event$inlined.setKotlinSupport(GradleSyncEventLogger.access$generateSyncEvent$generateKotlinSupport(this.$project$inlined));
                }
                Intrinsics.checkNotNullExpressionValue((Object)this.$event$inlined, (String)"event");
                UsageTrackerUtils.withProjectId(this.$event$inlined, this.$project$inlined);
                this.$event$inlined.setGradleSyncStats(this.$syncStats$inlined.build());
                return (T)Unit.INSTANCE;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
        return event;
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinSupport.Builder generateSyncEvent$generateKotlinSupport(Project $project) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Object kotlinVersion = null;
        Object ktxVersion = null;
        Ordering ordering = Ordering.natural().nullsFirst();
        Module[] moduleArray = ModuleManager.getInstance((Project)$project).getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getInstance(project).modules");
        Object $this$mapNotNull$iv = moduleArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            GradleAndroidModel it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            Module module2 = (Module)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            if (GradleAndroidModel.Companion.get(module2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleAndroidModel model2 = (GradleAndroidModel)element$iv;
            boolean bl = false;
            IdeDependencies dependencies2 = model2.getSelectedMainCompileDependencies();
            kotlinVersion = ordering.max(kotlinVersion, (Object)GradleSyncEventLoggerKt.access$findVersion(dependencies2.getJavaLibraries(), "org.jetbrains.kotlin:kotlin-stdlib"));
            ktxVersion = ordering.max(ktxVersion, (Object)GradleSyncEventLoggerKt.access$findVersion(dependencies2.getAndroidLibraries(), "androidx.core:core-ktx"));
        }
        KotlinSupport.Builder kotlinSupport = KotlinSupport.newBuilder();
        if (kotlinVersion != null) {
            kotlinSupport.setKotlinSupportVersion(String.valueOf(kotlinVersion));
        }
        if (ktxVersion != null) {
            kotlinSupport.setAndroidKtxVersion(String.valueOf(ktxVersion));
        }
        Intrinsics.checkNotNullExpressionValue((Object)kotlinSupport, (String)"kotlinSupport");
        return kotlinSupport;
    }

    public GradleSyncEventLogger() {
        this(null, 1, null);
    }

    public static final /* synthetic */ KotlinSupport.Builder access$generateSyncEvent$generateKotlinSupport(Project $project) {
        return GradleSyncEventLogger.generateSyncEvent$generateKotlinSupport($project);
    }
}

