/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.Projects;
import com.android.tools.idea.concurrency.AndroidIoManager;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.upgrade.AssistantInvoker;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.res.AndroidFileChangeListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;

public class GradleFiles {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final Set<VirtualFile> myChangedFiles = new HashSet<VirtualFile>();
    @NotNull
    private final Set<VirtualFile> myChangedExternalFiles = new HashSet<VirtualFile>();
    @NotNull
    private final Map<VirtualFile, Integer> myFileHashes = new HashMap<VirtualFile, Integer>();
    @NotNull
    private final Set<VirtualFile> myExternalBuildFiles = new HashSet<VirtualFile>();
    @NotNull
    private final FileEditorManagerListener myFileEditorListener;

    @NotNull
    public static GradleFiles getInstance(@NotNull Project project) {
        return (GradleFiles)project.getService(GradleFiles.class);
    }

    private GradleFiles(@NotNull Project project) {
        this.myProject = project;
        final GradleFileChangeListener fileChangeListener = new GradleFileChangeListener(this);
        this.myFileEditorListener = new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                GradleFiles.this.maybeAddOrRemovePsiTreeListener(event.getNewFile(), (PsiTreeChangeListener)fileChangeListener);
            }
        };
        if (this.myProject.isDefault()) {
            return;
        }
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myFileEditorListener);
    }

    private void maybeAddOrRemovePsiTreeListener(@Nullable VirtualFile file2, @NotNull PsiTreeChangeListener fileChangeListener) {
        if (file2 == null || !file2.isValid()) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile == null) {
            return;
        }
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener(fileChangeListener);
        if (this.isGradleFile(psiFile) || this.isExternalBuildFile(psiFile)) {
            PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener(fileChangeListener);
        }
    }

    @NotNull
    @VisibleForTesting
    FileEditorManagerListener getFileEditorListener() {
        return this.myFileEditorListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean hasHashForFile(@NotNull VirtualFile file2) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileHashes.containsKey(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangedFiles() {
        Object object = this.myLock;
        synchronized (object) {
            this.myChangedFiles.clear();
            this.myChangedExternalFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChangedFile(@NotNull VirtualFile file2, boolean isExternal) {
        Object object = this.myLock;
        synchronized (object) {
            if (isExternal) {
                this.myChangedExternalFiles.add(file2);
            } else {
                this.myChangedFiles.add(file2);
            }
        }
    }

    private static void putHashForFile(@NotNull Map<VirtualFile, Integer> map2, @NotNull VirtualFile file2) {
        Integer hash2 = GradleFiles.computeHash(file2);
        if (hash2 != null) {
            map2.put(file2, hash2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeHashesForFiles(@NotNull Map<VirtualFile, Integer> files2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myFileHashes.clear();
            this.myFileHashes.putAll(files2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Integer getStoredHashForFile(@NotNull VirtualFile file2) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileHashes.get(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsChangedFile(@NotNull VirtualFile file2) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myChangedFiles.contains(file2) || this.myChangedExternalFiles.contains(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExternalBuildFiles() {
        Object object = this.myLock;
        synchronized (object) {
            this.myExternalBuildFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeExternalBuildFiles(@NotNull Collection<VirtualFile> externalBuildFiles) {
        Object object = this.myLock;
        synchronized (object) {
            this.myExternalBuildFiles.addAll(externalBuildFiles);
        }
    }

    @Nullable
    private static Integer computeHash(@NotNull VirtualFile file2) {
        if (!file2.isValid()) {
            return null;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(file2);
        return document2 == null ? null : Integer.valueOf(document2.getText().hashCode());
    }

    private boolean areHashesEqual(@NotNull VirtualFile file2) {
        Integer oldHash = this.getStoredHashForFile(file2);
        return oldHash != null && oldHash.equals(GradleFiles.computeHash(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkHashesOfChangedFiles() {
        Object object = this.myLock;
        synchronized (object) {
            return this.filterHashes(this.myChangedFiles) && this.filterHashes(this.myChangedExternalFiles);
        }
    }

    private boolean filterHashes(@NotNull Collection<VirtualFile> files2) {
        boolean status2 = true;
        HashSet<VirtualFile> toRemove = new HashSet<VirtualFile>();
        for (VirtualFile file2 : files2) {
            if (!this.areHashesEqual(file2)) {
                status2 = false;
                continue;
            }
            toRemove.add(file2);
        }
        files2.removeAll(toRemove);
        return status2;
    }

    private void updateFileHashes() {
        Project project = this.myProject;
        if (project.isDisposed()) {
            return;
        }
        ExecutorService executorService = AndroidIoManager.getInstance().getBackgroundDiskIoExecutor();
        ProgressManager progressManager = ProgressManager.getInstance();
        ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
        Application application = ApplicationManager.getApplication();
        HashMap<VirtualFile, Integer> fileHashes = new HashMap<VirtualFile, Integer>();
        Runnable computeWrapperHashRunnable = () -> {
            VirtualFile propertiesFile;
            File propertiesFilePath;
            GradleWrapper gradleWrapper = GradleWrapper.find(project);
            if (gradleWrapper != null && (propertiesFilePath = gradleWrapper.getPropertiesFilePath()).isFile() && (propertiesFile = gradleWrapper.getPropertiesFile()) != null) {
                application.runReadAction(() -> GradleFiles.putHashForFile(fileHashes, propertiesFile));
            }
        };
        Future<?> wrapperHashFuture = executorService.submit(() -> progressManager.executeProcessUnderProgress(computeWrapperHashRunnable, progressIndicator));
        try {
            wrapperHashFuture.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        this.removeExternalBuildFiles();
        ArrayList<VirtualFile> externalBuildFiles = new ArrayList<VirtualFile>();
        ArrayList modules2 = Lists.newArrayList((Object[])ModuleManager.getInstance((Project)project).getModules());
        Consumer<Module> computeHashes = module2 -> {
            NdkModuleModel ndkModuleModel;
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(module2);
            if (buildFile != null) {
                ProgressManager.checkCanceled();
                File path2 = VfsUtilCore.virtualToIoFile((VirtualFile)buildFile);
                if (path2.isFile()) {
                    application.runReadAction(() -> GradleFiles.putHashForFile(fileHashes, buildFile));
                }
            }
            if ((ndkModuleModel = NdkModuleModel.get(module2)) != null) {
                for (File externalBuildFile : ndkModuleModel.getBuildFiles()) {
                    ProgressManager.checkCanceled();
                    if (!externalBuildFile.isFile()) continue;
                    VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)externalBuildFile, (boolean)true);
                    externalBuildFiles.add(virtualFile);
                    if (virtualFile == null) continue;
                    application.runReadAction(() -> GradleFiles.putHashForFile(fileHashes, virtualFile));
                }
            }
        };
        modules2.stream().map(module2 -> executorService.submit(() -> progressManager.executeProcessUnderProgress(() -> computeHashes.accept((Module)module2), progressIndicator))).forEach(future2 -> {
            try {
                future2.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        });
        this.storeExternalBuildFiles(externalBuildFiles);
        String[] fileNames = new String[]{"settings.gradle", "settings.gradle.kts", "gradle.properties"};
        File rootFolderPath = Projects.getBaseDirPath((Project)this.myProject);
        VirtualFile rootFolder = ProjectUtil.guessProjectDir((Project)this.myProject);
        Runnable projectWideFilesRunnable = () -> {
            for (String fileName : fileNames) {
                VirtualFile virtualFile;
                ProgressManager.checkCanceled();
                File filePath = new File(rootFolderPath, fileName);
                if (!filePath.isFile() || (virtualFile = rootFolder.findChild(fileName)) == null || !virtualFile.exists() || virtualFile.isDirectory()) continue;
                application.runReadAction(() -> GradleFiles.putHashForFile(fileHashes, virtualFile));
            }
            ProgressManager.checkCanceled();
            File gradlePath = new File(rootFolderPath, "gradle");
            if (gradlePath.isDirectory()) {
                File[] gradleFiles;
                for (File tomlFile : gradleFiles = gradlePath.listFiles((dir, name) -> name.endsWith(".versions.toml"))) {
                    VirtualFile virtualFile;
                    ProgressManager.checkCanceled();
                    if (!tomlFile.isFile() || (virtualFile = VfsUtil.findFileByIoFile((File)tomlFile, (boolean)false)) == null || !virtualFile.exists() || virtualFile.isDirectory()) continue;
                    application.runReadAction(() -> GradleFiles.putHashForFile(fileHashes, virtualFile));
                }
            }
        };
        if (rootFolder != null) {
            Future<?> projectWideFilesFuture = executorService.submit(() -> progressManager.executeProcessUnderProgress(projectWideFilesRunnable, progressIndicator));
            try {
                projectWideFilesFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        this.storeHashesForFiles(fileHashes);
    }

    private void scheduleUpdateFileHashes() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(this::updateFileHashes);
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(this::updateFileHashes);
        }
    }

    public boolean areGradleFilesModified() {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> !this.checkHashesOfChangedFiles());
    }

    public boolean areExternalBuildFilesModified() {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myLock;
            synchronized (object) {
                return !this.filterHashes(this.myChangedExternalFiles);
            }
        });
    }

    public boolean isGradleFile(@NotNull PsiFile psiFile) {
        return AndroidFileChangeListener.isGradleFile(psiFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExternalBuildFile(@NotNull PsiFile psiFile) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myExternalBuildFiles.contains(psiFile.getVirtualFile());
        }
    }

    public void resetChangedFilesState() {
        this.scheduleUpdateFileHashes();
        this.removeChangedFiles();
    }

    void maybeProcessSyncStarted() {
        if (!this.myProject.isInitialized()) {
            return;
        }
        this.resetChangedFilesState();
    }

    private static class GradleFileChangeListener
    extends PsiTreeChangeAdapter {
        @NotNull
        private final GradleFiles myGradleFiles;

        private GradleFileChangeListener(@NotNull GradleFiles gradleFiles) {
            this.myGradleFiles = gradleFiles;
        }

        public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getChild());
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getChild());
        }

        public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getNewChild(), event.getOldChild());
        }

        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getChild());
        }

        public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getOldChild(), event.getNewChild());
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getChild());
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getChild());
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getNewChild(), event.getOldChild());
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getChild());
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getOldChild(), event.getNewChild());
        }

        private void processEvent(@NotNull PsiTreeChangeEvent event, PsiElement ... elements) {
            PsiFile psiFile = event.getFile();
            if (psiFile == null) {
                return;
            }
            boolean isExternalBuildFile = this.myGradleFiles.isExternalBuildFile(psiFile);
            if (!this.myGradleFiles.isGradleFile(psiFile) && !isExternalBuildFile) {
                return;
            }
            if (this.myGradleFiles.containsChangedFile(psiFile.getVirtualFile())) {
                return;
            }
            if (!this.myGradleFiles.myProject.isInitialized() || !PsiManager.getInstance((Project)this.myGradleFiles.myProject).isInProject((PsiElement)psiFile)) {
                return;
            }
            boolean foundChange = false;
            for (PsiElement element2 : elements) {
                if (element2 == null || element2 instanceof PsiWhiteSpace || element2 instanceof PsiComment || element2.getNode().getElementType().equals(GroovyTokenTypes.mNLS) && (element2.getParent() == null || element2.getParent() instanceof GrCodeBlock || element2.getParent() instanceof PsiFile)) continue;
                foundChange = true;
                break;
            }
            if (foundChange) {
                this.myGradleFiles.addChangedFile(psiFile.getVirtualFile(), isExternalBuildFile);
                EditorNotifications.getInstance((Project)psiFile.getProject()).updateNotifications(psiFile.getVirtualFile());
                ((AssistantInvoker)this.myGradleFiles.myProject.getService(AssistantInvoker.class)).expireProjectUpgradeNotifications(this.myGradleFiles.myProject);
            }
        }
    }

    public static class UpdateHashesStartupActivity
    implements StartupActivity.DumbAware {
        public void runActivity(@NotNull Project project) {
            GradleFiles.getInstance(project).scheduleUpdateFileHashes();
        }
    }
}

