/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.Version;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.sync.AgpVersionIncompatible;
import com.android.tools.idea.gradle.project.sync.AgpVersionTooNew;
import com.android.tools.idea.gradle.project.sync.AgpVersionTooOld;
import com.android.tools.idea.gradle.project.sync.SyncActionOptions;
import com.android.tools.idea.gradle.project.upgrade.AndroidGradlePluginCompatibility;
import com.android.tools.idea.gradle.project.upgrade.AndroidGradlePluginCompatibilityKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"checkAgpVersionCompatibility", "", "agpVersionString", "", "syncOptions", "Lcom/android/tools/idea/gradle/project/sync/SyncActionOptions;", "intellij.android.projectSystem.gradle.sync"})
public final class AgpCompatibilityKt {
    public static final void checkAgpVersionCompatibility(@NotNull String agpVersionString, @NotNull SyncActionOptions syncOptions) {
        Intrinsics.checkNotNullParameter((Object)agpVersionString, (String)"agpVersionString");
        Intrinsics.checkNotNullParameter((Object)syncOptions, (String)"syncOptions");
        AgpVersion agpVersion = AgpVersion.Companion.parse(agpVersionString);
        String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        AgpVersion latestKnown = AgpVersion.Companion.parse(string);
        switch (WhenMappings.$EnumSwitchMapping$0[AndroidGradlePluginCompatibilityKt.computeAndroidGradlePluginCompatibility(agpVersion, latestKnown).ordinal()]) {
            case 1: {
                throw new AgpVersionTooOld(agpVersion);
            }
            case 2: {
                if (syncOptions.getFlags().getStudioFlagDisableForcedUpgrades()) break;
                throw new AgpVersionIncompatible(agpVersion);
            }
            case 3: {
                if (syncOptions.getFlags().getStudioFlagDisableForcedUpgrades()) break;
                throw new AgpVersionTooNew(agpVersion);
            }
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidGradlePluginCompatibility.values().length];
            nArray[AndroidGradlePluginCompatibility.BEFORE_MINIMUM.ordinal()] = 1;
            nArray[AndroidGradlePluginCompatibility.DIFFERENT_PREVIEW.ordinal()] = 2;
            nArray[AndroidGradlePluginCompatibility.AFTER_MAXIMUM.ordinal()] = 3;
            nArray[AndroidGradlePluginCompatibility.COMPATIBLE.ordinal()] = 4;
            nArray[AndroidGradlePluginCompatibility.DEPRECATED.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

