/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.tools.idea.gradle.model.ndk.v1.IdeNativeArtifact;
import com.android.tools.idea.gradle.model.ndk.v1.IdeNativeFile;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NdkVariant {
    @NotNull
    private final String myVariantAbi;
    @NotNull
    private final Map<String, IdeNativeArtifact> myArtifactsByName;
    private final boolean myExportedHeadersSupported;

    public NdkVariant() {
        this.myVariantAbi = "";
        this.myArtifactsByName = Collections.emptyMap();
        this.myExportedHeadersSupported = false;
    }

    NdkVariant(@NotNull String variantAbi, boolean exportedHeadersSupported) {
        this.myVariantAbi = variantAbi;
        this.myArtifactsByName = new HashMap<String, IdeNativeArtifact>();
        this.myExportedHeadersSupported = exportedHeadersSupported;
    }

    void addArtifact(@NotNull IdeNativeArtifact artifact2) {
        this.myArtifactsByName.put(artifact2.getName(), artifact2);
    }

    @NotNull
    public String getName() {
        return this.myVariantAbi;
    }

    @NotNull
    public Collection<File> getSourceFolders() {
        LinkedHashSet<File> sourceFolders2 = new LinkedHashSet<File>();
        for (IdeNativeArtifact artifact2 : this.getArtifacts()) {
            if (this.myExportedHeadersSupported) {
                sourceFolders2.addAll(artifact2.getExportedHeaders());
            }
            for (IdeNativeFile sourceFile : artifact2.getSourceFiles()) {
                File parentFile = sourceFile.getFilePath().getParentFile();
                if (parentFile == null) continue;
                sourceFolders2.add(parentFile);
            }
        }
        return ImmutableList.copyOf(sourceFolders2);
    }

    @NotNull
    public Collection<IdeNativeArtifact> getArtifacts() {
        return this.myArtifactsByName.values();
    }
}

