/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 6L;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final List<String> myTaskNames;
    @NotNull
    private final String myGradlePath;
    @NotNull
    private final File myRootFolderPath;
    @NotNull
    private final List<String> myGradlePlugins;
    @Nullable
    private final File myBuildFilePath;
    @Nullable
    private final String myGradleVersion;
    @Nullable
    private final String myAgpVersion;
    @Nullable
    private final Boolean mySafeArgsJava;
    @Nullable
    private final Boolean mySafeArgsKotlin;

    public GradleModuleModel(@NotNull String moduleName2, @NotNull GradleProject gradleProject, @Nullable File buildFilePath, @Nullable String gradleVersion2, @Nullable String agpVersion, @Nullable Boolean safeArgsJava, @Nullable Boolean safeArgsKotlin) {
        this(moduleName2, GradleModuleModel.getTaskNames(gradleProject), gradleProject.getPath(), gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir(), GradleModuleModel.getBackwardsCompatiblePlugins(safeArgsJava, safeArgsKotlin), buildFilePath, gradleVersion2, agpVersion, safeArgsJava, safeArgsKotlin);
    }

    @PropertyMapping(value={"myModuleName", "myTaskNames", "myGradlePath", "myRootFolderPath", "myGradlePlugins", "myBuildFilePath", "myGradleVersion", "myAgpVersion", "mySafeArgsJava", "mySafeArgsKotlin"})
    @VisibleForTesting
    public GradleModuleModel(@NotNull String moduleName2, @NotNull List<String> taskNames, @NotNull String gradlePath, @NotNull File rootFolderPath, @NotNull List<String> gradlePlugins, @Nullable File buildFilePath, @Nullable String gradleVersion2, @Nullable String agpVersion, @Nullable Boolean safeArgsJava, @Nullable Boolean safeArgsKotlin) {
        this.myModuleName = moduleName2;
        this.myTaskNames = taskNames;
        this.myGradlePath = gradlePath;
        this.myRootFolderPath = rootFolderPath;
        this.myGradlePlugins = gradlePlugins.isEmpty() ? GradleModuleModel.getBackwardsCompatiblePlugins(safeArgsJava, safeArgsKotlin) : gradlePlugins;
        this.myBuildFilePath = buildFilePath;
        this.myGradleVersion = gradleVersion2;
        this.myAgpVersion = agpVersion;
        this.mySafeArgsJava = safeArgsJava;
        this.mySafeArgsKotlin = safeArgsKotlin;
    }

    @NotNull
    private static List<String> getTaskNames(@NotNull GradleProject gradleProject) {
        ArrayList<String> taskNames = new ArrayList<String>();
        DomainObjectSet tasks = gradleProject.getTasks();
        if (!tasks.isEmpty()) {
            for (GradleTask task2 : tasks) {
                String name = task2.getName();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                taskNames.add(task2.getProject().getPath() + ":" + task2.getName());
            }
        }
        return taskNames;
    }

    @NotNull
    private static List<String> getBackwardsCompatiblePlugins(@Nullable Boolean safeArgsJava, @Nullable Boolean safeArgsKotlin) {
        ArrayList<String> result2 = new ArrayList<String>();
        if (safeArgsJava != null && safeArgsJava.booleanValue()) {
            result2.add("androidx.navigation.safeargs.gradle.SafeArgsJavaPlugin");
        }
        if (safeArgsKotlin != null && safeArgsKotlin.booleanValue()) {
            result2.add("androidx.navigation.safeargs.gradle.SafeArgsKotlinPlugin");
        }
        return result2;
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public String getGradlePath() {
        return this.myGradlePath;
    }

    @NotNull
    public File getRootFolderPath() {
        return this.myRootFolderPath;
    }

    @NotNull
    public List<String> getTaskNames() {
        return this.myTaskNames;
    }

    @Nullable
    public VirtualFile getBuildFile() {
        return this.myBuildFilePath != null ? VfsUtil.findFileByIoFile((File)this.myBuildFilePath, (boolean)true) : null;
    }

    @Nullable
    public File getBuildFilePath() {
        return this.myBuildFilePath;
    }

    @Nullable
    public String getGradleVersion() {
        return this.myGradleVersion;
    }

    @Nullable
    public String getAgpVersion() {
        return this.myAgpVersion;
    }

    @Deprecated
    @NotNull
    public List<String> getGradlePlugins() {
        return this.myGradlePlugins;
    }

    public boolean hasSafeArgsJavaPlugin() {
        if (this.mySafeArgsJava != null) {
            return this.mySafeArgsJava;
        }
        return this.myGradlePlugins.contains("androidx.navigation.safeargs.gradle.SafeArgsJavaPlugin");
    }

    public boolean hasSafeArgsKotlinPlugin() {
        if (this.mySafeArgsKotlin != null) {
            return this.mySafeArgsKotlin;
        }
        return this.myGradlePlugins.contains("androidx.navigation.safeargs.gradle.SafeArgsKotlinPlugin");
    }
}

