/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.tools.idea.projectsystem.ProjectSystemBuildManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class ClassFileUtil {
    private ClassFileUtil() {
    }

    public static boolean isClassSourceFileNewerThanClassClassFile(@NotNull Module module2, @NotNull String fqcn, @NotNull VirtualFile classFile) {
        Long projectBuildTimestamp;
        Project project = module2.getProject();
        GlobalSearchScope scope2 = module2.getModuleWithDependenciesScope();
        VirtualFile sourceFile = (VirtualFile)ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(fqcn, scope2);
            if (psiClass == null) {
                return null;
            }
            PsiFile psiFile = psiClass.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            return psiFile.getVirtualFile();
        });
        if (sourceFile == null) {
            return false;
        }
        if (FileDocumentManager.getInstance().isFileModified(sourceFile)) {
            return true;
        }
        long sourceFileModified = sourceFile.getTimeStamp();
        long lastBuildTimestamp = classFile.getTimeStamp();
        ProjectSystemBuildManager.BuildResult buildResult = ProjectSystemUtil.getProjectSystem(project).getBuildManager().getLastBuildResult();
        Long l = projectBuildTimestamp = buildResult.getStatus() != ProjectSystemBuildManager.BuildStatus.UNKNOWN ? Long.valueOf(buildResult.getTimestampMillis()) : null;
        if (projectBuildTimestamp != null) {
            lastBuildTimestamp = projectBuildTimestamp;
        }
        return sourceFileModified > lastBuildTimestamp && lastBuildTimestamp > 0L;
    }
}

