/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.ide.common.repository.AgpVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModelFeatures {
    @Nullable
    private final AgpVersion myModelVersion;
    private final boolean myBuildOutputFileSupported;
    private final boolean myPostBuildSyncSupported;

    public AndroidModelFeatures(@Nullable AgpVersion modelVersion) {
        this.myModelVersion = modelVersion;
        this.myBuildOutputFileSupported = this.modelVersionIsAtLeast("4.1.0");
        this.myPostBuildSyncSupported = modelVersion != null ? this.modelVersionIsAtLeast("3.0.0") && !this.modelVersionIsAtLeast("4.1.0") : false;
    }

    private boolean modelVersionIsAtLeast(@NotNull String revision) {
        return this.myModelVersion != null && this.myModelVersion.compareIgnoringQualifiers(revision) >= 0;
    }

    public boolean isPostBuildSyncSupported() {
        return this.myPostBuildSyncSupported;
    }

    public boolean isBuildOutputFileSupported() {
        return this.myBuildOutputFileSupported;
    }
}

