/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/ConfigurationCacheErrorParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.android.projectSystem.gradle"})
public final class ConfigurationCacheErrorParser
implements BuildOutputParser {
    public boolean parse(@NotNull String line2, @NotNull BuildOutputInstantReader reader2, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (!StringsKt.startsWith$default((String)line2, (String)"FAILURE: Build failed with an exception.", (boolean)false, (int)2, null)) {
            return false;
        }
        CharSequence charSequence = reader2.readLine();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return false;
        }
        String whereOrWhatLine = reader2.readLine();
        if (Intrinsics.areEqual((Object)whereOrWhatLine, (Object)"* Where:")) {
            CharSequence charSequence2 = reader2.readLine();
            if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
                return false;
            }
            charSequence2 = reader2.readLine();
            if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                return false;
            }
            whereOrWhatLine = reader2.readLine();
        }
        if (!Intrinsics.areEqual((Object)whereOrWhatLine, (Object)"* What went wrong:")) {
            return false;
        }
        String string = reader2.readLine();
        if (string == null) {
            return false;
        }
        String firstDescriptionLine = string;
        if (!Intrinsics.areEqual((Object)firstDescriptionLine, (Object)"Configuration cache problems found in this build.")) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder().append(firstDescriptionLine);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringBuilder description2 = StringsKt.appendln((StringBuilder)stringBuilder);
        while (true) {
            String descriptionLine;
            if (reader2.readLine() == null) {
                return false;
            }
            if (Intrinsics.areEqual((Object)descriptionLine, (Object)"* Try:")) break;
            StringBuilder stringBuilder2 = description2.append(descriptionLine);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
        }
        BuildIssue buildIssue2 = new BuildIssue(description2){
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            @NotNull
            private final String title;
            {
                String string = $description.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"description.toString()");
                this.description = ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
                this.quickFixes = CollectionsKt.emptyList();
                this.title = "Configuration cache problems found in this build.";
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
        };
        messageConsumer.accept((BuildEvent)new BuildIssueEventImpl(reader2.getParentEventId(), buildIssue2, MessageEvent.Kind.ERROR));
        return true;
    }
}

