/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.build.OutputFile;
import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.ProjectBuildOutput;
import com.android.builder.model.VariantBuildOutput;
import com.android.tools.idea.gradle.actions.BuildsToPathsMapper;
import com.android.tools.idea.gradle.model.IdeAndroidProjectType;
import com.android.tools.idea.gradle.model.IdeBuildTasksAndOutputInformation;
import com.android.tools.idea.gradle.model.IdeVariantBuildInformation;
import com.android.tools.idea.gradle.project.build.invoker.AssembleInvocationResult;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.util.BuildOutputUtil;
import com.android.tools.idea.gradle.util.OutputType;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.intellij.openapi.module.Module;
import com.intellij.util.containers.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildsToPathsMapperImpl
extends BuildsToPathsMapper {
    @Override
    @NotNull
    public Map<String, File> getBuildsToPaths(@NotNull AssembleInvocationResult assembleResult, @NotNull List<String> buildVariants, @NotNull Collection<Module> modules2, boolean isAppBundle) {
        boolean isSigned;
        boolean bl = isSigned = !buildVariants.isEmpty();
        if (isSigned) assert (modules2.size() == 1);
        PostBuildModel postBuildModel = null;
        TreeMap<String, File> buildsToPathsCollector = new TreeMap<String, File>();
        List<OutputBuildAction.PostBuildProjectModels> postBuildProjectModels = assembleResult.getInvocationResult().getModels().stream().filter(it -> it instanceof OutputBuildAction.PostBuildProjectModels).map(it -> (OutputBuildAction.PostBuildProjectModels)it).collect(Collectors.toList());
        if (!postBuildProjectModels.isEmpty()) {
            postBuildModel = new PostBuildModel(postBuildProjectModels.toArray(new OutputBuildAction.PostBuildProjectModels[0]));
        }
        for (Module module2 : modules2) {
            GradleAndroidModel androidModel = GradleAndroidModel.get(module2);
            if (androidModel == null) continue;
            if (!isSigned) {
                buildVariants = ImmutableList.singleton((Object)androidModel.getSelectedVariant().getName());
            }
            for (String buildVariant : buildVariants) {
                BuildsToPathsMapperImpl.collectBuildsToPaths(androidModel, postBuildModel, module2, buildVariant, buildsToPathsCollector, isAppBundle, isSigned);
            }
        }
        return buildsToPathsCollector;
    }

    private static void collectBuildsToPaths(@NotNull GradleAndroidModel androidModel, @Nullable PostBuildModel postBuildModel, @NotNull Module module2, @NotNull String buildVariant, @NotNull Map<String, File> buildsToPathsCollector, boolean isAppBundle, boolean isSigned) {
        File outputFolderOrFile = null;
        if (androidModel.getFeatures().isBuildOutputFileSupported()) {
            String outputListingFile;
            OutputType outputType = isAppBundle ? OutputType.Bundle : OutputType.Apk;
            IdeBuildTasksAndOutputInformation outputInformation = androidModel.getAndroidProject().getVariantsBuildInformation().stream().filter(it -> it.getVariantName().equals(buildVariant)).findFirst().map(IdeVariantBuildInformation::getBuildInformation).orElse(null);
            List<File> outputFiles = null;
            if (outputInformation != null && (outputListingFile = BuildOutputUtil.getOutputListingFileOrLogError(outputInformation, outputType)) != null) {
                outputFiles = BuildOutputUtil.getOutputFilesFromListingFile(outputListingFile);
            }
            outputFolderOrFile = outputFiles != null ? (outputFiles.size() > 1 ? outputFiles.get(0).getParentFile() : (!outputFiles.isEmpty() ? outputFiles.get(0) : null)) : null;
        } else if (postBuildModel != null) {
            if (androidModel.getAndroidProject().getProjectType() == IdeAndroidProjectType.PROJECT_TYPE_APP || androidModel.getAndroidProject().getProjectType() == IdeAndroidProjectType.PROJECT_TYPE_DYNAMIC_FEATURE) {
                outputFolderOrFile = isAppBundle ? BuildsToPathsMapperImpl.tryToGetOutputPostBuildBundleFile(module2, postBuildModel, buildVariant) : BuildsToPathsMapperImpl.tryToGetOutputPostBuildApkFile(module2, postBuildModel, buildVariant);
            } else if (androidModel.getAndroidProject().getProjectType() == IdeAndroidProjectType.PROJECT_TYPE_INSTANTAPP) {
                outputFolderOrFile = BuildsToPathsMapperImpl.tryToGetOutputPostBuildInstantApp(module2, postBuildModel, buildVariant);
            }
        }
        if (outputFolderOrFile == null) {
            return;
        }
        buildsToPathsCollector.put(isSigned ? buildVariant : module2.getName(), outputFolderOrFile);
    }

    @Nullable
    private static File tryToGetOutputPostBuildApkFile(@NotNull Module module2, @NotNull PostBuildModel postBuildModel, @NotNull String buildVariant) {
        ProjectBuildOutput projectBuildOutput = postBuildModel.findProjectBuildOutput(BuildsToPathsMapperImpl.getGradlePath(module2));
        if (projectBuildOutput == null) {
            return null;
        }
        for (VariantBuildOutput variantBuildOutput : projectBuildOutput.getVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(buildVariant)) continue;
            Collection outputs = variantBuildOutput.getOutputs();
            File outputFolderOrApk = ((OutputFile)outputs.iterator().next()).getOutputFile();
            if (outputs.size() > 1) {
                return outputFolderOrApk.getParentFile();
            }
            return outputFolderOrApk;
        }
        return null;
    }

    @Nullable
    private static String getGradlePath(@NotNull Module module2) {
        GradleProjectPath gradleProjectPath = GradleProjectPathKt.getGradleProjectPath(module2);
        return gradleProjectPath != null ? gradleProjectPath.getPath() : null;
    }

    @Nullable
    private static File tryToGetOutputPostBuildBundleFile(@NotNull Module module2, @NotNull PostBuildModel postBuildModel, @NotNull String buildVariant) {
        AppBundleProjectBuildOutput appBundleProjectBuildOutput = postBuildModel.findAppBundleProjectBuildOutput(BuildsToPathsMapperImpl.getGradlePath(module2));
        if (appBundleProjectBuildOutput == null) {
            return null;
        }
        for (AppBundleVariantBuildOutput variantBuildOutput : appBundleProjectBuildOutput.getAppBundleVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(buildVariant)) continue;
            return variantBuildOutput.getBundleFile();
        }
        return null;
    }

    @Nullable
    private static File tryToGetOutputPostBuildInstantApp(@NotNull Module module2, @NotNull PostBuildModel postBuildModel, @NotNull String buildVariant) {
        InstantAppProjectBuildOutput instantAppProjectBuildOutput = postBuildModel.findInstantAppProjectBuildOutput(BuildsToPathsMapperImpl.getGradlePath(module2));
        if (instantAppProjectBuildOutput == null) {
            return null;
        }
        for (InstantAppVariantBuildOutput variantBuildOutput : instantAppProjectBuildOutput.getInstantAppVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(buildVariant)) continue;
            return variantBuildOutput.getOutput().getOutputFile();
        }
        return null;
    }
}

