/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.AndroidStudioGradleInstallationManager;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.LegacyAndroidProjects;
import com.android.tools.idea.gradle.project.sync.hyperlink.SelectJdkFromFileSystemHyperlink;
import com.android.tools.idea.gradle.service.notification.GradleJvmNotificationExtension;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a(\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0012"}, d2={"generateInvalidGradleJdkLinks", "Ljava/util/ArrayList;", "Lcom/android/tools/idea/project/hyperlink/NotificationHyperlink;", "Lkotlin/collections/ArrayList;", "project", "Lcom/intellij/openapi/project/Project;", "notifyOnInvalidGradleJDKEnv", "", "notifyOnInvalidGradleJdk", "", "notifyOnLegacyAndroidProject", "showBalloon", "errorReason", "", "errorText", "notificationType", "Lcom/intellij/notification/NotificationType;", "showNeededNotifications", "intellij.android.projectSystem.gradle"})
public final class ProjectNotificationsUtilsKt {
    public static final void showNeededNotifications(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (IdeInfo.getInstance().isAndroidStudio()) {
            ProjectNotificationsUtilsKt.notifyOnLegacyAndroidProject(project);
            ProjectNotificationsUtilsKt.notifyOnInvalidGradleJDKEnv(project);
            if (ProjectNotificationsUtilsKt.notifyOnInvalidGradleJdk(project)) {
                AndroidStudioGradleInstallationManager.setJdkAsEmbedded(project);
            }
        }
    }

    private static final void notifyOnLegacyAndroidProject(Project project) {
        LegacyAndroidProjects legacyAndroidProjects = new LegacyAndroidProjects(project);
        if (AndroidProjectInfo.getInstance(project).isLegacyIdeaAndroidProject() && !AndroidProjectInfo.getInstance(project).isApkProject()) {
            legacyAndroidProjects.trackProject();
            if (!GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
                legacyAndroidProjects.showMigrateToGradleWarning();
            }
        }
    }

    private static final void notifyOnInvalidGradleJDKEnv(Project project) {
        IdeSdks ideSdks = IdeSdks.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"getInstance()");
        IdeSdks ideSdks2 = ideSdks;
        if (ideSdks2.isJdkEnvVariableDefined() && !ideSdks2.isJdkEnvVariableValid()) {
            String msg = "STUDIO_GRADLE_JDK is being ignored since it is set to an invalid JDK Location:\n" + ideSdks2.getEnvVariableJdkValue();
            AndroidNotification androidNotification = AndroidNotification.getInstance(project);
            NotificationHyperlink[] notificationHyperlinkArray = new NotificationHyperlink[1];
            SelectJdkFromFileSystemHyperlink selectJdkFromFileSystemHyperlink = SelectJdkFromFileSystemHyperlink.create(project);
            Intrinsics.checkNotNull((Object)((Object)selectJdkFromFileSystemHyperlink));
            notificationHyperlinkArray[0] = selectJdkFromFileSystemHyperlink;
            androidNotification.showBalloon("", msg, NotificationType.WARNING, notificationHyperlinkArray);
        }
    }

    @VisibleForTesting
    public static final boolean notifyOnInvalidGradleJdk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleJvmNotificationExtension.InvalidJdkReasonWithMessage jdkInvalidReason = GradleJvmNotificationExtension.Companion.getInvalidJdkReason(project);
        if (jdkInvalidReason != null) {
            IdeSdks ideSdks = IdeSdks.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"getInstance()");
            IdeSdks ideSdks2 = ideSdks;
            Path embeddedJdkPath = ideSdks2.getEmbeddedJdkPath();
            String errorResolution = null;
            NotificationType notificationType = null;
            boolean shouldUseEmbedded = false;
            if (embeddedJdkPath != null && ideSdks2.validateJdkPath(embeddedJdkPath) != null) {
                errorResolution = "Gradle JVM setting was changed to use Embedded JDK.";
                notificationType = NotificationType.WARNING;
                shouldUseEmbedded = true;
            } else {
                errorResolution = "Having an incorrect Gradle JDK may result in unresolved symbols and problems when running Gradle tasks.";
                notificationType = NotificationType.ERROR;
                shouldUseEmbedded = false;
            }
            ProjectNotificationsUtilsKt.showBalloon(project, jdkInvalidReason.getMessage(), errorResolution, notificationType);
            GradleJvmNotificationExtension.Companion.reportInvalidJdkReasonToUsageTracker(project, jdkInvalidReason.getReason());
            return shouldUseEmbedded;
        }
        return false;
    }

    private static final void showBalloon(Project project, String errorReason, String errorText, NotificationType notificationType) {
        ArrayList<NotificationHyperlink> quickFixes = ProjectNotificationsUtilsKt.generateInvalidGradleJdkLinks(project);
        Collection $this$toTypedArray$iv = quickFixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        NotificationHyperlink[] notificationHyperlinkArray = thisCollection$iv.toArray(new NotificationHyperlink[0]);
        if (notificationHyperlinkArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        NotificationHyperlink[] notificationHyperlinkArray2 = notificationHyperlinkArray;
        AndroidNotification.getInstance(project).showBalloon(errorReason, errorText, notificationType, Arrays.copyOf(notificationHyperlinkArray2, notificationHyperlinkArray2.length));
    }

    @VisibleForTesting
    @NotNull
    public static final ArrayList<NotificationHyperlink> generateInvalidGradleJdkLinks(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
        SelectJdkFromFileSystemHyperlink selectJdkLink = SelectJdkFromFileSystemHyperlink.create(project);
        if (selectJdkLink != null) {
            quickFixes.add(selectJdkLink);
        }
        return quickFixes;
    }
}

