/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleProjectInfo {
    @NotNull
    private final Project myProject;
    private volatile boolean myNewProject;
    private volatile boolean myImportedProject;
    private final ProjectFacetManager myFacetManager;
    private volatile boolean mySkipStartupActivity;
    private static final Key<Set<File>> PROJECTS_BEING_INITIALIZED = Key.create((String)"PROJECTS_BEING_INITIALIZED");

    @NotNull
    public static GradleProjectInfo getInstance(@NotNull Project project) {
        return (GradleProjectInfo)project.getService(GradleProjectInfo.class);
    }

    public GradleProjectInfo(@NotNull Project project) {
        this.myProject = project;
        this.myFacetManager = ProjectFacetManager.getInstance((Project)this.myProject);
    }

    public boolean isNewProject() {
        return this.myNewProject;
    }

    public void setNewProject(boolean newProject) {
        this.myNewProject = newProject;
    }

    public boolean isSkipStartupActivity() {
        return this.mySkipStartupActivity;
    }

    public void setSkipStartupActivity(boolean skipStartupActivity) {
        this.mySkipStartupActivity = skipStartupActivity;
    }

    public boolean isBuildWithGradle() {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return false;
            }
            if (GradleProjectInfo.isBeingInitializedAsGradleProject(this.myProject)) {
                return true;
            }
            if (Arrays.stream(ModuleManager.getInstance((Project)this.myProject).getModules()).anyMatch(it -> ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (Module)it))) {
                return true;
            }
            if (this.myFacetManager.hasFacets(GradleFacet.getFacetTypeId())) {
                return true;
            }
            if (GradleSyncState.getInstance(this.myProject).getLastSyncFinishedTimeStamp() != -1L) {
                return true;
            }
            if (!GradleSettings.getInstance((Project)this.myProject).getLinkedProjectsSettings().isEmpty()) {
                return true;
            }
            return this.hasTopLevelGradleFile();
        });
    }

    public boolean hasTopLevelGradleFile() {
        if (this.myProject.isDefault()) {
            return false;
        }
        VirtualFile baseDir2 = this.myProject.getBaseDir();
        if (baseDir2 != null) {
            return GradleUtil.findGradleBuildFile(baseDir2) != null || GradleUtil.findGradleSettingsFile(baseDir2) != null;
        }
        return false;
    }

    @NotNull
    public List<Module> getAndroidModules() {
        ImmutableList.Builder modules2 = ImmutableList.builder();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module2 : ProjectSystemUtil.getAndroidModulesForDisplay(this.myProject, null)) {
                if (AndroidFacet.getInstance((Module)module2) == null || GradleFacet.getInstance(module2) == null) continue;
                modules2.add((Object)module2);
            }
        });
        return modules2.build();
    }

    @NotNull
    public Module[] getModulesToBuildFromSelection(@Nullable DataContext dataContext) {
        Module[] modules2;
        if (dataContext == null) {
            ProjectView projectView = ProjectView.getInstance((Project)this.myProject);
            AbstractProjectViewPane pane = projectView.getCurrentProjectViewPane();
            if (pane != null) {
                JComponent treeComponent = pane.getComponentToFocus();
                dataContext = DataManager.getInstance().getDataContext((Component)treeComponent);
            } else {
                return Module.EMPTY_ARRAY;
            }
        }
        if ((modules2 = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null) {
            if (modules2.length == 1 && GradleProjectInfo.isProjectModule(modules2[0])) {
                return ModuleManager.getInstance((Project)this.myProject).getModules();
            }
            return modules2;
        }
        Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        if (module2 != null) {
            Module[] moduleArray;
            if (GradleProjectInfo.isProjectModule(module2)) {
                moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = module2;
            }
            return moduleArray;
        }
        return Module.EMPTY_ARRAY;
    }

    public static AccessToken beginInitializingGradleProjectAt(final @NotNull File projectFolderPath) {
        UserDataHolderEx userData = (UserDataHolderEx)ApplicationManager.getApplication();
        final Set projectsBeingInitialized = (Set)userData.putUserDataIfAbsent(PROJECTS_BEING_INITIALIZED, (Object)ContainerUtil.newConcurrentSet());
        if (!projectsBeingInitialized.add(projectFolderPath)) {
            throw new IllegalStateException("Cannot initialize two projects at the same location at the same time. Project location: " + projectFolderPath);
        }
        return new AccessToken(){

            public void finish() {
                projectsBeingInitialized.remove(projectFolderPath);
            }
        };
    }

    private static boolean isBeingInitializedAsGradleProject(@NotNull Project project) {
        String basePath = project.getBasePath();
        if (basePath == null) {
            return false;
        }
        Set projectsBeingInitialized = (Set)ApplicationManager.getApplication().getUserData(PROJECTS_BEING_INITIALIZED);
        if (projectsBeingInitialized == null) {
            return false;
        }
        return projectsBeingInitialized.contains(new File(basePath));
    }

    private static boolean isProjectModule(@NotNull Module module2) {
        File moduleRootFolderPath = AndroidRootUtil.findModuleRootFolderPath(module2);
        if (moduleRootFolderPath == null) {
            return false;
        }
        String basePath = module2.getProject().getBasePath();
        return basePath != null && FileUtil.filesEqual((File)moduleRootFolderPath, (File)new File(basePath)) && !GradleFacet.isAppliedTo(module2);
    }
}

