/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.sdk.IdeSdks;
import com.android.utils.FileUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.gradle.internal.impldep.com.amazonaws.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class AndroidStudioGradleInstallationManager
extends GradleInstallationManager {
    @Nullable
    public String getGradleJvmPath(@NotNull Project project, @NotNull String linkedProjectPath) {
        String settingsJvm;
        IdeSdks ideSdks = IdeSdks.getInstance();
        if (IdeSdks.getInstance().isUsingEnvVariableJdk()) {
            return ideSdks.getEnvVariableJdkValue();
        }
        GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(linkedProjectPath);
        if (settings != null && (settingsJvm = settings.getGradleJvm()) != null) {
            switch (settingsJvm) {
                case "STUDIO_GRADLE_JDK": {
                    if (IdeSdks.getInstance().isJdkEnvVariableValid()) {
                        return ideSdks.getEnvVariableJdkValue();
                    }
                }
                case "Embedded JDK": {
                    Path embeddedPath = ideSdks.getEmbeddedJdkPath();
                    if (embeddedPath != null) {
                        return embeddedPath.toAbsolutePath().toString();
                    }
                }
                case "Android Studio java home": {
                    String javaHome = IdeSdks.getJdkFromJavaHome();
                    if (StringUtils.isNullOrEmpty((String)javaHome)) break;
                    return javaHome;
                }
            }
        }
        return super.getGradleJvmPath(project, linkedProjectPath);
    }

    public boolean isUsingJavaHomeJdk(@NotNull Project project) {
        String basePath = project.getBasePath();
        if (basePath == null) {
            return false;
        }
        String projectJvmPath = this.getGradleJvmPath(project, basePath);
        if (projectJvmPath == null) {
            return false;
        }
        String javaHome = IdeSdks.getJdkFromJavaHome();
        if (javaHome == null) {
            return false;
        }
        return FileUtils.isSameFile((File)new File(projectJvmPath), (File)new File(javaHome));
    }

    public static void setJdkAsJavaHome(@NotNull Project project, @NotNull String jdkPath) {
        AndroidStudioGradleInstallationManager.setNamedJdk(project, jdkPath, "Android Studio java home");
    }

    public static void setJdkAsEmbedded(@NotNull Project project) {
        Path embeddedJdkPath = IdeSdks.getInstance().getEmbeddedJdkPath();
        AndroidStudioGradleInstallationManager.setNamedJdk(project, embeddedJdkPath.toAbsolutePath().toString(), "Embedded JDK");
    }

    public static void setJdkAsProjectJdk(@NotNull Project project, @NotNull String jdkPath) {
        GradleProjectSettings projectSettings;
        Sdk jdk = IdeSdks.getInstance().setJdkPath(Paths.get(jdkPath, new String[0]));
        ProjectRootManager.getInstance((Project)project).setProjectSdk(jdk);
        String basePath = project.getBasePath();
        if (basePath != null && (projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(basePath)) != null) {
            projectSettings.setGradleJvm("#USE_PROJECT_JDK");
        }
    }

    private static void setNamedJdk(@NotNull Project project, @NotNull String jdkPath, @NotNull String name) {
        String basePath = project.getBasePath();
        if (basePath != null) {
            Sdk jdk = IdeSdks.findOrCreateJdk(name, Paths.get(jdkPath, new String[0]));
            GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(basePath);
            if (projectSettings != null) {
                projectSettings.setGradleJvm(name);
                return;
            }
        }
        AndroidStudioGradleInstallationManager.setJdkAsProjectJdk(project, jdkPath);
    }
}

