/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.model.IdeAndroidArtifact;
import com.android.tools.idea.gradle.model.IdeBaseArtifact;
import com.android.tools.idea.gradle.model.IdeJavaArtifact;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleOrderEnumeratorHandler;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;

public class AndroidGradleOrderEnumeratorHandlerFactory
extends GradleOrderEnumeratorHandler.FactoryImpl {
    public boolean isApplicable(@NotNull Module module2) {
        return GradleAndroidModel.get(module2) != null;
    }

    @NotNull
    public GradleOrderEnumeratorHandler createHandler(@NotNull Module module2) {
        boolean shouldRecurse;
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
        boolean bl = shouldRecurse = GradleAndroidModel.get(module2) != null;
        if (rootProjectPath != null && !shouldRecurse) {
            String gradleVersion2 = GradleLocalSettings.getInstance((Project)module2.getProject()).getGradleVersion(rootProjectPath);
            shouldRecurse = gradleVersion2 != null && GradleVersion.version((String)gradleVersion2).compareTo(GradleVersion.version((String)"2.5")) < 0;
        }
        final boolean finalShouldRecurse = shouldRecurse;
        return new GradleOrderEnumeratorHandler(module2){

            public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
                return false;
            }

            public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
                return true;
            }

            public boolean shouldProcessDependenciesRecursively() {
                return finalShouldRecurse;
            }

            public boolean addCustomModuleRoots(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result2, boolean includeProduction, boolean includeTests) {
                GradleAndroidModel androidModel = GradleAndroidModel.get(rootModel.getModule());
                if (androidModel == null) {
                    return super.addCustomModuleRoots(type, rootModel, result2, includeProduction, includeTests);
                }
                if (!type.equals((Object)OrderRootType.CLASSES)) {
                    return false;
                }
                super.addCustomModuleRoots(type, rootModel, result2, includeProduction, includeTests);
                AndroidGradleOrderEnumeratorHandlerFactory.getAndroidCompilerOutputFolders(androidModel, includeProduction, includeTests).stream().filter(root -> !result2.contains(root)).forEachOrdered(result2::add);
                return true;
            }
        };
    }

    @NotNull
    private static List<String> getAndroidCompilerOutputFolders(@NotNull GradleAndroidModel androidModel, boolean includeProduction, boolean includeTests) {
        LinkedList<String> toAdd = new LinkedList<String>();
        if (includeTests) {
            if (androidModel.getSelectedVariant().getUnitTestArtifact() != null) {
                AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromJavaArtifact(androidModel.getSelectedVariant().getUnitTestArtifact(), toAdd);
            }
            if (androidModel.getSelectedVariant().getAndroidTestArtifact() != null) {
                AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromAndroidArtifact(androidModel.getSelectedVariant().getAndroidTestArtifact(), toAdd);
            }
            if (androidModel.getSelectedVariant().getTestFixturesArtifact() != null) {
                AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromAndroidArtifact(androidModel.getSelectedVariant().getTestFixturesArtifact(), toAdd);
            }
        }
        if (includeProduction) {
            AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromAndroidArtifact(androidModel.getSelectedVariant().getMainArtifact(), toAdd);
        }
        return toAdd;
    }

    private static void addFoldersFromBaseArtifact(@NotNull IdeBaseArtifact artifact2, @NotNull List<String> toAdd) {
        artifact2.getClassesFolder().stream().filter(Objects::nonNull).map(FilePaths::pathToIdeaUrl).forEach(toAdd::add);
    }

    private static void addFoldersFromJavaArtifact(@NotNull IdeJavaArtifact artifact2, @NotNull List<String> toAdd) {
        AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromBaseArtifact(artifact2, toAdd);
    }

    private static void addFoldersFromAndroidArtifact(@NotNull IdeAndroidArtifact artifact2, @NotNull List<String> toAdd) {
        AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromBaseArtifact(artifact2, toAdd);
        artifact2.getGeneratedResourceFolders().stream().filter(Objects::nonNull).map(FilePaths::pathToIdeaUrl).forEach(toAdd::add);
    }
}

