/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.annotations.concurrency.AnyThread;
import com.android.repository.Revision;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.GradleVersionCatalogDetector;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolverKeys;
import com.android.tools.idea.gradle.util.AndroidProjectUtilKt;
import com.android.tools.idea.projectsystem.AndroidProjectSettingsService;
import com.android.utils.BuildScriptUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.BuildContentManager;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSyncStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    @NotNull
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.sync.status");
    @NotNull
    private final GradleProjectInfo myProjectInfo;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final GradleVersionCatalogDetector myVersionCatalogDetector;

    public ProjectSyncStatusNotificationProvider(@NotNull Project project) {
        this(GradleProjectInfo.getInstance(project), GradleSyncState.getInstance(project), GradleVersionCatalogDetector.getInstance(project));
    }

    @NonInjectable
    public ProjectSyncStatusNotificationProvider(@NotNull GradleProjectInfo projectInfo, @NotNull GradleSyncState syncState, @NotNull GradleVersionCatalogDetector versionCatalogDetector) {
        this.myProjectInfo = projectInfo;
        this.mySyncState = syncState;
        this.myVersionCatalogDetector = versionCatalogDetector;
    }

    @NotNull
    public final Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @AnyThread
    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor editor, @NotNull Project project) {
        NotificationPanel.Type newPanelType = this.notificationPanelType(project);
        return newPanelType.create(project, file2, this.myProjectInfo);
    }

    @NotNull
    private NotificationPanel.Type notificationPanelType(@NotNull Project project) {
        if (IdeInfo.getInstance().isAndroidStudio() || AndroidProjectUtilKt.isAndroidProject(project)) {
            return this.notificationPanelType();
        }
        return NotificationPanel.Type.NONE;
    }

    @VisibleForTesting
    @NotNull
    NotificationPanel.Type notificationPanelType() {
        if (!this.myProjectInfo.isBuildWithGradle()) {
            return NotificationPanel.Type.NONE;
        }
        if (this.mySyncState.isSyncInProgress()) {
            return NotificationPanel.Type.IN_PROGRESS;
        }
        if (this.mySyncState.lastSyncFailed()) {
            return NotificationPanel.Type.FAILED;
        }
        ThreeState gradleSyncNeeded = this.mySyncState.isSyncNeeded();
        if (gradleSyncNeeded == ThreeState.YES) {
            return NotificationPanel.Type.SYNC_NEEDED;
        }
        if (this.myVersionCatalogDetector.isVersionCatalogProject()) {
            return NotificationPanel.Type.COMPLICATED_PROJECT;
        }
        return NotificationPanel.Type.PROJECT_STRUCTURE;
    }

    @VisibleForTesting
    static class ProjectStructureNotificationPanel
    extends NotificationPanel {
        private static final String TEXT = "You can use the Project Structure dialog to view and edit your project configuration";
        private static final long RESHOW_TIMEOUT_MS = TimeUnit.DAYS.toMillis(30L);

        ProjectStructureNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull Module module2) {
            super(type, TEXT);
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"ShowProjectStructureSettings");
            Object label = "Open";
            if (!"".equals(shortcutText)) {
                label = (String)label + " (" + shortcutText + ")";
            }
            this.createActionLabel((String)label, () -> {
                ProjectSettingsService projectSettingsService = ProjectSettingsService.getInstance((Project)project);
                if (projectSettingsService instanceof AndroidProjectSettingsService) {
                    projectSettingsService.openModuleSettings(module2);
                }
            });
            this.createActionLabel("Hide notification", () -> {
                PropertiesComponent.getInstance().setValue("PROJECT_STRUCTURE_NOTIFICATION_LAST_HIDDEN_TIMESTAMP", Long.toString(System.currentTimeMillis()));
                this.setVisible(false);
            });
        }

        @NotNull
        public Color getFallbackBackgroundColor() {
            return UIUtil.getPanelBackground();
        }

        static boolean userAllowsShow() {
            String lastHiddenValue;
            long lastHidden;
            long now = System.currentTimeMillis();
            return now - (lastHidden = Long.parseLong(lastHiddenValue = PropertiesComponent.getInstance().getValue("PROJECT_STRUCTURE_NOTIFICATION_LAST_HIDDEN_TIMESTAMP", "0"))) > RESHOW_TIMEOUT_MS;
        }
    }

    @VisibleForTesting
    static class ComplicatedProjectNotificationPanel
    extends NotificationPanel {
        private static final String TEXT = "Project uses Gradle Version Catalogs: some editor tools may not work as expected";

        ComplicatedProjectNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type) {
            super(type, TEXT);
            this.createActionLabel("Hide notification", () -> {
                String version2 = ApplicationInfo.getInstance().getShortVersion();
                PropertiesComponent.getInstance((Project)project).setValue("PROJECT_COMPLICATED_NOTIFICATION_LAST_HIDDEN_VERSION", version2);
                this.setVisible(false);
            });
        }

        static boolean userAllowsShow(@NotNull Project project) {
            String lastHiddenValue = PropertiesComponent.getInstance((Project)project).getValue("PROJECT_COMPLICATED_NOTIFICATION_LAST_HIDDEN_VERSION", "0.0");
            Revision revision = Revision.safeParseRevision((String)lastHiddenValue);
            return revision.compareTo(Revision.safeParseRevision((String)ApplicationInfo.getInstance().getShortVersion())) < 0;
        }
    }

    @VisibleForTesting
    static class SyncProblemNotificationPanel
    extends NotificationPanel {
        SyncProblemNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text2) {
            super(type, text2);
            this.createActionLabel("Try Again", () -> GradleSyncInvoker.getInstance().requestProjectSync(project, new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_USER_TRY_AGAIN), null));
            this.createActionLabel("Open 'Build' View", () -> {
                ToolWindow tw = BuildContentManager.getInstance((Project)project).getOrCreateToolWindow();
                if (tw != null && !tw.isActive()) {
                    tw.activate(null, false);
                }
            });
            this.createActionLabel("Show Log in " + RevealFileAction.getFileManagerName(), () -> {
                File logFile = new File(PathManager.getLogPath(), "idea.log");
                RevealFileAction.openFile((File)logFile);
            });
        }
    }

    @VisibleForTesting
    static class StaleGradleModelNotificationPanel
    extends NotificationPanel {
        StaleGradleModelNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text2) {
            super(type, text2);
            if (GradleFiles.getInstance(project).areExternalBuildFilesModified()) {
                project.putUserData(AndroidGradleProjectResolverKeys.REFRESH_EXTERNAL_NATIVE_MODELS_KEY, (Object)true);
            }
            this.createActionLabel("Sync Now", () -> GradleSyncInvoker.getInstance().requestProjectSync(project, new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_USER_STALE_CHANGES), null));
            this.createActionLabel("Ignore these changes", () -> {
                GradleFiles.getInstance(project).removeChangedFiles();
                this.setVisible(false);
            });
        }
    }

    @VisibleForTesting
    static class NotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final Type type;

        NotificationPanel(@NotNull Type type, @NotNull String text2) {
            super(JBUI.CurrentTheme.Banner.WARNING_BACKGROUND);
            this.type = type;
            this.setText(text2);
        }

        static enum Type {
            NONE{

                @Override
                @Nullable
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    return null;
                }
            }
            ,
            COMPLICATED_PROJECT{

                @Override
                @Nullable
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    if (!IdeInfo.getInstance().isAndroidStudio()) {
                        return null;
                    }
                    if (ComplicatedProjectNotificationPanel.userAllowsShow(project)) {
                        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file2);
                        if (!(BuildScriptUtil.isDefaultGradleBuildFile((File)ioFile) || BuildScriptUtil.isGradleSettingsFile((File)ioFile) || ioFile.getName().endsWith("versions.toml"))) {
                            return null;
                        }
                        return new ComplicatedProjectNotificationPanel(project, this);
                    }
                    return PROJECT_STRUCTURE.create(project, file2, projectInfo);
                }
            }
            ,
            PROJECT_STRUCTURE{

                @Override
                @Nullable
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    if (!IdeInfo.getInstance().isAndroidStudio()) {
                        return null;
                    }
                    if (ProjectStructureNotificationPanel.userAllowsShow()) {
                        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file2);
                        if (!BuildScriptUtil.isDefaultGradleBuildFile((File)ioFile) && !BuildScriptUtil.isGradleSettingsFile((File)ioFile)) {
                            return null;
                        }
                        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project);
                        if (module2 == null) {
                            if (ApplicationManager.getApplication().isUnitTestMode()) {
                                module2 = ModuleManager.getInstance((Project)project).getModules()[0];
                            } else {
                                return null;
                            }
                        }
                        return new ProjectStructureNotificationPanel(project, this, module2);
                    }
                    return null;
                }
            }
            ,
            IN_PROGRESS{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    return new NotificationPanel(this, "Gradle project sync in progress...");
                }
            }
            ,
            FAILED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    String text2 = "Gradle project sync failed. Basic functionality (e.g. editing, debugging) will not work properly.";
                    return new SyncProblemNotificationPanel(project, this, text2);
                }
            }
            ,
            SYNC_NEEDED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    boolean buildFilesModified = GradleFiles.getInstance(project).areExternalBuildFilesModified();
                    String text2 = (buildFilesModified ? "External build files" : "Gradle files") + " have changed since last project sync. A project sync may be necessary for the IDE to work properly.";
                    return new StaleGradleModelNotificationPanel(project, this, text2);
                }
            };


            @Nullable
            abstract NotificationPanel create(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull GradleProjectInfo var3);
        }
    }
}

