/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleDslWriter;
import com.android.tools.idea.gradle.dsl.parser.SharedParserUtilsKt;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslInfixExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslUtil;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GroovyDslWriter
extends GroovyDslNameConverter
implements GradleDslWriter {
    public GroovyDslWriter(@NotNull BuildModelContext context2) {
        super(context2);
    }

    @Override
    public PsiElement moveDslElement(@NotNull GradleDslElement element2) {
        GradleDslElement anchorAfter = element2.getAnchor();
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(element2.getPsiElement());
        if (psiElement == null) {
            return null;
        }
        PsiElement parentPsiElement = GroovyDslUtil.getParentPsi(element2);
        if (parentPsiElement == null) {
            return null;
        }
        PsiElement anchor = GroovyDslUtil.getPsiElementForAnchor(parentPsiElement, anchorAfter);
        GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        PsiElement lineTerminator = factory2.createLineTerminator(1);
        PsiElement toReplace = parentPsiElement.addAfter(lineTerminator, anchor);
        PsiElement e = element2.getPsiElement();
        while (!(e.getParent() instanceof GroovyFile) && !(e.getParent() instanceof GrClosableBlock)) {
            if (e.getParent() == null) {
                e = element2.getPsiElement();
                break;
            }
            e = e.getParent();
        }
        PsiElement treeCopy = e.copy();
        PsiElement newTree = toReplace.replace(treeCopy);
        e.delete();
        element2.setPsiElement(newTree);
        return element2.getPsiElement();
    }

    @Override
    public PsiElement createDslElement(@NotNull GradleDslElement element2) {
        PsiElement addedElement;
        PsiElement parentPsiElement;
        if (element2 instanceof GradleDslInfixExpression) {
            return this.createDslInfixExpression((GradleDslInfixExpression)element2);
        }
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(element2.getPsiElement());
        if (psiElement != null) {
            return psiElement;
        }
        GradleDslElement anchorAfter = element2.getAnchor();
        boolean addBefore = false;
        if (element2.isNewEmptyBlockElement()) {
            return null;
        }
        if (GroovyDslUtil.needToCreateParent(element2)) {
            addBefore = true;
            anchorAfter = null;
        }
        if ((parentPsiElement = GroovyDslUtil.getParentPsi(element2)) == null) {
            return null;
        }
        Project project = parentPsiElement.getProject();
        GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)project);
        ExternalNameInfo externalNameInfo = SharedParserUtilsKt.maybeTrimForParent(element2, this);
        Object statementText = GroovyDslUtil.quotePartsIfNecessary(externalNameInfo);
        assert (!((String)statementText).isEmpty()) : "Element name can't be empty! This will cause statement creation to error.";
        ExternalNameInfo.ExternalNameSyntax syntax = externalNameInfo.syntax;
        switch (syntax) {
            case UNKNOWN: {
                syntax = element2.getExternalSyntax();
                break;
            }
            default: {
                element2.setExternalSyntax(syntax);
            }
        }
        if (element2.isBlockElement()) {
            statementText = element2 instanceof MavenRepositoryDslElement && element2.getContainedElements(true).isEmpty() ? (String)statementText + "()" : (String)statementText + " {\n}\n";
        } else if (syntax == ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT || syntax == ExternalNameInfo.ExternalNameSyntax.AUGMENTED_ASSIGNMENT) {
            if (element2.getElementType() == PropertyType.REGULAR) {
                switch (syntax) {
                    case ASSIGNMENT: {
                        statementText = (String)statementText + " = 'abc'";
                        break;
                    }
                    case AUGMENTED_ASSIGNMENT: {
                        statementText = (String)statementText + " += 'abc'";
                    }
                }
            } else if (element2.getElementType() == PropertyType.VARIABLE) {
                statementText = "def " + (String)statementText + " = 'abc'";
            }
        } else {
            statementText = (String)statementText + " \"abc\", \"xyz\"";
        }
        GrStatement statement = factory2.createStatementFromText((CharSequence)statementText);
        if (statement instanceof GrApplicationStatement) {
            ((GrApplicationStatement)statement).getArgumentList().delete();
        } else if (statement instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignment = (GrAssignmentExpression)statement;
            if (assignment.getRValue() != null) {
                assignment.getRValue().delete();
            }
        } else if (statement instanceof GrVariableDeclaration) {
            GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)statement;
            for (GrVariable var : variableDeclaration.getVariables()) {
                if (var.getInitializerGroovy() == null) continue;
                var.getInitializerGroovy().delete();
                ASTNode node = var.getNode();
                node.addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", var.getLastChild().getNode().getTreeNext());
            }
        }
        PsiElement lineTerminator = factory2.createLineTerminator(1);
        PsiElement anchor = GroovyDslUtil.getPsiElementForAnchor(parentPsiElement, anchorAfter);
        if (parentPsiElement instanceof GroovyFile) {
            PsiElement firstFileChild = parentPsiElement.getFirstChild();
            addedElement = addBefore ? parentPsiElement.addBefore((PsiElement)statement, anchor) : (firstFileChild != null && firstFileChild.getNode().getElementType() == GroovyElementTypes.ML_COMMENT && anchor == null ? parentPsiElement.addAfter((PsiElement)statement, firstFileChild) : parentPsiElement.addAfter((PsiElement)statement, anchor));
            if (element2.isBlockElement() && !PsiImplUtil.isWhiteSpaceOrNls((PsiElement)addedElement.getPrevSibling())) {
                parentPsiElement.addBefore(lineTerminator, addedElement);
            }
            if (addBefore) {
                parentPsiElement.addAfter(lineTerminator, addedElement);
            } else {
                parentPsiElement.addBefore(lineTerminator, addedElement);
            }
        } else if (parentPsiElement instanceof GrClosableBlock) {
            addedElement = parentPsiElement.addAfter((PsiElement)statement, anchor);
            if (anchorAfter != null) {
                parentPsiElement.addBefore(lineTerminator, addedElement);
            } else {
                parentPsiElement.addAfter(lineTerminator, addedElement);
                if (GroovyDslUtil.closableBlockNeedsNewline((GrClosableBlock)parentPsiElement)) {
                    parentPsiElement.addBefore(lineTerminator, addedElement);
                }
            }
        } else {
            addedElement = parentPsiElement.addAfter((PsiElement)statement, anchor);
            parentPsiElement.addBefore(lineTerminator, addedElement);
        }
        if (element2.isBlockElement()) {
            GrClosableBlock closableBlock = GroovyDslUtil.getClosableBlock(addedElement);
            if (closableBlock != null) {
                element2.setPsiElement((PsiElement)closableBlock);
            }
        } else if (addedElement instanceof GrApplicationStatement || addedElement instanceof GrAssignmentExpression || addedElement instanceof GrVariableDeclaration) {
            element2.setPsiElement(addedElement);
        }
        return element2.getPsiElement();
    }

    @Override
    public void deleteDslElement(@NotNull GradleDslElement element2) {
        GroovyDslUtil.deletePsiElement(element2, element2.getPsiElement());
    }

    @Override
    public PsiElement createDslLiteral(@NotNull GradleDslLiteral literal) {
        return this.createDslLiteralOrReference(literal);
    }

    @Override
    public void applyDslLiteral(@NotNull GradleDslLiteral literal) {
        GroovyDslUtil.applyDslLiteralOrReference(literal, this);
    }

    @Override
    public void deleteDslLiteral(@NotNull GradleDslLiteral literal) {
        GroovyDslUtil.deletePsiElement(literal, literal.getExpression());
        GroovyDslUtil.deletePsiElement(literal, literal.getNameElement().getNamedPsiElement());
    }

    @Override
    public PsiElement createDslMethodCall(@NotNull GradleDslMethodCall methodCall) {
        GrExpression[] expressionArguments;
        String statementText;
        PsiElement parentPsiElement;
        PsiElement psiElement = methodCall.getPsiElement();
        if (psiElement != null && psiElement.isValid()) {
            return psiElement;
        }
        if (methodCall.getParent() == null) {
            return null;
        }
        GradleDslElement anchorAfter = methodCall.getAnchor();
        if (GroovyDslUtil.needToCreateParent(methodCall)) {
            anchorAfter = null;
        }
        if ((parentPsiElement = methodCall.getParent().create()) == null) {
            return null;
        }
        PsiElement anchor = GroovyDslUtil.getPsiElementForAnchor(parentPsiElement, anchorAfter);
        GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GradleDslLiteral fakeElement = new GradleDslLiteral(methodCall.getParent(), GradleNameElement.fake(methodCall.getMethodName()));
        String methodCallText = (methodCall.isConstructor() ? "new " : "") + GroovyDslUtil.quotePartsIfNecessary(SharedParserUtilsKt.maybeTrimForParent(fakeElement, this)) + "()";
        if (!methodCall.getNameElement().isEmpty()) {
            ExternalNameInfo info2 = SharedParserUtilsKt.maybeTrimForParent(methodCall, this);
            ExternalNameInfo.ExternalNameSyntax syntax = info2.syntax;
            if (syntax == ExternalNameInfo.ExternalNameSyntax.UNKNOWN) {
                syntax = methodCall.getExternalSyntax();
            }
            String elementName = GroovyDslUtil.quotePartsIfNecessary(info2) + " ";
            statementText = elementName + (syntax == ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT ? "= " : "") + methodCallText;
        } else {
            statementText = methodCallText;
        }
        GrStatement statement = factory2.createStatementFromText((CharSequence)statementText);
        PsiElement addedElement = parentPsiElement.addAfter((PsiElement)statement, anchor);
        if (addedElement instanceof GrApplicationStatement && (expressionArguments = ((GrApplicationStatement)addedElement).getArgumentList().getExpressionArguments()).length == 1 && expressionArguments[0] instanceof GrMethodCallExpression) {
            methodCall.setPsiElement((PsiElement)expressionArguments[0]);
            GrMethodCallExpression methodCallExpression = (GrMethodCallExpression)expressionArguments[0];
            methodCall.getArgumentsElement().setPsiElement((PsiElement)methodCallExpression.getArgumentList());
            return methodCall.getPsiElement();
        }
        if (addedElement instanceof GrAssignmentExpression) {
            GrExpression rValue = ((GrAssignmentExpression)addedElement).getRValue();
            if (rValue instanceof GrMethodCallExpression) {
                methodCall.setPsiElement((PsiElement)rValue);
                GrMethodCallExpression methodCallExpression = (GrMethodCallExpression)rValue;
                methodCall.getArgumentsElement().setPsiElement((PsiElement)methodCallExpression.getArgumentList());
                return methodCall.getPsiElement();
            }
            if (rValue instanceof GrNewExpression) {
                methodCall.setPsiElement((PsiElement)rValue);
                GrNewExpression newExpression = (GrNewExpression)rValue;
                methodCall.getArgumentsElement().setPsiElement((PsiElement)newExpression.getArgumentList());
            }
            return methodCall.getPsiElement();
        }
        if (addedElement instanceof GrMethodCallExpression) {
            methodCall.setPsiElement(addedElement);
            methodCall.getArgumentsElement().setPsiElement((PsiElement)((GrMethodCallExpression)addedElement).getArgumentList());
            methodCall.getArgumentsElement().applyChanges();
            if (methodCall.getUnsavedClosure() != null) {
                GroovyDslUtil.createAndAddClosure(methodCall.getUnsavedClosure(), methodCall);
            }
            return methodCall.getPsiElement();
        }
        return null;
    }

    @Override
    public void applyDslMethodCall(@NotNull GradleDslMethodCall element2) {
        GroovyDslUtil.maybeUpdateName(element2, this);
        element2.getArgumentsElement().applyChanges();
        if (element2.getUnsavedClosure() != null) {
            GroovyDslUtil.createAndAddClosure(element2.getUnsavedClosure(), element2);
        }
    }

    @Override
    public PsiElement createDslExpressionList(@NotNull GradleDslExpressionList expressionList) {
        PsiElement psiElement = expressionList.getPsiElement();
        if (psiElement == null) {
            if (expressionList.getParent() instanceof GradleDslExpressionMap) {
                return GroovyDslUtil.createNamedArgumentList(expressionList);
            }
            if (expressionList.getParent() instanceof GradleDslMethodCall) {
                return GroovyDslUtil.createMethodCallArgumentList(expressionList);
            }
        } else {
            return psiElement;
        }
        psiElement = this.createDslElement(expressionList);
        if (psiElement == null) {
            return null;
        }
        if (psiElement instanceof GrListOrMap) {
            return psiElement;
        }
        if (psiElement instanceof GrAssignmentExpression || psiElement instanceof GrVariableDeclaration) {
            GrExpression emptyMap = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject()).createExpressionFromText((CharSequence)"[]");
            PsiElement element2 = psiElement.addAfter((PsiElement)emptyMap, psiElement.getLastChild());
            expressionList.setPsiElement(element2);
            return expressionList.getPsiElement();
        }
        if (psiElement instanceof GrArgumentList) {
            if (expressionList.getExpressions().size() == 1 && ((GrArgumentList)psiElement).getAllArguments().length == 1 && !expressionList.isAppendToArgumentListWithOneElement()) {
                expressionList.setPsiElement(null);
                psiElement = this.createDslElement(expressionList);
            } else {
                return psiElement;
            }
        }
        if (psiElement instanceof GrApplicationStatement) {
            GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
            GrArgumentList argumentList = factory2.createArgumentListFromText("xyz");
            argumentList.getFirstChild().delete();
            PsiElement added2 = psiElement.addAfter((PsiElement)argumentList, psiElement.getLastChild());
            if (added2 instanceof GrArgumentList) {
                GrArgumentList addedArgumentList = (GrArgumentList)added2;
                expressionList.setPsiElement((PsiElement)addedArgumentList);
                return addedArgumentList;
            }
        }
        return null;
    }

    @Override
    public void applyDslExpressionList(@NotNull GradleDslExpressionList expressionList) {
        GroovyDslUtil.maybeUpdateName(expressionList, this);
    }

    @Override
    public PsiElement createDslExpressionMap(@NotNull GradleDslExpressionMap expressionMap) {
        PsiElement psiElement;
        if (expressionMap.getPsiElement() != null) {
            return expressionMap.getPsiElement();
        }
        if (expressionMap.getElementType() == PropertyType.DERIVED && expressionMap.isLiteralMap()) {
            psiElement = GroovyDslUtil.createDerivedMap(expressionMap);
        } else {
            if (expressionMap.getElementType() == PropertyType.DERIVED && expressionMap.getParent() instanceof GradleDslExpressionList && expressionMap.getParent().getParent() instanceof GradleDslMethodCall) {
                return expressionMap.getParent() == null ? null : expressionMap.getParent().create();
            }
            psiElement = this.createDslElement(expressionMap);
        }
        if (psiElement == null) {
            return null;
        }
        if (psiElement instanceof GrListOrMap || psiElement instanceof GrArgumentList || psiElement instanceof GrNamedArgument) {
            return psiElement;
        }
        if (psiElement instanceof GrAssignmentExpression || psiElement instanceof GrVariableDeclaration) {
            GrExpression emptyMap = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject()).createExpressionFromText((CharSequence)"[:]");
            PsiElement element2 = psiElement.addAfter((PsiElement)emptyMap, psiElement.getLastChild());
            expressionMap.setPsiElement(element2);
            return element2;
        }
        if (psiElement instanceof GrApplicationStatement) {
            GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
            GrArgumentList argumentList = factory2.createArgumentListFromText("xyz");
            argumentList.getFirstChild().delete();
            PsiElement added2 = psiElement.addAfter((PsiElement)argumentList, psiElement.getLastChild());
            if (added2 instanceof GrArgumentList) {
                GrArgumentList addedArgumentList = (GrArgumentList)added2;
                expressionMap.setPsiElement((PsiElement)addedArgumentList);
                return addedArgumentList;
            }
        }
        return null;
    }

    @Override
    public void applyDslExpressionMap(@NotNull GradleDslExpressionMap expressionMap) {
        GroovyDslUtil.maybeUpdateName(expressionMap, this);
    }

    public PsiElement createDslInfixExpression(@NotNull GradleDslInfixExpression expression2) {
        if (expression2.getPsiElement() != null) {
            return expression2.getPsiElement();
        }
        GradleDslElement parent2 = expression2.getParent();
        if (parent2 == null) {
            return null;
        }
        PsiElement parentPsi = parent2.create();
        GradleDslElement firstElement = expression2.getCurrentElements().get(0);
        if (!(firstElement instanceof GradleDslLiteral)) {
            return null;
        }
        GradleDslLiteral firstLiteral = (GradleDslLiteral)firstElement;
        expression2.setPsiElement(parentPsi);
        PsiElement elementPsi = this.createDslElement(firstLiteral);
        expression2.setPsiElement(elementPsi);
        this.applyDslLiteral(firstLiteral);
        firstLiteral.reset();
        firstLiteral.commit();
        return expression2.getPsiElement();
    }

    @Override
    public void applyDslPropertiesElement(@NotNull GradlePropertiesDslElement element2) {
        GroovyDslUtil.maybeUpdateName(element2, this);
    }

    private PsiElement createDslLiteralOrReference(@NotNull GradleDslSettableExpression expression2) {
        GradleDslElement parent2 = expression2.getParent();
        if (parent2 instanceof GradleDslExpressionMap) {
            return GroovyDslUtil.processMapElement(expression2);
        }
        if (parent2 instanceof GradleDslExpressionList) {
            return GroovyDslUtil.processListElement(expression2);
        }
        if (parent2 instanceof GradleDslInfixExpression) {
            return GroovyDslUtil.createInfixElement(expression2);
        }
        return this.createDslElement(expression2);
    }
}

