/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleVersionCatalogFile
extends GradleDslFile {
    @NotNull
    private final String catalogName;

    GradleVersionCatalogFile(@NotNull VirtualFile file2, @NotNull Project project, @NotNull String moduleName2, @NotNull String catalogName, @NotNull BuildModelContext context2) {
        super(file2, project, moduleName2, context2);
        this.catalogName = catalogName;
    }

    @NotNull
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public void parse() {
        this.myGradleDslParser.parse();
        this.replaceVersionRefsWithInjections();
        this.mapAliasesToAccessors();
        this.replaceLibraryRefsInBundlesWithInjections();
    }

    protected void replaceVersionRefsWithInjections() {
        GradleDslExpressionMap libraries2 = this.getPropertyElement("libraries", GradleDslExpressionMap.class);
        GradleDslExpressionMap plugins = this.getPropertyElement("plugins", GradleDslExpressionMap.class);
        GradleDslExpressionMap versions = this.getPropertyElement("versions", GradleDslExpressionMap.class);
        if (versions == null) {
            return;
        }
        Consumer<GradleDslExpressionMap> versionRefReplacer = library -> {
            GradleDslElement versionProperty2 = library.getPropertyElement("version");
            if (versionProperty2 instanceof GradleDslExpressionMap) {
                GradleDslElement targetProperty;
                GradleDslLiteral ref;
                String targetName;
                GradleDslExpressionMap version2 = (GradleDslExpressionMap)versionProperty2;
                GradleDslElement refProperty = version2.getPropertyElement("ref");
                if (refProperty instanceof GradleDslLiteral && (targetName = (ref = (GradleDslLiteral)refProperty).getValue(String.class)) != null && (targetProperty = versions.getPropertyElement(targetName)) != null) {
                    GradleDslVersionLiteral reference = new GradleDslVersionLiteral((GradleDslElement)library, ref.getPsiElement(), versionProperty2.getNameElement(), ref.getPsiElement(), GradleDslLiteral.LiteralType.REFERENCE);
                    GradleReferenceInjection injection = new GradleReferenceInjection(reference, targetProperty, ref.getPsiElement(), targetName);
                    targetProperty.registerDependent(injection);
                    reference.addDependency(injection);
                    library.substituteElement(versionProperty2, reference);
                }
            } else if (versionProperty2 instanceof GradleDslLiteral) {
                GradleDslLiteral version3 = (GradleDslLiteral)versionProperty2;
                GradleDslVersionLiteral literal = new GradleDslVersionLiteral((GradleDslElement)library, version3.getPsiElement(), version3.getNameElement(), version3.getPsiElement(), GradleDslLiteral.LiteralType.LITERAL);
                library.substituteElement(versionProperty2, literal);
            }
        };
        if (libraries2 != null) {
            libraries2.getPropertyElements(GradleDslExpressionMap.class).forEach(versionRefReplacer);
        }
        if (plugins != null) {
            plugins.getPropertyElements(GradleDslExpressionMap.class).forEach(versionRefReplacer);
        }
    }

    protected void mapAliasesToAccessors() {
        GradleDslExpressionMap libraries2 = this.getPropertyElement("libraries", GradleDslExpressionMap.class);
        GradleDslExpressionMap plugins = this.getPropertyElement("plugins", GradleDslExpressionMap.class);
        GradleDslExpressionMap bundles = this.getPropertyElement("bundles", GradleDslExpressionMap.class);
        Pattern pattern = Pattern.compile("[_-]");
        Function<GradleDslExpressionMap, BiConsumer> aliasConstructorFactory = map2 -> (name, element2) -> {
            String[] split = pattern.split((CharSequence)name);
            if (split.length > 1) {
                map2.hideProperty((GradleDslElement)element2);
                GradleDslExpressionMap current = map2;
                for (int i = 0; i < split.length - 1; ++i) {
                    GradleDslExpressionMap next = current.getPropertyElement(split[i], GradleDslExpressionMap.class);
                    if (next == null) {
                        next = new GradleDslExpressionMap(current, GradleNameElement.fake(split[i]));
                        current.addParsedElement(next);
                    }
                    current = next;
                }
                element2.setNameElement(GradleNameElement.fake(split[split.length - 1]));
                current.addParsedElement((GradleDslElement)element2);
            }
        };
        if (libraries2 != null) {
            libraries2.getPropertyElements().forEach(aliasConstructorFactory.apply(libraries2));
        }
        if (plugins != null) {
            plugins.getPropertyElements().forEach(aliasConstructorFactory.apply(plugins));
        }
        if (bundles != null) {
            bundles.getPropertyElements().forEach(aliasConstructorFactory.apply(bundles));
        }
    }

    protected void replaceLibraryRefsInBundlesWithInjections() {
        GradleDslExpressionMap libraries2 = this.getPropertyElement("libraries", GradleDslExpressionMap.class);
        GradleDslExpressionMap bundles = this.getPropertyElement("bundles", GradleDslExpressionMap.class);
        if (bundles == null) {
            return;
        }
        Consumer<GradlePropertiesDslElement> libraryRefReplacer = bundle2 -> {
            List<GradleDslElement> elements = bundle2.getCurrentElements();
            elements.forEach(element2 -> {
                GradleDslLiteral ref;
                String targetName;
                GradleDslElement targetProperty;
                if (element2 instanceof GradleDslLiteral && (targetProperty = libraries2.getPropertyElement(targetName = (ref = (GradleDslLiteral)element2).getValue(String.class))) != null) {
                    GradleBundleRefLiteral reference = new GradleBundleRefLiteral((GradleDslElement)bundle2, ref.getPsiElement(), targetProperty.getNameElement(), ref.getPsiElement(), GradleDslLiteral.LiteralType.REFERENCE);
                    GradleReferenceInjection injection = new GradleReferenceInjection(reference, targetProperty, ref.getPsiElement(), targetName);
                    targetProperty.registerDependent(injection);
                    reference.addDependency(injection);
                    bundle2.substituteElement((GradleDslElement)element2, reference);
                }
            });
        };
        bundles.getPropertyElements(GradlePropertiesDslElement.class).forEach(libraryRefReplacer);
    }

    public static class GradleDslVersionLiteral
    extends GradleDslLiteral {
        private boolean ref;
        private final boolean initialRef;

        GradleDslVersionLiteral(@NotNull GradleDslElement parent2, @NotNull PsiElement psiElement, @NotNull GradleNameElement name, @NotNull PsiElement literal, @NotNull GradleDslLiteral.LiteralType literalType) {
            super(parent2, psiElement, name, literal, literalType);
            this.initialRef = this.ref = literalType == GradleDslLiteral.LiteralType.REFERENCE;
        }

        public GradleDslVersionLiteral(@NotNull GradleDslElement parent2, @NotNull GradleNameElement name, @NotNull Object value2) {
            super(parent2, name);
            this.initialRef = this.ref = value2 instanceof ReferenceTo;
        }

        @Override
        public boolean isReference() {
            return this.ref;
        }

        @Override
        public void setValue(@NotNull Object value2) {
            if (value2 instanceof ReferenceTo) {
                super.setValue(((ReferenceTo)value2).getReferredElement().getName());
                this.ref = true;
                return;
            }
            super.setValue(value2);
            this.ref = false;
        }

        @Override
        @Nullable
        public PsiElement create() {
            PsiElement psiElement;
            GradleNameElement name = this.getNameElement();
            if (this.ref && this.getPsiElement() == null) {
                this.setNameElement(GradleNameElement.create("version.ref"));
            }
            if ((psiElement = super.create()) != null) {
                this.setNameElement(GradleNameElement.from(psiElement.getParent().getFirstChild().getFirstChild(), this.getDslFile().getParser()));
            } else {
                this.setNameElement(name);
            }
            return psiElement;
        }

        @Override
        protected void apply() {
            if (this.ref != this.initialRef) {
                this.delete();
                this.setPsiElement(null);
                this.create();
            }
            super.apply();
        }

        @Override
        public void delete() {
            if (this.getPsiElement() != null && this.getNameElement().getNamedPsiElement() != null) {
                this.setPsiElement(this.getNameElement().getNamedPsiElement());
            }
            super.delete();
        }
    }

    public static class GradleBundleRefLiteral
    extends GradleDslLiteral {
        public GradleBundleRefLiteral(@NotNull GradleDslElement parent2, @NotNull GradleNameElement name) {
            super(parent2, name);
        }

        public GradleBundleRefLiteral(@NotNull GradleDslElement parent2, @NotNull PsiElement psiElement, @NotNull GradleNameElement name, @NotNull PsiElement literal, @NotNull GradleDslLiteral.LiteralType literalType) {
            super(parent2, psiElement, name, literal, literalType);
        }
    }
}

