/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.google.common.base.Charsets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDslFileCache {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<GradleDslFile> myParsedDslFiles = new ArrayList<GradleDslFile>();
    @NotNull
    private final Map<String, GradleBuildFile> myParsedBuildFiles = new LinkedHashMap<String, GradleBuildFile>();
    @NotNull
    private final Map<String, GradleSettingsFile> myParsedSettingsFiles = new LinkedHashMap<String, GradleSettingsFile>();
    @NotNull
    private final Map<String, GradlePropertiesFile> myParsedPropertiesFiles = new LinkedHashMap<String, GradlePropertiesFile>();
    @NotNull
    private final Map<String, GradleVersionCatalogFile> myParsedVersionCatalogFiles = new LinkedHashMap<String, GradleVersionCatalogFile>();
    @NotNull
    private Deque<VirtualFile> myParsingStack = new ArrayDeque<VirtualFile>();

    public GradleDslFileCache(@NotNull Project project) {
        this.myProject = project;
    }

    public void clearAllFiles() {
        this.myParsedBuildFiles.clear();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file2, @NotNull String name, @NotNull BuildModelContext context2, boolean isApplied) {
        GradleBuildFile dslFile = this.myParsedBuildFiles.get(file2.getUrl());
        if (dslFile == null) {
            if (!this.myParsingStack.contains(file2)) {
                this.myParsingStack.push(file2);
                dslFile = context2.parseBuildFile(this.myProject, file2, name, isApplied);
                this.myParsingStack.pop();
                this.myParsedBuildFiles.put(file2.getUrl(), dslFile);
                this.myParsedDslFiles.add(dslFile);
            } else {
                dslFile = new GradleBuildFile(file2, this.myProject, name, context2);
                dslFile.notification(NotificationTypeReference.CIRCULAR_APPLICATION);
            }
        }
        return dslFile;
    }

    public void putBuildFile(@NotNull String name, @NotNull GradleBuildFile buildFile) {
        this.myParsedBuildFiles.put(name, buildFile);
        this.myParsedDslFiles.add(buildFile);
    }

    @Nullable
    public VirtualFile getCurrentParsingRoot() {
        return this.myParsingStack.isEmpty() ? null : this.myParsingStack.getLast();
    }

    @NotNull
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull VirtualFile settingsFile, @NotNull BuildModelContext context2) {
        GradleSettingsFile dslFile = this.myParsedSettingsFiles.get(settingsFile.getUrl());
        if (dslFile == null) {
            dslFile = new GradleSettingsFile(settingsFile, this.myProject, "settings", context2);
            dslFile.parse();
            this.myParsedSettingsFiles.put(settingsFile.getUrl(), dslFile);
            this.myParsedDslFiles.add(dslFile);
        }
        return dslFile;
    }

    @Nullable
    public GradlePropertiesFile getOrCreatePropertiesFile(@NotNull VirtualFile file2, @NotNull String moduleName2, @NotNull BuildModelContext context2) {
        GradlePropertiesFile dslFile = this.myParsedPropertiesFiles.get(file2.getUrl());
        if (dslFile == null) {
            try {
                Properties properties2 = GradleDslFileCache.getProperties(file2);
                dslFile = new GradlePropertiesFile(properties2, file2, this.myProject, moduleName2, context2);
                this.myParsedPropertiesFiles.put(file2.getUrl(), dslFile);
                this.myParsedDslFiles.add(dslFile);
            }
            catch (IOException e) {
                Logger.getInstance(GradleDslFileCache.class).warn("Failed to process properties file " + file2.getPath(), (Throwable)e);
                return null;
            }
        }
        return dslFile;
    }

    private static Properties getProperties(@NotNull VirtualFile file2) throws IOException {
        Properties properties2 = new Properties();
        try (InputStreamReader reader2 = new InputStreamReader(file2.getInputStream(), Charsets.UTF_8);){
            properties2.load(reader2);
        }
        return properties2;
    }

    @NotNull
    public GradleVersionCatalogFile getOrCreateVersionCatalogFile(@NotNull VirtualFile file2, @NotNull String catalogName, @NotNull BuildModelContext context2) {
        GradleVersionCatalogFile dslFile = this.myParsedVersionCatalogFiles.get(file2.getUrl());
        if (dslFile == null) {
            dslFile = new GradleVersionCatalogFile(file2, this.myProject, "versionCatalog", catalogName, context2);
            dslFile.parse();
            this.myParsedVersionCatalogFiles.put(file2.getUrl(), dslFile);
            this.myParsedDslFiles.add(dslFile);
        }
        return dslFile;
    }

    @NotNull
    public List<GradleDslFile> getAllFiles() {
        return this.myParsedDslFiles;
    }
}

