/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.ElementState;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ElementSort;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyType;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.SemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradlePropertiesDslElement
extends GradleDslElementImpl {
    private static final Logger LOG = Logger.getInstance(GradlePropertiesDslElement.class);
    @NotNull
    private static final Predicate<ElementList.ElementItem> VARIABLE_FILTER = e -> e.myElement.getElementType() == PropertyType.VARIABLE;
    @NotNull
    private static final Predicate<ElementList.ElementItem> PROPERTY_FILTER = VARIABLE_FILTER.negate();
    @NotNull
    private static final Predicate<ElementList.ElementItem> ANY_FILTER = e -> true;
    @NotNull
    public final ElementList myProperties = new ElementList();
    @NotNull
    private static final ImmutableMap<String, PropertiesElementDescription> NO_CHILD_PROPERTIES_ELEMENTS = ImmutableMap.of();

    protected GradlePropertiesDslElement(@Nullable GradleDslElement parent2, @Nullable PsiElement psiElement, @NotNull GradleNameElement name) {
        super(parent2, psiElement, name);
    }

    private void addPropertyInternal(@NotNull GradleDslElement element2, @NotNull ElementState state2) {
        if (this instanceof ExtDslElement && state2 == ElementState.TO_BE_ADDED) {
            int index2 = this.reorderAndMaybeGetNewIndex(element2);
            this.myProperties.addElementAtIndex(element2, state2, index2, false);
        } else {
            this.myProperties.addElement(element2, state2, state2 == ElementState.EXISTING);
        }
        if (state2 == ElementState.TO_BE_ADDED) {
            this.updateDependenciesOnAddElement(element2);
            element2.setModified();
        }
    }

    public void addParsedPropertyAsFirstElement(@NotNull GradleDslElement extElement) {
        this.myProperties.addElementAtIndex(extElement, ElementState.EXISTING, 0, true);
    }

    private void addPropertyInternal(int index2, @NotNull GradleDslElement element2, @NotNull ElementState state2) {
        this.myProperties.addElementAtIndex(element2, state2, index2, state2 == ElementState.EXISTING);
        if (state2 == ElementState.TO_BE_ADDED) {
            this.updateDependenciesOnAddElement(element2);
            element2.setModified();
        }
    }

    public void addAppliedProperty(@NotNull GradleDslElement element2) {
        element2.addHolder(this);
        this.addPropertyInternal(element2, ElementState.APPLIED);
    }

    public void addDefaultProperty(@NotNull GradleDslElement element2) {
        element2.setElementType(PropertyType.REGULAR);
        this.addPropertyInternal(element2, ElementState.DEFAULT);
    }

    private void removePropertyInternal(@NotNull String property2) {
        List<GradleDslElement> elements = this.myProperties.removeAll(e -> e.myElement.getName().equals(property2));
        elements.forEach(e -> {
            e.setModified();
            this.updateDependenciesOnRemoveElement((GradleDslElement)e);
        });
        this.setModified();
    }

    private ElementState removePropertyInternal(@NotNull GradleDslElement element2) {
        element2.setModified();
        ElementState state2 = this.myProperties.remove(element2);
        this.updateDependenciesOnRemoveElement(element2);
        return state2;
    }

    private ElementState replacePropertyInternal(@NotNull GradleDslElement element2, @NotNull GradleDslElement newElement) {
        element2.setModified();
        this.updateDependenciesOnReplaceElement(element2, newElement);
        newElement.setModified();
        ElementState oldState = this.myProperties.replaceElement(element2, newElement);
        this.reorderAndMaybeGetNewIndex(newElement);
        return oldState;
    }

    private ElementState hidePropertyInternal(@NotNull GradleDslElement element2) {
        return this.myProperties.hide(element2);
    }

    public void addAppliedModelProperties(@NotNull GradleDslFile file2) {
        this.mergePropertiesFrom(file2);
    }

    private void mergePropertiesFrom(@NotNull GradlePropertiesDslElement other) {
        Map<String, GradleDslElement> ourProperties = this.getPropertyElements();
        for (Map.Entry<String, GradleDslElement> entry : other.getPropertyElements().entrySet()) {
            GradlePropertiesDslElement createdElement;
            GradleDslElement newProperty = entry.getValue();
            if (newProperty instanceof ApplyDslElement) continue;
            if (ourProperties.containsKey(entry.getKey())) {
                GradleDslElement existingProperty = this.getElementWhere(entry.getKey(), PROPERTY_FILTER);
                if (newProperty instanceof GradleDslBlockElement && existingProperty instanceof GradleDslBlockElement) {
                    ((GradlePropertiesDslElement)existingProperty).mergePropertiesFrom((GradlePropertiesDslElement)newProperty);
                    continue;
                }
            } else if (PropertyUtil.isPropertiesElementOrMap(newProperty) && (createdElement = this.getDslFile().getParser().getPropertiesElement(Arrays.asList(entry.getKey().split("\\.")), this, null)) != null) {
                createdElement.mergePropertiesFrom((GradlePropertiesDslElement)newProperty);
                continue;
            }
            this.addAppliedProperty(entry.getValue());
        }
    }

    public void setParsedElement(@NotNull GradleDslElement element2) {
        element2.setParent(this);
        this.addPropertyInternal(element2, ElementState.EXISTING);
    }

    public void addParsedElement(@NotNull GradleDslElement element2) {
        element2.setParent(this);
        this.addPropertyInternal(element2, ElementState.EXISTING);
    }

    public void augmentParsedElement(@NotNull GradleDslElement element2) {
        ModelEffectDescription modelEffect = element2.getModelEffect();
        if (modelEffect == null) {
            this.addParsedElement(element2);
            return;
        }
        ModelPropertyType type = modelEffect.property.type;
        if (type == ModelPropertyType.MUTABLE_LIST || type == ModelPropertyType.MUTABLE_SET) {
            this.addToParsedExpressionList(modelEffect, element2);
            return;
        }
        if (type == ModelPropertyType.MUTABLE_MAP) {
            this.addToParsedExpressionMap(modelEffect, element2);
            return;
        }
        this.addParsedElement(element2);
    }

    protected void addAsParsedDslExpressionList(@NotNull ModelEffectDescription effect, @NotNull GradleDslSimpleExpression expression2) {
        String property2 = effect.property.name;
        PsiElement psiElement = expression2.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList literalList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(property2), true);
        literalList.setModelEffect(effect);
        literalList.setElementType(PropertyType.REGULAR);
        if (expression2 instanceof GradleDslMethodCall) {
            literalList.setPsiElement(((GradleDslMethodCall)expression2).getArgumentListPsiElement());
            for (GradleDslElement gradleDslElement : ((GradleDslMethodCall)expression2).getArguments()) {
                if (!(gradleDslElement instanceof GradleDslSimpleExpression)) continue;
                literalList.addParsedExpression((GradleDslSimpleExpression)gradleDslElement);
            }
        } else {
            literalList.addParsedExpression(expression2);
        }
        this.addPropertyInternal(literalList, ElementState.EXISTING);
    }

    @Nullable
    private static PsiElement mungeElementsForAddToParsedExpressionList(@NotNull GradleDslElement dslElement, @NotNull List<GradleDslElement> newDslElements) {
        PsiElement psiElement = dslElement.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        if (dslElement instanceof GradleDslMethodCall) {
            List<GradleDslExpression> args = ((GradleDslMethodCall)dslElement).getArguments();
            if (!args.isEmpty()) {
                if (args.size() == 1 && args.get(0) instanceof GradleDslExpressionList) {
                    newDslElements.addAll(((GradleDslExpressionList)args.get(0)).getExpressions());
                    PsiElement newElement = args.get(0).getPsiElement();
                    return newElement != null ? newElement : psiElement;
                }
                newDslElements.addAll(args);
                return psiElement;
            }
            return psiElement;
        }
        if (dslElement instanceof GradleDslSimpleExpression) {
            newDslElements.add(dslElement);
            return psiElement;
        }
        if (dslElement instanceof GradleDslExpressionList) {
            newDslElements.addAll(((GradleDslExpressionList)dslElement).getExpressions());
            return psiElement;
        }
        return null;
    }

    public void addToParsedExpressionList(@NotNull String property2, @NotNull GradleDslElement element2) {
        ArrayList<GradleDslElement> newElements = new ArrayList<GradleDslElement>();
        PsiElement psiElement = GradlePropertiesDslElement.mungeElementsForAddToParsedExpressionList(element2, newElements);
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(property2), false);
            this.addPropertyInternal(gradleDslExpressionList, ElementState.EXISTING);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        newElements.forEach(gradleDslExpressionList::addParsedElement);
    }

    public void addToParsedExpressionList(@NotNull ModelEffectDescription effect, @NotNull GradleDslElement element2) {
        ArrayList<GradleDslElement> newElements = new ArrayList<GradleDslElement>();
        PsiElement psiElement = GradlePropertiesDslElement.mungeElementsForAddToParsedExpressionList(element2, newElements);
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(effect.property, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(effect.property.name), false);
            ModelEffectDescription createEffect = new ModelEffectDescription(effect.property, ModelSemanticsDescription.CREATE_WITH_VALUE, effect.versionConstraint);
            gradleDslExpressionList.setModelEffect(createEffect);
            gradleDslExpressionList.setElementType(PropertyType.REGULAR);
            this.addPropertyInternal(gradleDslExpressionList, ElementState.EXISTING);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        newElements.forEach(gradleDslExpressionList::addParsedElement);
    }

    public void addToParsedExpressionMap(@NotNull ModelEffectDescription effect, @NotNull GradleDslElement element2) {
        if (!((element2 = PropertyUtil.followElement(element2)) instanceof GradleDslExpressionMap)) {
            return;
        }
        GradleDslExpressionMap map2 = this.getPropertyElement(effect.property, GradleDslExpressionMap.class);
        if (map2 == null) {
            map2 = new GradleDslExpressionMap(this, element2.getPsiElement(), GradleNameElement.create(effect.property.name), true);
            ModelEffectDescription createEffect = new ModelEffectDescription(effect.property, ModelSemanticsDescription.CREATE_WITH_VALUE, effect.versionConstraint);
            map2.setModelEffect(createEffect);
            map2.setElementType(PropertyType.REGULAR);
            this.addPropertyInternal(map2, ElementState.EXISTING);
        } else {
            map2.setPsiElement(element2.getPsiElement());
            SemanticsDescription semantics = ModelSemanticsDescription.CREATE_WITH_VALUE;
            ModelEffectDescription currentEffect = map2.getModelEffect();
            if (currentEffect != null) {
                semantics = currentEffect.semantics;
            }
            ModelEffectDescription newEffect = new ModelEffectDescription(effect.property, semantics, effect.versionConstraint);
            map2.setModelEffect(newEffect);
        }
        GradleDslExpressionMap newElements = (GradleDslExpressionMap)element2;
        for (Map.Entry<String, GradleDslElement> entry : newElements.getPropertyElements().entrySet()) {
            map2.setParsedElement(entry.getValue());
        }
    }

    @NotNull
    protected ImmutableMap<String, PropertiesElementDescription> getChildPropertiesElementsDescriptionMap() {
        return NO_CHILD_PROPERTIES_ELEMENTS;
    }

    @Nullable
    public PropertiesElementDescription getChildPropertiesElementDescription(String name) {
        return (PropertiesElementDescription)this.getChildPropertiesElementsDescriptionMap().get((Object)name);
    }

    @NotNull
    public Set<String> getProperties() {
        return this.getPropertyElements().keySet();
    }

    @NotNull
    public Map<String, GradleDslElement> getPropertyElements() {
        return this.getElementsWhere(PROPERTY_FILTER);
    }

    @NotNull
    public <T extends GradleDslElement> List<T> getPropertyElements(@NotNull String name, @NotNull Class<T> clazz) {
        return this.myProperties.getElementsWhere(PROPERTY_FILTER).stream().filter(e -> clazz.isAssignableFrom(e.getClass()) && e.getName().equals(name)).map(e -> (GradleDslElement)clazz.cast(e)).collect(Collectors.toList());
    }

    @NotNull
    public List<GradleDslElement> getAllPropertyElements() {
        return this.myProperties.getElementsWhere(PROPERTY_FILTER);
    }

    @NotNull
    public Map<String, GradleDslElement> getVariableElements() {
        return this.getElementsWhere(VARIABLE_FILTER);
    }

    @NotNull
    public Map<String, GradleDslElement> getElements() {
        return this.getElementsWhere(ANY_FILTER);
    }

    @NotNull
    public List<GradleDslElement> getAllElements() {
        return this.myProperties.getElementsWhere(ANY_FILTER);
    }

    @NotNull
    private Map<String, GradleDslElement> getElementsWhere(@NotNull Predicate<ElementList.ElementItem> predicate2) {
        LinkedHashMap<String, GradleDslElement> results = new LinkedHashMap<String, GradleDslElement>();
        List<GradleDslElement> elements = this.myProperties.getElementsWhere(predicate2);
        for (GradleDslElement element2 : elements) {
            if (element2 == null) continue;
            results.put(element2.getName(), element2);
        }
        return results;
    }

    private GradleDslElement getElementWhere(@NotNull String name, @NotNull Predicate<ElementList.ElementItem> predicate2) {
        return this.getElementWhere(e -> predicate2.test((ElementList.ElementItem)e) && e.myElement.getName().equals(name));
    }

    private GradleDslElement getElementWhere(@NotNull ModelPropertyDescription property2, @NotNull Predicate<ElementList.ElementItem> predicate2) {
        return this.getElementWhere(e -> predicate2.test((ElementList.ElementItem)e) && property2.equals(e.myElement.getModelProperty()));
    }

    protected GradleDslElement getElementWhere(@NotNull Predicate<ElementList.ElementItem> predicate2) {
        return this.myProperties.getElementWhere(predicate2);
    }

    private GradleDslElement getElementBeforeChildWhere(@NotNull String name, Predicate<ElementList.ElementItem> predicate2, @NotNull GradleDslElement element2, boolean includeSelf) {
        return this.getElementBeforeChildWhere(e -> predicate2.test((ElementList.ElementItem)e) && e.myElement.getName().equals(name), element2, includeSelf);
    }

    protected GradleDslElement getElementBeforeChildWhere(Predicate<ElementList.ElementItem> predicate2, @NotNull GradleDslElement element2, boolean includeSelf) {
        return this.myProperties.getElementBeforeChildWhere(predicate2, element2, includeSelf);
    }

    @Nullable
    public GradleDslElement getVariableElement(@NotNull String property2) {
        return this.getElementWhere(property2, VARIABLE_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull String property2) {
        return this.getElementWhere(property2, PROPERTY_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull ModelPropertyDescription property2) {
        return this.getElementWhere(property2, PROPERTY_FILTER);
    }

    @Nullable
    public GradleDslElement getElement(@NotNull String property2) {
        return this.getElementWhere(property2, ANY_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElementBefore(@Nullable GradleDslElement element2, @NotNull String property2, boolean includeSelf) {
        if (element2 == null) {
            return this.getElementWhere(property2, PROPERTY_FILTER);
        }
        return this.getElementBeforeChildWhere(property2, PROPERTY_FILTER, element2, includeSelf);
    }

    @Nullable
    GradleDslElement getElementBefore(@Nullable GradleDslElement element2, @NotNull String property2, boolean includeSelf) {
        if (element2 == null) {
            return this.getElementWhere(property2, ANY_FILTER);
        }
        return this.getElementBeforeChildWhere(property2, ANY_FILTER, element2, includeSelf);
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull String property2, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement = this.getPropertyElement(property2);
        return (T)(clazz.isInstance(propertyElement) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull ModelPropertyDescription property2, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement = this.getPropertyElement(property2);
        return (T)(clazz.isInstance(propertyElement) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @Nullable
    public <T extends GradlePropertiesDslElement> T getPropertyElement(@NotNull PropertiesElementDescription<T> description2) {
        assert (description2.name != null);
        return (T)((GradlePropertiesDslElement)this.getPropertyElement(description2.name, description2.clazz));
    }

    @NotNull
    public <T extends GradlePropertiesDslElement> T ensurePropertyElement(@NotNull PropertiesElementDescription<T> description2) {
        return this.ensurePropertyElementAt(description2, null);
    }

    @NotNull
    public <T extends GradlePropertiesDslElement, U> T ensurePropertyElementBefore(@NotNull PropertiesElementDescription<T> description2, Class<U> before) {
        Integer at = null;
        List<GradleDslElement> elements = this.getCurrentElements();
        for (int i = 0; i < elements.size(); ++i) {
            if (!before.isInstance(elements.get(i))) continue;
            at = i;
            break;
        }
        return this.ensurePropertyElementAt(description2, at);
    }

    @NotNull
    public <T extends GradlePropertiesDslElement> T ensureNamedPropertyElement(PropertiesElementDescription<T> description2, GradleNameElement name) {
        GradlePropertiesDslElement propertyElement = (GradlePropertiesDslElement)this.getPropertyElement(name.name(), description2.clazz);
        if (propertyElement != null) {
            return (T)propertyElement;
        }
        assert (description2.name == null);
        Object newElement = description2.constructor.construct(this, name);
        this.setNewElement((GradleDslElement)newElement);
        return newElement;
    }

    @NotNull
    public <T extends GradlePropertiesDslElement> T ensurePropertyElementAt(PropertiesElementDescription<T> description2, Integer at) {
        T propertyElement = this.getPropertyElement(description2);
        if (propertyElement != null) {
            return propertyElement;
        }
        assert (description2.name != null);
        Object newElement = description2.constructor.construct(this, GradleNameElement.create(description2.name));
        if (at != null) {
            this.addNewElementAt(at, (GradleDslElement)newElement);
        } else {
            this.setNewElement((GradleDslElement)newElement);
        }
        return newElement;
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull List<String> properties2, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement = this.myProperties.getElementWhere(e -> properties2.contains(e.myElement.getName()));
        return (T)(clazz.isInstance(propertyElement) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @NotNull
    public <T extends GradleDslElement> List<T> getPropertyElements(@NotNull Class<T> clazz) {
        return this.myProperties.getElementsWhere(PROPERTY_FILTER).stream().filter(e -> clazz.isAssignableFrom(e.getClass())).map(e -> (GradleDslElement)clazz.cast(e)).collect(Collectors.toList());
    }

    @NotNull
    public List<GradleDslElement> getPropertyElementsByName(@NotNull String propertyName) {
        return this.myProperties.getElementsWhere(e -> e.myElement.getName().equals(propertyName) && PROPERTY_FILTER.test((ElementList.ElementItem)e));
    }

    @NotNull
    public List<GradleDslElement> getOriginalElements() {
        return this.myProperties.myElements.stream().filter(e -> e.myExistsOnFile).map(e -> e.myElement).collect(Collectors.toList());
    }

    @Nullable
    public GradleDslElement getOriginalElementForNameAndType(@NotNull String name, @NotNull PropertyType type) {
        return this.myProperties.myElements.stream().filter(e -> e.myElement.getName().equals(name) && e.myExistsOnFile && e.myElement.getElementType() == type).map(e -> e.myElement).reduce((a, b) -> b).orElse(null);
    }

    @NotNull
    public List<GradleDslElement> getCurrentElements() {
        Predicate<ElementList.ElementItem> currentElementFilter = e -> e.myElementState == ElementState.TO_BE_ADDED || e.myElementState == ElementState.EXISTING || e.myElementState == ElementState.MOVED || e.myElementState == ElementState.DEFAULT && e.myElement instanceof GradlePropertiesDslElement && !((GradlePropertiesDslElement)e.myElement).getCurrentElements().isEmpty();
        return this.myProperties.myElements.stream().filter(currentElementFilter).map(e -> e.myElement).collect(Collectors.toList());
    }

    public void setNewElement(@NotNull GradleDslElement newElement) {
        newElement.setParent(this);
        this.addPropertyInternal(newElement, ElementState.TO_BE_ADDED);
        this.setModified();
    }

    public void addNewElementAt(int index2, @NotNull GradleDslElement newElement) {
        newElement.setParent(this);
        this.addPropertyInternal(index2, newElement, ElementState.TO_BE_ADDED);
        this.setModified();
    }

    @VisibleForTesting
    public void moveElementTo(int index2, @NotNull GradleDslElement newElement) {
        assert (newElement.getParent() == this);
        this.myProperties.moveElementToIndex(newElement, index2);
    }

    public void replaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        newElement.setParent(this);
        ArrayList<GradlePropertiesDslElement> holders = new ArrayList<GradlePropertiesDslElement>();
        holders.add(this);
        holders.addAll(oldElement.getHolders());
        for (GradlePropertiesDslElement holder : holders) {
            holder.replacePropertyInternal(oldElement, newElement);
        }
    }

    public void substituteElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        assert (newElement.getParent() == this);
        this.myProperties.substituteElement(oldElement, newElement);
    }

    @Nullable
    public <T> T getLiteral(@NotNull String property2, @NotNull Class<T> clazz) {
        GradleDslSimpleExpression expression2 = this.getPropertyElement(property2, GradleDslSimpleExpression.class);
        if (expression2 == null) {
            return null;
        }
        return expression2.getValue(clazz);
    }

    @NotNull
    public GradleDslLiteral setNewLiteral(@NotNull String property2, @NotNull Object value2) {
        return this.setNewLiteralImpl(property2, value2);
    }

    @NotNull
    private GradleDslLiteral setNewLiteralImpl(@NotNull String property2, @NotNull Object value2) {
        GradleDslLiteral literalElement = this.getPropertyElement(property2, GradleDslLiteral.class);
        if (literalElement == null) {
            literalElement = new GradleDslLiteral(this, GradleNameElement.create(property2));
            this.addPropertyInternal(literalElement, ElementState.TO_BE_ADDED);
        }
        literalElement.setValue(value2);
        return literalElement;
    }

    public void removeProperty(@NotNull String property2) {
        this.removePropertyInternal(property2);
    }

    public void removeProperty(@NotNull GradleDslElement element2) {
        this.removePropertyInternal(element2);
        for (GradlePropertiesDslElement holder : element2.getHolders()) {
            if (this == holder) continue;
            holder.removePropertyInternal(element2);
        }
        GradleDslElement parent2 = element2.getParent();
        if (this != parent2 && parent2 instanceof GradlePropertiesDslElement) {
            ((GradlePropertiesDslElement)parent2).removePropertyInternal(element2);
        }
    }

    public void hideProperty(@NotNull GradleDslElement element2) {
        this.hidePropertyInternal(element2);
        for (GradlePropertiesDslElement holder : element2.getHolders()) {
            if (this == holder) continue;
            holder.removePropertyInternal(element2);
        }
        GradleDslElement parent2 = element2.getParent();
        if (this != parent2 && parent2 instanceof GradlePropertiesDslElement) {
            ((GradlePropertiesDslElement)parent2).hidePropertyInternal(element2);
        }
    }

    @Override
    @Nullable
    public GradleDslElement requestAnchor(@NotNull GradleDslElement element2) {
        GradleDslElement lastElement = null;
        for (ElementList.ElementItem item2 : this.myProperties.myElements) {
            GradleDslElement currentElement;
            if (item2.myElement == element2) {
                return lastElement;
            }
            if (!item2.myElementState.isPhysicalInFile() || (currentElement = item2.myElement) instanceof ProjectPropertiesDslElement && ((ProjectPropertiesDslElement)currentElement).getAllPropertyElements().isEmpty()) continue;
            if (item2.myElement instanceof ApplyDslElement) {
                lastElement = item2.myElement.requestAnchor(element2);
                continue;
            }
            lastElement = item2.myElement;
        }
        return lastElement;
    }

    @Override
    @NotNull
    public Collection<GradleDslElement> getChildren() {
        return this.getAllElements();
    }

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        ArrayList<GradleDslElement> result2 = new ArrayList<GradleDslElement>();
        if (includeProperties) {
            result2.addAll(this.getElementsWhere(e -> e.myElementState != ElementState.APPLIED && !e.isDefaultElement()).values());
        } else {
            result2.addAll(this.getVariableElements().values());
        }
        List<GradlePropertiesDslElement> holders = this.getPropertyElements(GradlePropertiesDslElement.class).stream().filter(e -> !(e instanceof GradleDslExpression)).collect(Collectors.toList());
        holders.forEach(e -> result2.addAll(e.getContainedElements(includeProperties)));
        return result2;
    }

    @Override
    public void delete() {
        this.myProperties.forEach(e -> e.myElement.delete());
        super.delete();
    }

    protected void deleteAndRecreate() {
        this.myProperties.removeElements(GradleDslElement::delete);
        if (!this.myProperties.isEmpty()) {
            this.myProperties.forEach(item2 -> {
                GradleDslElement element2;
                GradleDslElement copy = element2 = item2.myElement;
                if (element2 instanceof GradleDslExpression) {
                    copy = ((GradleDslExpression)element2).copy();
                }
                element2.getDslFile().getWriter().deleteDslElement(element2);
                item2.myElement = copy;
            });
            this.getDslFile().getWriter().deleteDslElement(this);
            this.create();
            this.myProperties.forEach(item2 -> {
                GradleDslElement element2 = item2.myElement;
                element2.create();
                item2.myElementState = ElementState.EXISTING;
            });
        }
    }

    protected boolean isStructurallyModified() {
        Predicate<ElementList.ElementItem> predicate2 = e -> e.myElementState.isStructuralChange();
        return this.myProperties.myElements.stream().anyMatch(predicate2);
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslPropertiesElement(this);
        this.myProperties.removeElements(GradleDslElement::delete);
        this.myProperties.createElements(e -> e.create() != null);
        this.myProperties.applyElements(e -> {
            if (e.isModified()) {
                e.applyChanges();
            }
        });
        this.myProperties.forEach(item2 -> {
            if (item2.myElementState == ElementState.MOVED) {
                item2.myElement.move();
            }
        });
    }

    @Override
    protected void reset() {
        this.myProperties.reset();
    }

    protected void clear() {
        this.myProperties.clear();
    }

    public int reorderAndMaybeGetNewIndex(@NotNull GradleDslElement element2) {
        int result2 = this.sortElementsAndMaybeGetNewIndex(element2);
        element2.resolve();
        return result2;
    }

    private int sortElementsAndMaybeGetNewIndex(@NotNull GradleDslElement element2) {
        List<GradleDslElement> currentElements = this.myProperties.getElementsWhere(e -> e.myElementState == ElementState.EXISTING || e.myElementState == ElementState.TO_BE_ADDED);
        ArrayList<GradleDslElement> sortedElements = new ArrayList<GradleDslElement>();
        boolean result2 = ElementSort.create(this, element2).sort(currentElements, sortedElements);
        int resultIndex = this.myProperties.myElements.size();
        if (!result2) {
            this.notification(NotificationTypeReference.PROPERTY_PLACEMENT);
            return resultIndex;
        }
        int i = 0;
        int j = 0;
        while (i < currentElements.size() && j < sortedElements.size()) {
            if (currentElements.get(i) == sortedElements.get(i)) {
                ++i;
                ++j;
                continue;
            }
            if (sortedElements.get(i) == element2 && !currentElements.contains(element2)) {
                resultIndex = i;
                ++j;
                continue;
            }
            this.moveElementTo(i, (GradleDslElement)sortedElements.get(j));
            ++i;
            ++j;
        }
        return resultIndex;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        return this.myProperties.getElementsWhere(e -> e.myElementState != ElementState.APPLIED).stream().map(GradleDslElement::getDependencies).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @VisibleForTesting
    public boolean isApplied(@NotNull GradleDslElement element2) {
        for (ElementList.ElementItem item2 : this.myProperties.myElements) {
            if (item2.myElement != element2) continue;
            return item2.myElementState == ElementState.APPLIED;
        }
        throw new IllegalStateException("Element not found in parent");
    }

    void updateAppliedState(@NotNull GradleDslElement element2) {
        for (ElementList.ElementItem item2 : this.myProperties.myElements) {
            if (item2.myElement != element2) continue;
            if (item2.myElementState == ElementState.APPLIED) {
                item2.myElementState = ElementState.TO_BE_ADDED;
            }
            return;
        }
        LOG.warn((Throwable)new IllegalStateException("Element " + element2 + " not found in parent " + this));
    }

    protected static class ElementList {
        @NotNull
        private final List<ElementItem> myElements = new ArrayList<ElementItem>();

        private void forEach(@NotNull Consumer<ElementItem> func) {
            this.myElements.forEach(func);
        }

        @NotNull
        private List<GradleDslElement> getElementsWhere(@NotNull Predicate<ElementItem> predicate2) {
            return this.myElements.stream().filter(e -> e.myElementState.isSemanticallyRelevant()).filter(predicate2).map(e -> e.myElement).collect(Collectors.toList());
        }

        @Nullable
        public GradleDslElement getElementWhere(@NotNull Predicate<ElementItem> predicate2) {
            ModelEffectDescription effect;
            GradleDslElement last = this.myElements.stream().filter(e -> e.myElementState.isSemanticallyRelevant()).filter(predicate2).map(e -> e.myElement).reduce((first, second) -> second).orElse(null);
            if (last != null && (effect = last.getModelEffect()) != null && effect.semantics == MethodSemanticsDescription.RESET) {
                return null;
            }
            return last;
        }

        @Nullable
        public GradleDslElement getElementBeforeChildWhere(@NotNull Predicate<ElementItem> predicate2, @NotNull GradleDslElement child, boolean includeSelf) {
            GradleDslElement lastElement = null;
            for (ElementItem i : this.myElements) {
                if (!i.myElementState.isSemanticallyRelevant()) continue;
                if (predicate2.test(i) && (includeSelf || child != i.myElement)) {
                    lastElement = i.myElement;
                }
                if (i.myElement != child) continue;
                return lastElement;
            }
            return lastElement;
        }

        public void addElement(@NotNull GradleDslElement newElement, @NotNull ElementState state2, boolean onFile) {
            this.myElements.add(new ElementItem(newElement, state2, onFile));
        }

        private void addElementAtIndex(@NotNull GradleDslElement newElement, @NotNull ElementState state2, int index2, boolean onFile) {
            this.myElements.add(this.getRealIndex(index2, newElement), new ElementItem(newElement, state2, onFile));
        }

        private void moveElementToIndex(@NotNull GradleDslElement element2, int index2) {
            ElementItem item2 = this.myElements.stream().filter(e -> e.myElement == element2).findFirst().orElse(null);
            if (item2 == null) {
                return;
            }
            this.myElements.remove(item2);
            ElementList.moveElementTree(item2);
            this.myElements.add(this.getRealIndex(index2, element2), item2);
        }

        private int getRealIndex(int index2, @NotNull GradleDslElement element2) {
            if (index2 <= 0) {
                return 0;
            }
            for (int i = 0; i < this.myElements.size(); ++i) {
                if (index2 == 0) {
                    return i;
                }
                ElementItem item2 = this.myElements.get(i);
                if (!item2.myElementState.isPhysicalInFile()) continue;
                --index2;
            }
            return this.myElements.size();
        }

        @Nullable
        private ElementState remove(@NotNull GradleDslElement element2) {
            ElementItem item2 = this.myElements.stream().filter(e -> element2 == e.myElement).findFirst().orElse(null);
            if (item2 == null) {
                return null;
            }
            ElementState oldState = item2.myElementState;
            item2.myElementState = ElementState.TO_BE_REMOVED;
            return oldState;
        }

        @Nullable
        private ElementState hide(@NotNull GradleDslElement element2) {
            ElementItem item2 = this.myElements.stream().filter(e -> element2 == e.myElement).findFirst().orElse(null);
            if (item2 == null) {
                return null;
            }
            ElementState oldState = item2.myElementState;
            item2.myElementState = ElementState.HIDDEN;
            return oldState;
        }

        @Nullable
        private ElementState replaceElement(@Nullable GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
            for (int i = 0; i < this.myElements.size(); ++i) {
                ElementItem item2 = this.myElements.get(i);
                if (oldElement != item2.myElement) continue;
                ElementState oldState = item2.myElementState;
                item2.myElementState = ElementState.TO_BE_REMOVED;
                ElementState newState = ElementState.TO_BE_ADDED;
                if (Arrays.asList(ElementState.APPLIED, ElementState.HIDDEN).contains((Object)oldState)) {
                    newState = oldState;
                }
                this.myElements.add(i, new ElementItem(newElement, newState, false));
                return oldState;
            }
            return null;
        }

        @Nullable
        private ElementState substituteElement(@Nullable GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
            for (int i = 0; i < this.myElements.size(); ++i) {
                ElementItem item2 = this.myElements.get(i);
                if (oldElement != item2.myElement) continue;
                item2.myElement = newElement;
                if (newElement.getPsiElement() == null) {
                    item2.myElementState = ElementState.TO_BE_ADDED;
                    item2.myExistsOnFile = false;
                } else {
                    item2.myElementState = ElementState.EXISTING;
                    item2.myExistsOnFile = true;
                }
                return item2.myElementState;
            }
            return null;
        }

        @NotNull
        private List<GradleDslElement> removeAll(@NotNull Predicate<ElementItem> filter2) {
            List<ElementItem> toBeRemoved = this.myElements.stream().filter(filter2).collect(Collectors.toList());
            toBeRemoved.forEach((? super T e) -> {
                e.myElementState = ElementState.TO_BE_REMOVED;
            });
            return ContainerUtil.map(toBeRemoved, e -> e.myElement);
        }

        private boolean isEmpty() {
            return this.myElements.isEmpty();
        }

        private void reset() {
            LinkedHashSet<String> seen = new LinkedHashSet<String>();
            Iterator<ElementItem> i = this.myElements.iterator();
            while (i.hasNext()) {
                ElementItem item2 = i.next();
                item2.myElement.resetState();
                if (item2.myElementState == ElementState.TO_BE_REMOVED) {
                    item2.myElementState = ElementState.EXISTING;
                }
                if (item2.myElementState == ElementState.EXISTING) {
                    seen.add(item2.myElement.getName());
                }
                if (item2.myElementState == ElementState.TO_BE_ADDED) {
                    i.remove();
                }
                if (item2.myElementState != ElementState.DEFAULT || !seen.contains(item2.myElement.getName())) continue;
                i.remove();
            }
        }

        private void removeElements(@NotNull Consumer<GradleDslElement> removeFunc) {
            Iterator<ElementItem> i = this.myElements.iterator();
            while (i.hasNext()) {
                ElementItem item2 = i.next();
                if (item2.myElementState != ElementState.TO_BE_REMOVED) continue;
                removeFunc.accept(item2.myElement);
                i.remove();
            }
        }

        private void createElements(@NotNull Predicate<GradleDslElement> addFunc) {
            Iterator<ElementItem> i = this.myElements.iterator();
            while (i.hasNext()) {
                ElementItem item2 = i.next();
                if (item2.myElementState == ElementState.DEFAULT && !item2.isDefaultElement()) {
                    item2.myElementState = ElementState.TO_BE_ADDED;
                }
                if (item2.myElementState != ElementState.TO_BE_ADDED) continue;
                if (addFunc.test(item2.myElement)) {
                    item2.myElementState = ElementState.EXISTING;
                    continue;
                }
                i.remove();
            }
        }

        private void applyElements(@NotNull Consumer<GradleDslElement> func) {
            this.myElements.stream().filter(e -> e.myElementState != ElementState.APPLIED).map(e -> e.myElement).forEach(func);
        }

        private void clear() {
            this.myElements.clear();
        }

        private static void moveElementTree(@NotNull ElementItem item2) {
            if (item2.myElementState != ElementState.TO_BE_ADDED) {
                item2.myElementState = ElementState.MOVED;
            }
            item2.myElement.setModified();
        }

        public static class ElementItem {
            @NotNull
            private GradleDslElement myElement;
            @NotNull
            private ElementState myElementState;
            private boolean myExistsOnFile;

            private ElementItem(@NotNull GradleDslElement element2, @NotNull ElementState state2, boolean existsOnFile) {
                this.myElement = element2;
                this.myElementState = state2;
                this.myExistsOnFile = existsOnFile;
            }

            private boolean isDefaultElement() {
                return this.myElementState == ElementState.DEFAULT && this.myElement.isInsignificantIfEmpty() && this.myElement instanceof GradlePropertiesDslElement && ((GradlePropertiesDslElement)this.myElement).getCurrentElements().isEmpty();
            }
        }
    }
}

