/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleDslExpressionList
extends GradlePropertiesDslElement
implements GradleDslExpression {
    private static final Logger LOG = Logger.getInstance(GradleDslExpressionList.class);
    private final boolean myAppendToArgumentListWithOneElement;
    private boolean myShouldBeDeleted;
    private boolean myIsLiteralList;

    public GradleDslExpressionList(@Nullable GradleDslElement parent2, @NotNull GradleNameElement name, boolean isLiteralList) {
        super(parent2, null, name);
        this.myAppendToArgumentListWithOneElement = false;
        this.myIsLiteralList = isLiteralList;
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent2, @NotNull PsiElement psiElement, boolean isLiteralList, @NotNull GradleNameElement name) {
        super(parent2, psiElement, name);
        this.myAppendToArgumentListWithOneElement = false;
        this.myIsLiteralList = isLiteralList;
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent2, @NotNull PsiElement psiElement, @NotNull GradleNameElement name, boolean appendToArgumentListWithOneElement) {
        super(parent2, psiElement, name);
        this.myAppendToArgumentListWithOneElement = appendToArgumentListWithOneElement;
        this.myIsLiteralList = false;
    }

    public void addParsedExpression(@NotNull GradleDslExpression expression2) {
        super.addParsedElement(expression2);
    }

    public void addNewExpression(@NotNull GradleDslExpression expression2) {
        this.setNewElement(expression2);
    }

    public void addNewExpression(@NotNull GradleDslExpression expression2, int index2) {
        this.addNewElementAt(index2, expression2);
    }

    public void removeElement(@NotNull GradleDslElement element2) {
        super.removeProperty(element2);
    }

    public GradleDslExpression getElementAt(int index2) {
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        if (index2 < 0 || index2 > expressions.size()) {
            return null;
        }
        return expressions.get(index2);
    }

    public int findIndexOf(@NotNull GradleDslElement element2) {
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        for (int i = 0; i < expressions.size(); ++i) {
            if (!expressions.get(i).equals(element2)) continue;
            return i;
        }
        return -1;
    }

    public void replaceExpression(@NotNull GradleDslExpression oldExpression, @NotNull GradleDslExpression newExpression) {
        super.replaceElement(oldExpression, newExpression);
    }

    @NotNull
    public List<GradleDslExpression> getExpressions() {
        return this.getPropertyElements(GradleDslExpression.class);
    }

    @NotNull
    public List<GradleDslSimpleExpression> getSimpleExpressions() {
        return this.getExpressions().stream().filter(e -> e instanceof GradleDslSimpleExpression).map(e -> (GradleDslSimpleExpression)e).collect(Collectors.toList());
    }

    @NotNull
    public <T> List<T> getLiterals(@NotNull Class<T> clazz) {
        return this.getSimpleExpressions().stream().map(e -> e.getValue(clazz)).filter(e -> e != null).collect(Collectors.toList());
    }

    public boolean isLiteralList() {
        return this.myIsLiteralList;
    }

    public boolean isAppendToArgumentListWithOneElement() {
        return this.myAppendToArgumentListWithOneElement;
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.getDslFile().getWriter().createDslExpressionList(this);
    }

    @Override
    public void delete() {
        this.myShouldBeDeleted = true;
        super.delete();
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslExpressionList(this);
        ModelEffectDescription effect = this.getModelEffect();
        if (effect != null && effect.semantics == ModelSemanticsDescription.CREATE_WITH_VALUE && this.isStructurallyModified()) {
            this.deleteAndRecreate();
        } else {
            super.apply();
        }
    }

    @Override
    @Nullable
    public PsiElement getExpression() {
        return this.getPsiElement();
    }

    public boolean shouldBeDeleted() {
        return !this.isLiteralList() || this.myShouldBeDeleted;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        return ContainerUtil.filter(this.getDependencies(), e -> e.isResolved());
    }

    @Override
    public void setParsedElement(@NotNull GradleDslElement element2) {
        if (!(element2 instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + element2));
            return;
        }
        super.setParsedElement(element2);
    }

    @Override
    public void addParsedElement(@NotNull GradleDslElement element2) {
        if (!(element2 instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + element2));
            return;
        }
        super.addParsedElement(element2);
    }

    @Override
    public void addToParsedExpressionList(@NotNull String property2, @NotNull GradleDslElement element2) {
        if (!(element2 instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + element2));
            return;
        }
        super.addToParsedExpressionList(property2, element2);
    }

    @Override
    public void setNewElement(@NotNull GradleDslElement newElement) {
        if (!(newElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + newElement));
            return;
        }
        super.setNewElement(newElement);
    }

    @Override
    public void addNewElementAt(int index2, @NotNull GradleDslElement newElement) {
        if (!(newElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + newElement));
            return;
        }
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        if (index2 > expressions.size()) {
            LOG.warn((Throwable)new IndexOutOfBoundsException(index2 + " is out of bounds for size " + expressions.size()));
            return;
        }
        super.addNewElementAt(index2, newElement);
    }

    @Override
    public void replaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (!(oldElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression (old): " + oldElement));
            return;
        }
        if (!(newElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression (new): " + newElement));
            return;
        }
        super.replaceElement(oldElement, newElement);
    }

    @Override
    @NotNull
    public GradleDslExpressionList copy() {
        GradleDslExpressionList listClone = new GradleDslExpressionList(this.myParent, GradleNameElement.copy(this.myName), false);
        for (GradleDslElement element2 : this.getCurrentElements()) {
            GradleDslExpression sourceExpression = (GradleDslExpression)element2;
            GradleDslExpression copiedExpression = sourceExpression.copy();
            listClone.setNewElement(copiedExpression);
        }
        return listClone;
    }
}

