/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.InterpolatedText;
import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpecImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.FakeElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeArtifactElement
extends FakeElement {
    private static final Logger LOG = Logger.getInstance(FakeArtifactElement.class);
    @NotNull
    private final Function<ArtifactDependencySpec, String> myGetter;
    @NotNull
    private final BiConsumer<ArtifactDependencySpecImpl, String> mySetter;
    @NotNull
    private static final Pattern WRAPPED_VARIABLE_FORM = Pattern.compile("\\$\\{(.*)}");
    @NotNull
    private static final Pattern UNWRAPPED_VARIABLE_FORM = Pattern.compile("\\$(([a-zA-Z]\\w*)(\\.([a-zA-Z]\\w+))*)");

    public static boolean shouldInterpolate(@Nullable String str) {
        return str != null && (WRAPPED_VARIABLE_FORM.matcher(str).matches() || UNWRAPPED_VARIABLE_FORM.matcher(str).matches());
    }

    public FakeArtifactElement(@Nullable GradleDslElement parent2, @NotNull GradleNameElement name, @NotNull GradleDslSimpleExpression originExpression, @NotNull Function<ArtifactDependencySpec, String> getFunc, @NotNull BiConsumer<ArtifactDependencySpecImpl, String> setFunc, boolean canDelete) {
        super(parent2, name, originExpression, canDelete);
        this.myGetter = getFunc;
        this.mySetter = setFunc;
    }

    @Override
    @Nullable
    public Object extractValue() {
        GradleDslSimpleExpression resolved = PropertyUtil.resolveElement(this.myRealExpression);
        ArtifactDependencySpecImpl spec = FakeArtifactElement.getSpec(resolved);
        if (spec == null) {
            return null;
        }
        if (resolved.getDslFile().getParser().shouldInterpolate(resolved)) {
            String result2 = this.myGetter.apply(spec);
            return result2 == null ? null : GradlePropertyModel.iStr(result2);
        }
        return this.myGetter.apply(spec);
    }

    @Override
    protected void consumeValue(@Nullable Object value2) {
        assert (this.myCanDelete || value2 != null);
        GradleDslSimpleExpression resolved = PropertyUtil.resolveElement(this.myRealExpression);
        ArtifactDependencySpecImpl spec = FakeArtifactElement.getSpec(resolved);
        if (spec == null) {
            LOG.warn((Throwable)new IllegalArgumentException("Could not create ArtifactDependencySpec from: " + value2));
            return;
        }
        boolean shouldQuote = false;
        String strValue = null;
        if (value2 instanceof ReferenceTo) {
            strValue = resolved.getDslFile().getParser().convertReferenceToExternalText((GradleDslElement)resolved, ((ReferenceTo)value2).getReferredElement(), true);
            shouldQuote = true;
        } else if (value2 instanceof InterpolatedText) {
            InterpolatedText interpolatedValue = (InterpolatedText)value2;
            StringBuilder builder2 = new StringBuilder();
            for (InterpolatedText.InterpolatedTextItem elem : interpolatedValue.getInterpolationElements()) {
                if (elem.getTextItem() != null) {
                    builder2.append(elem.getTextItem());
                }
                if (elem.getReferenceItem() == null) continue;
                String externalText = resolved.getDslFile().getParser().convertReferenceToExternalText((GradleDslElement)resolved, elem.getReferenceItem().getReferredElement(), true);
                builder2.append(externalText != "" ? externalText : elem.getReferenceItem().getReferredElement().getFullName());
            }
            strValue = builder2.toString();
        } else if (value2 instanceof RawText) {
            GradleDslNameConverter.Kind nameConverterKind = resolved.getDslFile().getWriter().getKind();
            if (nameConverterKind == GradleDslNameConverter.Kind.GROOVY) {
                strValue = ((RawText)value2).getGroovyText();
            } else if (nameConverterKind == GradleDslNameConverter.Kind.KOTLIN) {
                strValue = ((RawText)value2).getKtsText();
            }
            if (strValue != null && FakeArtifactElement.isDoubleQuotedString(strValue)) {
                shouldQuote = true;
                strValue = StringUtil.unquoteString((String)strValue);
            }
        } else if (value2 != null && FakeArtifactElement.isDoubleQuotedString(strValue = (String)value2)) {
            shouldQuote = true;
            strValue = StringUtil.unquoteString((String)((String)value2));
        }
        this.mySetter.accept(spec, strValue);
        if (shouldQuote || resolved.getDslFile().getParser().shouldInterpolate(resolved)) {
            this.myRealExpression.setValue(GradlePropertyModel.iStr(spec.compactNotation()));
        } else {
            this.myRealExpression.setValue(spec.compactNotation());
        }
    }

    private static boolean isDoubleQuotedString(@NotNull String str) {
        return StringUtil.isQuotedString((String)str) && str.charAt(0) == '\"';
    }

    @Override
    @Nullable
    public Object produceRawValue() {
        return this.getUnresolvedValue();
    }

    @Override
    @NotNull
    public GradleDslSimpleExpression copy() {
        return new FakeArtifactElement(this.myParent, GradleNameElement.copy(this.myFakeName), this.myRealExpression, this.myGetter, this.mySetter, this.myCanDelete);
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        PsiElement realExpression = this.myRealExpression instanceof GradleDslSettableExpression ? ((GradleDslSettableExpression)this.myRealExpression).getCurrentElement() : this.myRealExpression.getExpression();
        if (realExpression == null) {
            return ImmutableList.of();
        }
        String referenceText = this.getReferenceText();
        if (referenceText == null) {
            return ImmutableList.of();
        }
        GradleDslSimpleExpression resolved = PropertyUtil.resolveElement(this.myRealExpression);
        GradleDslElement element2 = resolved.resolveExternalSyntaxReference(referenceText, true);
        return ImmutableList.of((Object)new GradleReferenceInjection(this, element2, realExpression, referenceText));
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        return this.getResolvedVariables();
    }

    @Override
    public boolean isReference() {
        GradleDslSimpleExpression resolved = PropertyUtil.resolveElement(this.myRealExpression);
        ArtifactDependencySpecImpl spec = FakeArtifactElement.getSpec(resolved, false);
        if (spec == null) {
            return false;
        }
        String result2 = this.myGetter.apply(spec);
        return result2 != null && (WRAPPED_VARIABLE_FORM.matcher(result2).matches() || UNWRAPPED_VARIABLE_FORM.matcher(result2).matches());
    }

    @Override
    @Nullable
    public String getReferenceText() {
        GradleDslSimpleExpression resolved = PropertyUtil.resolveElement(this.myRealExpression);
        ArtifactDependencySpecImpl spec = FakeArtifactElement.getSpec(resolved, false);
        if (spec == null) {
            return null;
        }
        String result2 = this.myGetter.apply(spec);
        if (result2 == null) {
            return null;
        }
        if (result2.startsWith("${")) {
            Matcher m = WRAPPED_VARIABLE_FORM.matcher(result2);
            if (!m.matches() || m.groupCount() < 1) {
                return null;
            }
            return m.group(1);
        }
        Matcher m = UNWRAPPED_VARIABLE_FORM.matcher(result2);
        if (!m.matches() || m.groupCount() < 1) {
            return null;
        }
        return m.group(1);
    }

    @Nullable
    private static ArtifactDependencySpecImpl getSpec(@NotNull GradleDslSimpleExpression element2) {
        return FakeArtifactElement.getSpec(element2, true);
    }

    @Nullable
    private static ArtifactDependencySpecImpl getSpec(@NotNull GradleDslSimpleExpression element2, boolean useResolvedValue) {
        Object val;
        Object object = val = useResolvedValue ? element2.getValue() : element2.getUnresolvedValue();
        if (!(val instanceof String)) {
            return null;
        }
        String stringValue = (String)val;
        return ArtifactDependencySpecImpl.create(stringValue);
    }
}

