/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.repositories;

import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.api.repositories.UrlBasedRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.KtsOnlyPropertyTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.SingleArgumentMethodTransform;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoryModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class UrlBasedRepositoryModelImpl
extends RepositoryModelImpl
implements UrlBasedRepositoryModel {
    @NonNls
    public static final String URL = "url";
    @NonNls
    public static final String ARTIFACT_URLS = "artifactUrls";
    @NotNull
    private final String myDefaultRepoUrl;

    protected UrlBasedRepositoryModelImpl(@NotNull GradlePropertiesDslElement holder, @NotNull GradlePropertiesDslElement dslElement, @NotNull String defaultRepoName, @NotNull String defaultRepoUrl) {
        super(holder, dslElement, defaultRepoName);
        this.myDefaultRepoUrl = defaultRepoUrl;
    }

    @Override
    @NotNull
    public ResolvedPropertyModel url() {
        return GradlePropertyModelBuilder.create(this.myDslElement, URL).withDefault(this.myDefaultRepoUrl).addTransform(new KtsOnlyPropertyTransform(new SingleArgumentMethodTransform("uri"))).buildResolved();
    }

    @Override
    @NotNull
    public RepositoryModel.RepositoryType getType() {
        String url = this.url().forceString();
        if ("https://jcenter.bintray.com/".equals(url)) {
            return RepositoryModel.RepositoryType.JCENTER_DEFAULT;
        }
        if ("https://repo1.maven.org/maven2/".equals(url)) {
            return RepositoryModel.RepositoryType.MAVEN_CENTRAL;
        }
        if ("https://maven.google.com/".equals(url)) {
            return RepositoryModel.RepositoryType.GOOGLE_DEFAULT;
        }
        return RepositoryModel.RepositoryType.MAVEN;
    }
}

