/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext.transforms;

import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleArgumentMethodTransform
extends PropertyTransform {
    @NotNull
    private final Set<String> myRecognizedNames = new HashSet<String>();
    @NotNull
    private final String myWriteBackName;

    public SingleArgumentMethodTransform(@NotNull String methodName) {
        this.myRecognizedNames.add(methodName);
        this.myWriteBackName = methodName;
    }

    public SingleArgumentMethodTransform(@NotNull String methodName, String ... methodNames) {
        this.myRecognizedNames.addAll(Arrays.asList(methodNames));
        this.myRecognizedNames.add(methodName);
        this.myWriteBackName = methodName;
    }

    @Override
    public boolean test(@Nullable GradleDslElement e, @NotNull GradleDslElement holder) {
        if (e == null) {
            return true;
        }
        if (e instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)e;
            return this.myRecognizedNames.contains(methodCall.getMethodName()) && !methodCall.getArguments().isEmpty();
        }
        return false;
    }

    @Override
    @Nullable
    public GradleDslElement transform(@Nullable GradleDslElement e) {
        if (e == null) {
            return null;
        }
        GradleDslMethodCall methodCall = (GradleDslMethodCall)e;
        return methodCall.getArguments().get(0);
    }

    @Override
    @NotNull
    public GradleDslExpression bind(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull Object value2, @NotNull String name) {
        return PropertyUtil.createBasicExpression(holder, value2, GradleNameElement.empty());
    }

    @Override
    @NotNull
    public GradleDslExpression replace(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslExpression newElement, @NotNull String name) {
        GradleDslMethodCall methodCall;
        if (oldElement instanceof GradleDslMethodCall && this.myRecognizedNames.contains((methodCall = (GradleDslMethodCall)oldElement).getMethodName())) {
            GradleDslElement baseElement = this.transform(oldElement);
            PropertyUtil.replaceElement(methodCall, baseElement, newElement);
            return methodCall;
        }
        GradleNameElement nameElement = GradleNameElement.create(name);
        methodCall = new GradleDslMethodCall(holder, nameElement, this.myWriteBackName);
        methodCall.addNewArgument(newElement);
        PropertyUtil.replaceElement(holder, oldElement, methodCall);
        return methodCall;
    }

    @Override
    @Nullable
    public GradleDslElement delete(@NotNull GradleDslElement holder, @NotNull GradleDslElement oldElement, @NotNull GradleDslElement transformedElement) {
        PropertyUtil.removeElement(oldElement);
        return null;
    }
}

