/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext.transforms;

import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslInfixExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfixPropertyTransform
extends PropertyTransform {
    @NotNull
    String myPropertyName;

    public InfixPropertyTransform(@NotNull String propertyName) {
        this.myPropertyName = propertyName;
    }

    @Override
    public boolean test(@Nullable GradleDslElement e, @NotNull GradleDslElement holder) {
        return e instanceof GradleDslInfixExpression;
    }

    @Override
    @Nullable
    public GradleDslElement transform(@Nullable GradleDslElement e) {
        if (e == null) {
            return null;
        }
        GradleDslInfixExpression infixExpression = (GradleDslInfixExpression)e;
        return infixExpression.getPropertyElement(this.myPropertyName);
    }

    @Override
    @NotNull
    public GradleDslExpression bind(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull Object value2, @NotNull String name) {
        return PropertyUtil.createBasicExpression(holder, value2, GradleNameElement.create(this.myPropertyName));
    }

    @Override
    @NotNull
    public GradleDslElement replace(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslExpression newElement, @NotNull String name) {
        GradleDslInfixExpression infixExpression = (GradleDslInfixExpression)oldElement;
        GradleDslLiteral existing2 = (GradleDslLiteral)infixExpression.getPropertyElement(this.myPropertyName);
        if (existing2 == null) {
            infixExpression.setNewElement(newElement);
        } else {
            Object value2 = ((GradleDslLiteral)newElement).getValue();
            if (value2 != null) {
                existing2.setValue(value2);
            }
        }
        return infixExpression;
    }
}

