/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDependencySpecImpl
implements ArtifactDependencySpec {
    @NotNull
    private String name;
    @Nullable
    private String group;
    @Nullable
    private String version;
    @Nullable
    private String classifier;
    @Nullable
    private String extension;

    @Nullable
    public static ArtifactDependencySpecImpl create(@NotNull String notation) {
        List segments = Splitter.on((String)":").trimResults().omitEmptyStrings().splitToList((CharSequence)notation);
        int segmentCount = segments.size();
        if (segmentCount > 0) {
            segments = Lists.newArrayList((Iterable)segments);
            String lastSegment = (String)segments.remove(segmentCount - 1);
            String extension = null;
            int indexOfAt = lastSegment.indexOf(64);
            if (indexOfAt != -1) {
                extension = lastSegment.substring(indexOfAt + 1);
                lastSegment = lastSegment.substring(0, indexOfAt);
            }
            segments.add(lastSegment);
            segmentCount = segments.size();
            String group2 = null;
            String name = null;
            String version2 = null;
            String classifier = null;
            if (segmentCount == 2) {
                if (!lastSegment.isEmpty() && Character.isDigit(lastSegment.charAt(0))) {
                    name = (String)segments.get(0);
                    version2 = lastSegment;
                } else {
                    group2 = (String)segments.get(0);
                    name = (String)segments.get(1);
                }
            } else if (segmentCount == 3 || segmentCount == 4) {
                group2 = (String)segments.get(0);
                name = (String)segments.get(1);
                version2 = (String)segments.get(2);
                if (segmentCount == 4) {
                    classifier = (String)segments.get(3);
                }
            }
            if (StringUtil.isNotEmpty(name)) {
                return new ArtifactDependencySpecImpl(name, group2, version2, classifier, extension);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getGroup() {
        return this.group;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Override
    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    @Nullable
    public String getExtension() {
        return this.extension;
    }

    public void setName(@NotNull String newName2) {
        this.name = newName2;
    }

    public void setGroup(@Nullable String newGroup) {
        this.group = newGroup;
    }

    public void setVersion(@Nullable String newVersion) {
        this.version = newVersion;
    }

    public void setClassifier(@Nullable String newClassifier) {
        this.classifier = newClassifier;
    }

    public void setExtension(@Nullable String newExtension) {
        this.extension = newExtension;
    }

    @NotNull
    public static ArtifactDependencySpec create(@NotNull ArtifactDependencyModel dependency) {
        String name = dependency.name().toString();
        assert (name != null);
        return new ArtifactDependencySpecImpl(name, dependency.group().toString(), dependency.version().toString(), dependency.classifier().toString(), dependency.extension().toString());
    }

    public ArtifactDependencySpecImpl(@NotNull String name, @Nullable String group2, @Nullable String version2) {
        this(name, group2, version2, null, null);
    }

    public ArtifactDependencySpecImpl(@NotNull String name, @Nullable String group2, @Nullable String version2, @Nullable String classifier, @Nullable String extension) {
        this.name = name;
        this.group = Strings.emptyToNull((String)group2);
        this.version = Strings.emptyToNull((String)version2);
        this.classifier = Strings.emptyToNull((String)classifier);
        this.extension = Strings.emptyToNull((String)extension);
    }

    @Override
    public boolean equalsIgnoreVersion(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactDependencySpecImpl that = (ArtifactDependencySpecImpl)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.classifier, (Object)that.classifier) && Objects.equal((Object)this.extension, (Object)that.extension);
    }

    @Override
    public boolean equals(Object o) {
        if (this.equalsIgnoreVersion(o)) {
            ArtifactDependencySpecImpl that = (ArtifactDependencySpecImpl)o;
            return Objects.equal((Object)this.version, (Object)that.version);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.group, this.version, this.classifier, this.extension});
    }

    @Override
    public String toString() {
        return this.compactNotation();
    }

    @Override
    @NotNull
    public String compactNotation() {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{this.group, this.name, this.version, this.classifier});
        Object s = Joiner.on((String)":").skipNulls().join((Iterable)segments);
        if (this.extension != null) {
            s = (String)s + "@" + this.extension;
        }
        return s;
    }
}

