/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.api.android.ProductFlavorModel;
import com.android.tools.idea.gradle.dsl.api.android.productFlavors.ExternalNativeBuildOptionsModel;
import com.android.tools.idea.gradle.dsl.api.android.productFlavors.NdkOptionsModel;
import com.android.tools.idea.gradle.dsl.api.android.productFlavors.VectorDrawablesOptionsModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.android.FlavorTypeModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.productFlavors.ExternalNativeBuildOptionsModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.productFlavors.NdkOptionsModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.productFlavors.VectorDrawablesOptionsModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.ResolvedPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.SdkOrPreviewTransform;
import com.android.tools.idea.gradle.dsl.parser.android.AbstractProductFlavorDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.productFlavors.ExternalNativeBuildOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.productFlavors.NdkOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.productFlavors.VectorDrawablesOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyType;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.VersionConstraint;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ProductFlavorModelImpl
extends FlavorTypeModelImpl
implements ProductFlavorModel {
    @NonNls
    public static final String APPLICATION_ID = "mApplicationId";
    @NonNls
    public static final String DEFAULT = "mDefault";
    @NonNls
    public static final String DIMENSION = "mDimension";
    @NonNls
    public static final String MAX_SDK_VERSION = "mMaxSdkVersion";
    @NonNls
    public static final ModelPropertyDescription MIN_SDK_VERSION = new ModelPropertyDescription("mMinSdkVersion");
    @NonNls
    public static final String MISSING_DIMENSION_STRATEGY = "mMissingDimensionStrategy";
    @NonNls
    public static final String RENDER_SCRIPT_TARGET_API = "mRenderscriptTargetApi";
    @NonNls
    public static final String RENDER_SCRIPT_SUPPORT_MODE_ENABLED = "mRenderscriptSupportModeEnabled";
    @NonNls
    public static final String RENDER_SCRIPT_SUPPORT_MODE_BLAS_ENABLED = "mRenderscriptSupportModeBlasEnabled";
    @NonNls
    public static final String RENDER_SCRIPT_NDK_MODE_ENABLED = "mRenderscriptNdkModeEnabled";
    @NonNls
    public static final ModelPropertyDescription RES_CONFIGS = new ModelPropertyDescription("mResConfigs", ModelPropertyType.MUTABLE_SET);
    @NonNls
    public static final ModelPropertyDescription TARGET_SDK_VERSION = new ModelPropertyDescription("mTargetSdkVersion");
    @NonNls
    public static final String TEST_APPLICATION_ID = "mTestApplicationId";
    @NonNls
    public static final String TEST_FUNCTIONAL_TEST = "mTestFunctionalTest";
    @NonNls
    public static final String TEST_HANDLE_PROFILING = "mTestHandleProfiling";
    @NonNls
    public static final String TEST_INSTRUMENTATION_RUNNER = "mTestInstrumentationRunner";
    @NonNls
    public static final ModelPropertyDescription TEST_INSTRUMENTATION_RUNNER_ARGUMENTS = new ModelPropertyDescription("mTestInstrumentationRunnerArguments", ModelPropertyType.MUTABLE_MAP);
    @NonNls
    public static final String VERSION_CODE = "mVersionCode";
    @NonNls
    public static final String VERSION_NAME = "mVersionName";
    @NonNls
    public static final String WEAR_APP_UNBUNDLED = "mWearAppUnbundled";

    public ProductFlavorModelImpl(@NotNull AbstractProductFlavorDslElement dslElement) {
        super(dslElement);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel applicationId() {
        return this.getModelForProperty(APPLICATION_ID);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel isDefault() {
        return this.getModelForProperty(DEFAULT);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel dimension() {
        return this.getModelForProperty(DIMENSION);
    }

    @Override
    @NotNull
    public ExternalNativeBuildOptionsModel externalNativeBuild() {
        ExternalNativeBuildOptionsDslElement externalNativeBuildOptionsDslElement = this.myDslElement.ensurePropertyElement(ExternalNativeBuildOptionsDslElement.EXTERNAL_NATIVE_BUILD_OPTIONS);
        return new ExternalNativeBuildOptionsModelImpl(externalNativeBuildOptionsDslElement);
    }

    @Override
    public void removeExternalNativeBuild() {
        this.myDslElement.removeProperty(ExternalNativeBuildOptionsDslElement.EXTERNAL_NATIVE_BUILD_OPTIONS.name);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel maxSdkVersion() {
        return this.getModelForProperty(MAX_SDK_VERSION);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel minSdkVersion() {
        VersionConstraint agp410plus = VersionConstraint.agpFrom("4.1.0");
        return GradlePropertyModelBuilder.create(this.myDslElement, MIN_SDK_VERSION).addTransform(new SdkOrPreviewTransform(MIN_SDK_VERSION, "minSdkVersion", "minSdk", "minSdkPreview", agp410plus)).buildResolved();
    }

    @Override
    @NotNull
    public List<ResolvedPropertyModel> missingDimensionStrategies() {
        ArrayList<ResolvedPropertyModel> models = new ArrayList<ResolvedPropertyModel>();
        for (GradleDslExpressionList list2 : this.myDslElement.getPropertyElements(MISSING_DIMENSION_STRATEGY, GradleDslExpressionList.class)) {
            if (list2.getExpressions().size() <= 1) continue;
            models.add(GradlePropertyModelBuilder.create(list2).buildResolved());
        }
        return models;
    }

    @Override
    @NotNull
    public ResolvedPropertyModel addMissingDimensionStrategy(@NotNull String dimension2, Object ... fallbacks) {
        GradleDslExpressionList list2 = new GradleDslExpressionList((GradleDslElement)this.myDslElement, GradleNameElement.create("missingDimensionStrategy"), false);
        this.myDslElement.setNewElement(list2);
        list2.setElementType(PropertyType.REGULAR);
        list2.setModelEffect(new ModelEffectDescription(new ModelPropertyDescription(MISSING_DIMENSION_STRATEGY), MethodSemanticsDescription.OTHER));
        ResolvedPropertyModelImpl model2 = GradlePropertyModelBuilder.create(list2).buildResolved();
        model2.addListValue().setValue(dimension2);
        for (Object fallback : fallbacks) {
            model2.addListValue().setValue(fallback);
        }
        return model2;
    }

    @Override
    public boolean areMissingDimensionStrategiesModified() {
        List originalElements = this.myDslElement.getOriginalElements().stream().filter(e -> e.getName().equals(MISSING_DIMENSION_STRATEGY)).collect(Collectors.toList());
        List<GradleDslElement> currentElements = this.myDslElement.getPropertyElementsByName(MISSING_DIMENSION_STRATEGY);
        if (originalElements.size() != currentElements.size()) {
            return true;
        }
        for (GradleDslElement oldElement : originalElements) {
            boolean modified = true;
            for (GradleDslElement newElement : currentElements) {
                modified &= PropertyUtil.isElementModified(oldElement, newElement);
            }
            if (!modified) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public NdkOptionsModel ndk() {
        NdkOptionsDslElement ndkOptionsDslElement = this.myDslElement.ensurePropertyElement(NdkOptionsDslElement.NDK_OPTIONS);
        return new NdkOptionsModelImpl(ndkOptionsDslElement);
    }

    @Override
    public void removeNdk() {
        this.myDslElement.removeProperty(NdkOptionsDslElement.NDK_OPTIONS.name);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel resConfigs() {
        return this.getModelForProperty(RES_CONFIGS);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel renderscriptTargetApi() {
        return this.getModelForProperty(RENDER_SCRIPT_TARGET_API);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel renderscriptSupportModeEnabled() {
        return this.getModelForProperty(RENDER_SCRIPT_SUPPORT_MODE_ENABLED);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel renderscriptSupportModelBlasEnabled() {
        return this.getModelForProperty(RENDER_SCRIPT_SUPPORT_MODE_BLAS_ENABLED);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel renderscriptNdkModeEnabled() {
        return this.getModelForProperty(RENDER_SCRIPT_NDK_MODE_ENABLED);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel targetSdkVersion() {
        VersionConstraint agp410plus = VersionConstraint.agpFrom("4.1.0");
        return GradlePropertyModelBuilder.create(this.myDslElement, TARGET_SDK_VERSION).addTransform(new SdkOrPreviewTransform(TARGET_SDK_VERSION, "targetSdkVersion", "targetSdk", "targetSdkPreview", agp410plus)).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel testApplicationId() {
        return this.getModelForProperty(TEST_APPLICATION_ID);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel testFunctionalTest() {
        return this.getModelForProperty(TEST_FUNCTIONAL_TEST);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel testHandleProfiling() {
        return this.getModelForProperty(TEST_HANDLE_PROFILING);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel testInstrumentationRunner() {
        return this.getModelForProperty(TEST_INSTRUMENTATION_RUNNER);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel testInstrumentationRunnerArguments() {
        GradleDslExpressionMap testInstrumentationRunnerArguments2 = this.myDslElement.getPropertyElement(GradleDslExpressionMap.TEST_INSTRUMENTATION_RUNNER_ARGUMENTS);
        if (testInstrumentationRunnerArguments2 == null) {
            testInstrumentationRunnerArguments2 = new GradleDslExpressionMap(this.myDslElement, GradleNameElement.fake(ProductFlavorModelImpl.TEST_INSTRUMENTATION_RUNNER_ARGUMENTS.name));
            ModelEffectDescription effect = new ModelEffectDescription(TEST_INSTRUMENTATION_RUNNER_ARGUMENTS, ModelSemanticsDescription.CREATE_WITH_VALUE);
            testInstrumentationRunnerArguments2.setModelEffect(effect);
            testInstrumentationRunnerArguments2.setElementType(PropertyType.REGULAR);
            this.myDslElement.addDefaultProperty(testInstrumentationRunnerArguments2);
        }
        return this.getModelForProperty(TEST_INSTRUMENTATION_RUNNER_ARGUMENTS);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel versionCode() {
        return this.getModelForProperty(VERSION_CODE);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel versionName() {
        return this.getModelForProperty(VERSION_NAME);
    }

    @Override
    @NotNull
    public VectorDrawablesOptionsModel vectorDrawables() {
        VectorDrawablesOptionsDslElement vectorDrawableElement = this.myDslElement.ensurePropertyElement(VectorDrawablesOptionsDslElement.VECTOR_DRAWABLES_OPTIONS);
        return new VectorDrawablesOptionsModelImpl(vectorDrawableElement);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel wearAppUnbundled() {
        return this.getModelForProperty(WEAR_APP_UNBUNDLED);
    }
}

