/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.api.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.util.GradleDslElementModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReferenceTo {
    private static final Logger LOG = Logger.getInstance(ReferenceTo.class);
    @NotNull
    private final String fullyQualifiedName;
    @NotNull
    private final GradleDslElementModel elementModel;
    @NotNull
    private final GradleDslElement scope;

    public ReferenceTo(@NotNull GradleDslElementModel model2) {
        this(model2, model2);
    }

    public ReferenceTo(@NotNull GradleDslElementModel model2, @NotNull GradleDslElementModel context2) {
        this.elementModel = model2;
        this.scope = context2.getRawPropertyHolder();
        if (model2.getRawElement() != null) {
            this.fullyQualifiedName = model2.getFullyQualifiedName();
        } else {
            LOG.warn((Throwable)new IllegalArgumentException("Invalid model property: please check the property exists."));
            this.fullyQualifiedName = "invalid.model.in.ReferenceTo";
        }
    }

    @Nullable
    public static ReferenceTo createReferenceFromText(@NotNull String referredElementName, @NotNull GradlePropertyModel propertyContext2) {
        GradlePropertyModel referenceModel = GradlePropertyModelBuilder.getModelFromExternalText(referredElementName, propertyContext2.getHolder());
        if (referenceModel == null) {
            return null;
        }
        return new ReferenceTo(referenceModel, propertyContext2);
    }

    @NotNull
    public GradleDslElement getReferredElement() {
        return this.elementModel.getRawElement();
    }

    @NotNull
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceTo text2 = (ReferenceTo)o;
        return com.google.common.base.Objects.equal((Object)this.fullyQualifiedName, (Object)text2.fullyQualifiedName);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.fullyQualifiedName});
    }

    @NotNull
    public String toString() {
        List<String> scopeNameParts = GradleNameElement.split(this.scope.getQualifiedName());
        List<String> resultParts = GradleNameElement.split(this.elementModel.getFullyQualifiedName());
        int r = 0;
        int s = 0;
        if ("buildscript".equals(scopeNameParts.get(s))) {
            ++s;
        }
        if ("buildscript".equals(resultParts.get(r))) {
            ++r;
        }
        if ("ext".equals(scopeNameParts.get(s))) {
            ++s;
        }
        if ("ext".equals(resultParts.get(r))) {
            ++r;
        }
        if (r >= resultParts.size()) {
            return GradleNameElement.join(resultParts);
        }
        while (r < resultParts.size() && s < scopeNameParts.size() && Objects.equals(resultParts.get(r), scopeNameParts.get(s))) {
            ++r;
            ++s;
        }
        return GradleNameElement.join(resultParts.subList(r, resultParts.size()));
    }
}

