/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.api.ext;

import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InterpolatedText {
    @NotNull
    private List<InterpolatedTextItem> myInterpolatedTextItems;

    public InterpolatedText(List<InterpolatedTextItem> interpolations) {
        this.myInterpolatedTextItems = new ArrayList<InterpolatedTextItem>(interpolations);
    }

    @NotNull
    public String toString() {
        StringBuilder expressionBuilder = new StringBuilder();
        for (InterpolatedTextItem interpolatedTextItem : this.myInterpolatedTextItems) {
            expressionBuilder.append(interpolatedTextItem.toString());
        }
        return expressionBuilder.toString();
    }

    @NotNull
    public List<InterpolatedTextItem> getInterpolationElements() {
        return ImmutableList.copyOf(this.myInterpolatedTextItems);
    }

    public static final class InterpolatedTextItem {
        private String textItem;
        private ReferenceTo referenceItem;

        public InterpolatedTextItem(String textItem) {
            this.textItem = textItem;
            this.referenceItem = null;
        }

        public InterpolatedTextItem(ReferenceTo referenceItem) {
            this.textItem = null;
            this.referenceItem = referenceItem;
        }

        @Nullable
        public String getTextItem() {
            return this.textItem;
        }

        @Nullable
        public ReferenceTo getReferenceItem() {
            return this.referenceItem;
        }

        @NotNull
        public String toString() {
            Object representation = "";
            if (this.textItem != null) {
                representation = (String)representation + this.textItem;
            }
            if (this.referenceItem != null) {
                representation = (String)representation + "${" + this.referenceItem.toString() + "}";
            }
            return representation;
        }
    }
}

