/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.api;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleModelProvider;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogsModel;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProjectBuildModel {
    @NotNull
    public static ProjectBuildModel get(@NotNull Project project) {
        return GradleModelProvider.getInstance().getProjectModel(project);
    }

    @Nullable
    public static ProjectBuildModel getForCompositeBuild(@NotNull Project hostProject, @NotNull String includedBuildRoot) {
        return GradleModelProvider.getInstance().getProjectModel(hostProject, includedBuildRoot);
    }

    @Nullable
    public static ProjectBuildModel getOrLog(@NotNull Project project) {
        return GradleBuildModel.tryOrLog(() -> ProjectBuildModel.get(project));
    }

    @NotNull
    public BuildModelContext getContext();

    @Nullable
    public GradleBuildModel getProjectBuildModel();

    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull Module var1);

    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull File var1);

    @NotNull
    public GradleBuildModel getModuleBuildModel(@NotNull VirtualFile var1);

    @Nullable
    public GradleSettingsModel getProjectSettingsModel();

    @NotNull
    public GradleVersionCatalogsModel getVersionCatalogsModel();

    public void applyChanges();

    public void resetState();

    public void reparse();

    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels();

    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels(@NotNull @NotNull BiConsumer<@NotNull Integer, @Nullable Integer> var1);
}

