/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependencies;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dependencies.ConfigurationNameMapper;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Objects;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GradleDependencyManager {
    private static final String ADD_DEPENDENCY = "Add Dependency";

    @NotNull
    public static GradleDependencyManager getInstance(@NotNull Project project) {
        return (GradleDependencyManager)project.getService(GradleDependencyManager.class);
    }

    @NotNull
    public List<GradleCoordinate> findMissingDependencies(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2) {
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module2);
        GradleBuildModel buildModel = GradleBuildModel.get(module2);
        if (gradleModel == null && buildModel == null) {
            return Collections.emptyList();
        }
        List<ArtifactDependencyModel> compileDependencies = buildModel != null ? buildModel.dependencies().artifacts() : null;
        GradleVersion appCompatVersion = null;
        if (compileDependencies != null) {
            for (ArtifactDependencyModel dependency : compileDependencies) {
                if (!Objects.equal((Object)"com.android.support", (Object)dependency.group().toString()) || Objects.equal((Object)"multidex", (Object)dependency.name().forceString())) continue;
                String s = dependency.version().toString();
                if (s == null) break;
                appCompatVersion = GradleVersion.tryParse((String)s);
                break;
            }
        }
        Project project = module2.getProject();
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        ArrayList<GradleCoordinate> missingLibraries = new ArrayList<GradleCoordinate>();
        for (GradleCoordinate coordinate : dependencies2) {
            boolean dependencyFound;
            String groupId = coordinate.getGroupId();
            String artifactId = coordinate.getArtifactId();
            if (artifactId == null || groupId == null) continue;
            GradleCoordinate resolvedCoordinate = manager.resolveDynamicCoordinate(coordinate, project, null);
            if (appCompatVersion != null && coordinate.acceptsGreaterRevisions() && "com.android.support".equals(groupId) && !artifactId.equals("multidex")) {
                resolvedCoordinate = GradleCoordinate.parseCoordinateString((String)(groupId + ":" + artifactId + ":" + appCompatVersion.toString()));
            }
            if (resolvedCoordinate != null) {
                coordinate = resolvedCoordinate;
            }
            if (dependencyFound = compileDependencies != null && compileDependencies.stream().anyMatch(d -> Objects.equal((Object)d.group().toString(), (Object)groupId) && d.name().forceString().equals(artifactId))) continue;
            missingLibraries.add(coordinate);
        }
        return missingLibraries;
    }

    @TestOnly
    public boolean addDependenciesAndSync(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2) {
        boolean result2 = this.addDependenciesInTransaction(module2, dependencies2, null);
        GradleDependencyManager.requestProjectSync(module2.getProject(), GradleSyncStats.Trigger.TRIGGER_GRADLEDEPENDENCY_ADDED);
        return result2;
    }

    public boolean addDependenciesWithoutSync(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2) {
        return this.addDependenciesInTransaction(module2, dependencies2, null);
    }

    public boolean addDependenciesWithoutSync(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2, @Nullable ConfigurationNameMapper nameMapper) {
        return this.addDependenciesInTransaction(module2, dependencies2, nameMapper);
    }

    public boolean updateLibrariesToVersion(@NotNull Module module2, @NotNull List<GradleCoordinate> dependencies2) {
        GradleBuildModel buildModel = GradleBuildModel.get(module2);
        if (buildModel == null) {
            return false;
        }
        GradleDependencyManager.updateDependenciesInTransaction(buildModel, module2, dependencies2);
        return true;
    }

    private boolean addDependenciesInTransaction(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> coordinates, @Nullable ConfigurationNameMapper nameMapper) {
        GradleBuildModel buildModel = GradleBuildModel.get(module2);
        if (buildModel == null) {
            return false;
        }
        Project project = module2.getProject();
        WriteCommandAction.writeCommandAction((Project)project).withName(ADD_DEPENDENCY).run(() -> {
            List<GradleCoordinate> missing = this.findMissingDependencies(module2, coordinates);
            if (missing.isEmpty()) {
                return;
            }
            GradleDependencyManager.addDependencies(buildModel, module2, missing, nameMapper);
        });
        return true;
    }

    private static void addDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module2, @NotNull List<GradleCoordinate> coordinates, @Nullable ConfigurationNameMapper nameMapper) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate coordinate : coordinates) {
                String name = "compile";
                if (nameMapper != null) {
                    name = nameMapper.mapName(module2, name, coordinate);
                }
                name = GradleUtil.mapConfigurationName(name, GradleProjectSystemUtil.getAndroidGradleModelVersionInUse(module2), false);
                dependenciesModel.addArtifact(name, coordinate.toString());
            }
            buildModel.applyChanges();
        });
    }

    private static void updateDependenciesInTransaction(@NotNull GradleBuildModel buildModel, @NotNull Module module2, @NotNull List<GradleCoordinate> coordinates) {
        assert (!coordinates.isEmpty());
        Project project = module2.getProject();
        WriteCommandAction.writeCommandAction((Project)project).withName(ADD_DEPENDENCY).run(() -> GradleDependencyManager.updateDependencies(buildModel, module2, coordinates));
    }

    private static void requestProjectSync(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger) {
        GradleSyncInvoker.Request request2 = new GradleSyncInvoker.Request(trigger);
        GradleSyncInvoker.getInstance().requestProjectSync(project, request2, null);
    }

    private static void updateDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module2, @NotNull List<GradleCoordinate> coordinates) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate gc : coordinates) {
                ArrayList<ArtifactDependencyModel> artifacts = new ArrayList<ArtifactDependencyModel>(dependenciesModel.artifacts());
                for (ArtifactDependencyModel m : artifacts) {
                    if (gc.getGroupId() == null || !gc.getGroupId().equals(m.group().toString()) || gc.getArtifactId() == null || !gc.getArtifactId().equals(m.name().forceString()) || gc.getRevision().equals(m.version().toString())) continue;
                    dependenciesModel.remove(m);
                    dependenciesModel.addArtifact(m.configurationName(), gc.toString());
                }
            }
            buildModel.applyChanges();
        });
    }
}

