/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.adtimport;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.adtimport.GradleImport;
import com.android.tools.idea.gradle.adtimport.ImportSummary;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public abstract class ImportModule
implements Comparable<ImportModule> {
    private static final String SHERLOCK_DEP = "com.actionbarsherlock:actionbarsherlock:4.4.0@aar";
    private static final String PLAY_SERVICES_DEP = "com.google.android.gms:play-services:+";
    protected final GradleImport myImporter;
    protected final List<GradleCoordinate> myDependencies = new ArrayList<GradleCoordinate>();
    protected final List<GradleCoordinate> myTestDependencies = new ArrayList<GradleCoordinate>();
    protected final List<File> myJarDependencies = new ArrayList<File>();
    protected final List<File> myTestJarDependencies = new ArrayList<File>();
    protected List<GradleCoordinate> myReplaceWithDependencies;
    private String myModuleName;

    public ImportModule(GradleImport importer) {
        this.myImporter = importer;
    }

    protected static File getTestJarOutputRelativePath(File jar) {
        return new File("libs", jar.getName());
    }

    private static void recordCopiedFile(Set<File> copied, File file2) throws IOException {
        copied.add(file2);
        copied.add(file2.getCanonicalFile());
    }

    protected abstract boolean isLibrary();

    protected abstract boolean isApp();

    protected abstract boolean isAndroidLibrary();

    protected abstract boolean isAndroidProject();

    protected abstract boolean isJavaLibrary();

    protected abstract boolean isNdkProject();

    protected abstract AndroidVersion getCompileSdkVersion();

    protected abstract AndroidVersion getMinSdkVersion();

    protected abstract AndroidVersion getTargetSdkVersion();

    protected abstract String getAddOn();

    public abstract File getDir();

    protected abstract String getOriginalName();

    protected abstract List<File> getSourcePaths();

    protected abstract List<File> getJarPaths();

    protected abstract List<File> getTestJarPaths();

    protected abstract List<File> getNativeLibs();

    protected abstract File resolveFile(File var1);

    protected abstract File getCanonicalModuleDir();

    protected abstract List<File> getLocalProguardFiles();

    protected abstract List<File> getSdkProguardFiles();

    protected abstract String getLanguageLevel();

    protected abstract List<ImportModule> getDirectDependencies();

    protected abstract List<ImportModule> getAllDependencies();

    protected abstract String getPackage();

    protected abstract File getLintXml();

    protected abstract File getOutputDir();

    protected abstract File getManifestFile();

    protected abstract File getResourceDir();

    protected abstract File getAssetsDir();

    protected abstract File getNativeSources();

    protected abstract String getNativeModuleName();

    protected abstract File getInstrumentationDir();

    protected abstract Charset getFileEncoding(File var1);

    protected abstract Charset getProjectEncoding(File var1);

    public void initialize() {
        this.initDependencies();
        this.initReplaceWithDependency();
    }

    protected void initDependencies() {
    }

    public GradleCoordinate getLatestVersion(String artifact2) {
        int compileVersion = 33;
        AndroidVersion version2 = this.getCompileSdkVersion();
        if (version2 != AndroidVersion.DEFAULT) {
            compileVersion = version2.getFeatureLevel();
        }
        if (compileVersion < 18) {
            compileVersion = 18;
        }
        int requiredVersion = compileVersion;
        String max = RepositoryUrlManager.get().getLibraryRevision("com.android.support", artifact2, v -> v.getMajor() == requiredVersion, true, FileSystems.getDefault());
        if (max != null) {
            return GradleCoordinate.parseCoordinateString((String)("com.android.support:" + artifact2 + ":" + max));
        }
        String coordinate = "com.android.support:" + artifact2 + ":" + compileVersion + ".+";
        return GradleCoordinate.parseCoordinateString((String)coordinate);
    }

    protected GradleCoordinate getAppCompatDependency() {
        return this.getLatestVersion("appcompat-v7");
    }

    protected GradleCoordinate getSupportLibDependency() {
        return this.getLatestVersion("support-v4");
    }

    protected GradleCoordinate getGridLayoutDependency() {
        return this.getLatestVersion("gridlayout-v7");
    }

    protected GradleCoordinate getMediaRouterDependency() {
        return this.getLatestVersion("mediarouter-v7");
    }

    GradleCoordinate guessDependency(File jar) {
        String name = StringUtil.toLowerCase((String)jar.getName());
        if (name.equals("android-support-v4.jar")) {
            this.myImporter.markJarHandled(jar);
            return this.getSupportLibDependency();
        }
        if (name.equals("android-support-v7-gridlayout.jar")) {
            this.myImporter.markJarHandled(jar);
            return this.getGridLayoutDependency();
        }
        if (name.equals("android-support-v7-appcompat.jar")) {
            this.myImporter.markJarHandled(jar);
            return this.getAppCompatDependency();
        }
        if (name.equals("com_actionbarsherlock.jar") || name.equalsIgnoreCase("actionbarsherlock.jar")) {
            this.myImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)SHERLOCK_DEP);
        }
        if (name.equals("guava.jar") || name.startsWith("guava-")) {
            this.myImporter.markJarHandled(jar);
            String version2 = this.getVersion(jar, "guava-", name, "18.0");
            if (version2.startsWith("r")) {
                version2 = "15.0";
            }
            return GradleCoordinate.parseCoordinateString((String)("com.google.guava:guava:" + version2));
        }
        if (name.startsWith("joda-time")) {
            this.myImporter.markJarHandled(jar);
            String version3 = this.getVersion(jar, "joda-time-", name, "2.7");
            return GradleCoordinate.parseCoordinateString((String)("joda-time:joda-time:" + version3));
        }
        if (name.startsWith("robotium-solo-")) {
            this.myImporter.markJarHandled(jar);
            String version4 = this.getVersion(jar, "robotium-solo-", name, "5.3.1");
            return GradleCoordinate.parseCoordinateString((String)("com.jayway.android.robotium:robotium-solo:" + version4));
        }
        if (name.startsWith("protobuf-java-")) {
            this.myImporter.markJarHandled(jar);
            String version5 = this.getVersion(jar, "protobuf-java-", name, "2.6.1");
            return GradleCoordinate.parseCoordinateString((String)("com.google.protobuf:protobuf-java:" + version5));
        }
        if (name.startsWith("gson-")) {
            this.myImporter.markJarHandled(jar);
            String version6 = this.getVersion(jar, "gson-", name, "2.3.1");
            return GradleCoordinate.parseCoordinateString((String)("com.google.code.gson:gson:" + version6));
        }
        if (name.startsWith("google-http-client-gson-")) {
            this.myImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)"com.google.http-client:google-http-client-gson:1.20.0");
        }
        if (name.startsWith("svg-android")) {
            this.myImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)"com.github.japgolly.android:svg-android:2.0.6");
        }
        if (name.equals("gcm.jar")) {
            this.myImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)PLAY_SERVICES_DEP);
        }
        return null;
    }

    private String getVersion(File jar, String prefix, String jarName, String defaultVersion) {
        if (jarName.matches(prefix + "([\\d\\.]+)\\.jar")) {
            String version2 = jarName.substring(prefix.length(), jarName.length() - 4);
            if (!defaultVersion.equals(version2)) {
                this.myImporter.getSummary().reportGuessedVersion(jar);
            }
            return version2;
        }
        return defaultVersion;
    }

    private void initReplaceWithDependency() {
        String pkg;
        if (this.isLibrary() && this.myImporter.isReplaceLibs() && (pkg = this.getPackage()) != null) {
            if (pkg.equals("com.actionbarsherlock")) {
                this.myReplaceWithDependencies = Arrays.asList(GradleCoordinate.parseCoordinateString((String)SHERLOCK_DEP), this.getSupportLibDependency());
            } else if (pkg.equals("android.support.v7.gridlayout")) {
                this.myReplaceWithDependencies = Collections.singletonList(this.getGridLayoutDependency());
            } else if (pkg.equals("com.google.android.gms")) {
                this.myReplaceWithDependencies = Collections.singletonList(GradleCoordinate.parseCoordinateString((String)PLAY_SERVICES_DEP));
            } else if (pkg.equals("android.support.v7.appcompat")) {
                this.myReplaceWithDependencies = Collections.singletonList(this.getAppCompatDependency());
            } else if (pkg.equals("android.support.v7.mediarouter")) {
                this.myReplaceWithDependencies = Collections.singletonList(this.getMediaRouterDependency());
            }
            if (this.myReplaceWithDependencies != null) {
                this.myImporter.getSummary().reportReplacedLib(this.getOriginalName(), this.myReplaceWithDependencies);
            }
        }
    }

    public boolean isReplacedWithDependency() {
        return this.myReplaceWithDependencies != null && !this.myReplaceWithDependencies.isEmpty();
    }

    public List<GradleCoordinate> getReplaceWithDependencies() {
        return this.myReplaceWithDependencies;
    }

    public String getModuleName() {
        if (this.myModuleName == null) {
            if (this.myImporter.isGradleNameStyle() && !this.myImporter.isImportIntoExisting() && this.myImporter.getModuleCount() == 1) {
                this.myModuleName = "app";
                return this.myModuleName;
            }
            String string = this.getOriginalName();
            StringBuilder sb = new StringBuilder(string.length());
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) continue;
                sb.append(c);
            }
            Object moduleName2 = sb.toString();
            if (!((String)moduleName2).isEmpty() && !Character.isJavaIdentifierStart(((String)moduleName2).charAt(0))) {
                moduleName2 = "_" + (String)moduleName2;
            }
            if (this.myImporter.isGradleNameStyle() && !((String)moduleName2).isEmpty()) {
                moduleName2 = Character.toLowerCase(((String)moduleName2).charAt(0)) + ((String)moduleName2).substring(1);
            }
            this.myModuleName = moduleName2;
        }
        return this.myModuleName;
    }

    public void setModuleName(String name) {
        this.myModuleName = name;
    }

    public void pickUniqueName(File projectDir) {
        String name;
        int length;
        assert (projectDir.exists()) : projectDir;
        String preferredName = this.getModuleName();
        int lastDigit = length = preferredName.length();
        int i = length - 1;
        while (i >= 1 && Character.isDigit(preferredName.charAt(i))) {
            lastDigit = i--;
        }
        int startingNumber = 2;
        if (lastDigit < length) {
            startingNumber = Integer.parseInt(preferredName.substring(lastDigit)) + 1;
            preferredName = preferredName.substring(0, lastDigit);
        }
        int i2 = startingNumber;
        while (true) {
            if (!new File(projectDir, name = preferredName + i2).exists()) break;
            ++i2;
        }
        this.myModuleName = name;
    }

    public String getModuleReference() {
        String moduleName2 = this.getModuleName();
        StringBuilder builder2 = new StringBuilder(moduleName2.length() + 1);
        for (File file2 = new File(moduleName2); file2 != null; file2 = file2.getParentFile()) {
            builder2.insert(0, file2.getName());
            builder2.insert(0, ':');
        }
        return builder2.toString();
    }

    protected File getJarOutputRelativePath(File jar) {
        if (jar.isAbsolute()) {
            File relative;
            try {
                relative = GradleImport.computeRelativePath(this.getCanonicalModuleDir(), jar);
            }
            catch (IOException ioe) {
                relative = null;
            }
            jar = relative != null ? relative : new File("libs", jar.getName());
        }
        return jar;
    }

    public void copyInto(File destDir) throws IOException {
        File instrumentation;
        ImportSummary summary = this.myImporter.getSummary();
        HashSet copied = Sets.newHashSet();
        final File main = new File(destDir, "src" + File.separator + "main");
        this.myImporter.mkdirs(main);
        if (this.isAndroidProject()) {
            File lintXml;
            File srcAssets;
            File srcRes;
            File srcManifest = this.getManifestFile();
            if (srcManifest != null && srcManifest.exists()) {
                File destManifest = new File(main, "AndroidManifest.xml");
                this.myImporter.copyTextFile(this, srcManifest, destManifest);
                summary.reportMoved(this, srcManifest, destManifest);
                ImportModule.recordCopiedFile(copied, srcManifest);
            }
            if ((srcRes = this.getResourceDir()) != null && srcRes.exists()) {
                File destRes = new File(main, "res");
                this.myImporter.mkdirs(destRes);
                this.myImporter.copyDir(srcRes, destRes, new GradleImport.CopyHandler(){

                    @Override
                    public boolean handle(File source, File dest, boolean updateEncoding, ImportModule sourceModule) throws IOException {
                        Object name;
                        int dot;
                        ResourceFolderType folderType;
                        File parentFile;
                        if (ImportModule.hasUpperCaseExtension(dest) && !GradleImport.isIgnoredFile(source) && (parentFile = source.getParentFile()) != null && (folderType = ResourceFolderType.getFolderType((String)parentFile.getName())) != ResourceFolderType.VALUES && (dot = ((String)(name = dest.getName())).indexOf(46)) != -1) {
                            name = ((String)name).substring(0, dot) + StringUtil.toLowerCase((String)((String)name).substring(dot));
                            File destParent = dest.getParentFile();
                            File file2 = dest = destParent != null ? new File(destParent, (String)name) : new File((String)name);
                            if (updateEncoding && GradleImport.isTextFile(source)) {
                                ImportModule.this.myImporter.copyTextFile(sourceModule, source, dest);
                            } else {
                                Files.copy((File)source, (File)dest);
                            }
                            if (sourceModule != null) {
                                ImportModule.this.myImporter.getSummary().reportMoved(sourceModule, new File(source.getName()), new File((String)name));
                            }
                            return true;
                        }
                        return false;
                    }
                }, true, this);
                summary.reportMoved(this, srcRes, destRes);
                ImportModule.recordCopiedFile(copied, srcRes);
            }
            if ((srcAssets = this.getAssetsDir()) != null && srcAssets.exists()) {
                File destAssets = new File(main, "assets");
                this.myImporter.mkdirs(destAssets);
                this.myImporter.copyDir(srcAssets, destAssets, null, false, null);
                summary.reportMoved(this, srcAssets, destAssets);
                ImportModule.recordCopiedFile(copied, srcAssets);
            }
            if ((lintXml = this.getLintXml()) != null) {
                File destLintXml = new File(destDir, lintXml.getName());
                this.myImporter.copyTextFile(this, lintXml, destLintXml);
                summary.reportMoved(this, lintXml, destLintXml);
                ImportModule.recordCopiedFile(copied, lintXml);
            }
        }
        for (File src : this.getSourcePaths()) {
            final File srcJava = this.resolveFile(src);
            File destJava = new File(main, "java");
            if (srcJava.isDirectory()) {
                this.myImporter.mkdirs(destJava);
            } else {
                destJava = new File(main, srcJava.getName());
            }
            this.myImporter.copyDir(srcJava, destJava, new GradleImport.CopyHandler(){

                @Override
                public boolean handle(File source, File dest, boolean updateEncoding, ImportModule sourceModule) throws IOException {
                    String sourcePath = source.getPath();
                    if (sourcePath.endsWith(".aidl")) {
                        File aidlDir = new File(main, "aidl");
                        File relative = GradleImport.computeRelativePath(srcJava, source);
                        if (relative == null) {
                            relative = GradleImport.computeRelativePath(srcJava.getCanonicalFile(), source);
                        }
                        if (relative != null) {
                            File destAidl = new File(aidlDir, relative.getPath());
                            ImportModule.this.myImporter.mkdirs(destAidl.getParentFile());
                            ImportModule.this.myImporter.copyTextFile(ImportModule.this, source, destAidl);
                            ImportModule.this.myImporter.getSummary().reportMoved(ImportModule.this, source, destAidl);
                            return true;
                        }
                    } else {
                        if (sourcePath.endsWith(".rs") || sourcePath.endsWith(".rsh") || sourcePath.endsWith(".fs")) {
                            File destRs = new File(main, "rs" + File.separator + source.getName());
                            ImportModule.this.myImporter.mkdirs(destRs.getParentFile());
                            ImportModule.this.myImporter.copyTextFile(ImportModule.this, source, destRs);
                            ImportModule.this.myImporter.getSummary().reportMoved(ImportModule.this, source, destRs);
                            return true;
                        }
                        if (!(sourcePath.endsWith(".java") || sourcePath.endsWith(".class") || sourcePath.endsWith(".jar") || sourcePath.equals("package.html") || sourcePath.equals("overview.html") || !source.isFile())) {
                            File resourceDir = new File(main, "resources");
                            File relative = GradleImport.computeRelativePath(srcJava, source);
                            if (relative == null) {
                                relative = GradleImport.computeRelativePath(srcJava.getCanonicalFile(), source);
                            }
                            if (relative != null) {
                                File destResource = new File(resourceDir, relative.getPath());
                                ImportModule.this.myImporter.mkdirs(destResource.getParentFile());
                                Files.copy((File)source, (File)destResource);
                                ImportModule.this.myImporter.getSummary().reportMoved(ImportModule.this, source, destResource);
                                return true;
                            }
                        }
                    }
                    return false;
                }
            }, true, this);
            summary.reportMoved(this, srcJava, destJava);
            ImportModule.recordCopiedFile(copied, srcJava);
        }
        for (File jar : this.getJarPaths()) {
            File srcJar = this.resolveFile(jar);
            File destJar = new File(destDir, this.getJarOutputRelativePath(jar).getPath());
            if (destJar.getParentFile() != null) {
                this.myImporter.mkdirs(destJar.getParentFile());
            }
            Files.copy((File)srcJar, (File)destJar);
            summary.reportMoved(this, srcJar, destJar);
            ImportModule.recordCopiedFile(copied, srcJar);
        }
        for (File lib : this.getNativeLibs()) {
            File srcLib = this.resolveFile(lib);
            String abi = lib.getParentFile().getName();
            File destLib = new File(destDir, "src" + File.separator + "main" + File.separator + "jniLibs" + File.separator + abi + File.separator + lib.getName());
            if (destLib.getParentFile() != null) {
                this.myImporter.mkdirs(destLib.getParentFile());
            }
            Files.copy((File)srcLib, (File)destLib);
            summary.reportMoved(this, srcLib, destLib);
            ImportModule.recordCopiedFile(copied, srcLib);
        }
        File jni = this.getNativeSources();
        if (jni != null) {
            File srcJni = this.resolveFile(jni);
            File destJni = new File(destDir, "src" + File.separator + "main" + File.separator + "jni");
            this.myImporter.copyDir(srcJni, destJni, null, true, this);
            summary.reportMoved(this, srcJni, destJni);
            ImportModule.recordCopiedFile(copied, srcJni);
        }
        if ((instrumentation = this.getInstrumentationDir()) != null) {
            File srcJava;
            File test = new File(destDir, "src" + File.separator + "androidTest");
            this.myImporter.mkdirs(test);
            ImportModule.recordCopiedFile(copied, new File(instrumentation, "AndroidManifest.xml"));
            File srcRes = new File(instrumentation, "res");
            if (srcRes.isDirectory()) {
                File destRes = new File(test, "res");
                this.myImporter.mkdirs(destRes);
                this.myImporter.copyDir(srcRes, destRes, null, true, this);
                summary.reportMoved(this, srcRes, destRes);
                ImportModule.recordCopiedFile(copied, srcRes);
            }
            if ((srcJava = new File(instrumentation, "src")).isDirectory()) {
                File destRes = new File(test, "java");
                this.myImporter.mkdirs(destRes);
                this.myImporter.copyDir(srcJava, destRes, null, true, this);
                summary.reportMoved(this, srcJava, destRes);
                ImportModule.recordCopiedFile(copied, srcJava);
            }
            for (File jar : this.getTestJarPaths()) {
                File srcJar = this.resolveFile(jar);
                File destJar = new File(destDir, ImportModule.getTestJarOutputRelativePath(jar).getPath());
                if (destJar.exists()) continue;
                if (destJar.getParentFile() != null) {
                    this.myImporter.mkdirs(destJar.getParentFile());
                }
                Files.copy((File)srcJar, (File)destJar);
                summary.reportMoved(this, srcJar, destJar);
                ImportModule.recordCopiedFile(copied, srcJar);
            }
        }
        if (this.isAndroidProject()) {
            for (File srcProguard : this.getLocalProguardFiles()) {
                File destProguard = new File(destDir, srcProguard.getName());
                if (!destProguard.exists()) {
                    this.myImporter.copyTextFile(this, srcProguard, destProguard);
                    summary.reportMoved(this, srcProguard, destProguard);
                    ImportModule.recordCopiedFile(copied, srcProguard);
                    continue;
                }
                this.myImporter.reportWarning(this, destProguard, "Local proguard config file name is not unique");
            }
        }
        this.reportIgnored(copied);
    }

    private static boolean hasUpperCaseExtension(File file2) {
        String path2 = file2.getPath();
        int index2 = path2.lastIndexOf(File.separatorChar);
        if ((index2 = path2.indexOf(46, index2 + 1)) == -1) {
            return false;
        }
        ++index2;
        while (index2 < path2.length()) {
            if (Character.isUpperCase(path2.charAt(index2))) {
                return true;
            }
            ++index2;
        }
        return false;
    }

    private void reportIgnored(Set<File> copied) throws IOException {
        File canonicalDir = this.getCanonicalModuleDir();
        File outputDir = this.getOutputDir();
        if (outputDir != null) {
            copied.add(this.resolveFile(outputDir).getCanonicalFile());
        }
        copied.add(new File(canonicalDir, "bin"));
        copied.add(new File(canonicalDir, "gen"));
        copied.add(new File(canonicalDir, ".classpath"));
        copied.add(new File(canonicalDir, ".project"));
        copied.add(new File(canonicalDir, "project.properties"));
        copied.add(new File(canonicalDir, "project.properties"));
        copied.add(new File(canonicalDir, "local.properties"));
        copied.add(new File(canonicalDir, "libs"));
        copied.add(new File(canonicalDir, ".settings"));
        copied.add(new File(canonicalDir, ".cproject"));
        if (this.isNdkProject()) {
            copied.add(new File(canonicalDir, "obj"));
        }
        this.reportIgnored(canonicalDir, copied, 0);
    }

    private boolean reportIgnored(File file2, Set<File> copied, int depth) throws IOException {
        if (depth > 0 && copied.contains(file2)) {
            return true;
        }
        boolean ignore = true;
        boolean isDirectory = file2.isDirectory();
        if (isDirectory) {
            if (depth == 1 && GradleImport.isIgnoredFile(file2)) {
                return false;
            }
            File[] files2 = file2.listFiles();
            if (files2 != null) {
                for (File child : files2) {
                    ignore &= this.reportIgnored(child, copied, depth + 1);
                }
            }
        } else {
            ignore = false;
        }
        if (depth > 0 && !ignore) {
            File relative = GradleImport.computeRelativePath(this.getCanonicalModuleDir(), file2);
            if (relative == null) {
                relative = file2;
            }
            Object path2 = relative.getPath();
            if (isDirectory) {
                path2 = (String)path2 + File.separator;
            }
            this.myImporter.getSummary().reportIgnored(this.getOriginalName(), (String)path2);
        }
        return ignore;
    }

    public List<File> getJarDependencies() {
        return this.myJarDependencies;
    }

    public List<GradleCoordinate> getDependencies() {
        return this.myDependencies;
    }

    public List<File> getTestJarDependencies() {
        return this.myTestJarDependencies;
    }

    public List<GradleCoordinate> getTestDependencies() {
        return this.myTestDependencies;
    }

    public File computeProjectRelativePath(File file2) throws IOException {
        return GradleImport.computeRelativePath(this.getCanonicalModuleDir(), file2);
    }

    protected abstract boolean dependsOn(ImportModule var1);

    protected abstract boolean dependsOnLibrary(String var1);

    void removeJarDependencies() {
        ListIterator<File> iterator2 = this.getJarPaths().listIterator();
        while (iterator2.hasNext()) {
            File jar = iterator2.next();
            if (this.myImporter.isJarHandled(jar)) {
                iterator2.remove();
                continue;
            }
            String pkg = jar.getName();
            if (pkg.endsWith(".jar")) {
                pkg = pkg.substring(0, pkg.length() - ".jar".length());
            }
            if (!this.dependsOnLibrary(pkg = pkg.replace('-', '.'))) continue;
            iterator2.remove();
        }
    }

    @Override
    public int compareTo(ImportModule other) {
        if (this.dependsOn(other)) {
            return 1;
        }
        if (other.dependsOn(this)) {
            return -1;
        }
        return this.getOriginalName().compareTo(other.getOriginalName());
    }
}

