/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.adtimport;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.adtimport.GradleImport;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.util.ToolWindows;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.uipreview.EditorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdtImportBuilder
extends ProjectImportBuilder<String> {
    private File mySelectedProject;
    private GradleImport myImporter;
    private final boolean myCreateProject;

    public AdtImportBuilder(boolean createProject) {
        this.myCreateProject = createProject;
    }

    @NotNull
    public String getName() {
        return "ADT (Eclipse Android)";
    }

    public void setSelectedProject(@NotNull File selectedProject) {
        this.mySelectedProject = selectedProject;
        List<File> projects2 = Collections.singletonList(this.mySelectedProject);
        this.myImporter = this.createImporter(projects2);
    }

    @NotNull
    private GradleImport createImporter(@NotNull List<File> projects2) {
        GradleImport importer = new GradleImport();
        importer.setImportIntoExisting(!this.myCreateProject);
        if (this.myCreateProject) {
            importer.setCreateGradleWrapper(true);
            AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
            if (sdkData != null) {
                importer.setSdkLocation(sdkData.getLocationFile());
            }
        }
        importer.importProjects(projects2);
        return importer;
    }

    @Nullable
    public GradleImport getImporter() {
        return this.myImporter;
    }

    public Icon getIcon() {
        return AllIcons.Providers.Eclipse;
    }

    @Nullable
    public List<String> getList() {
        return null;
    }

    public boolean isMarked(String element2) {
        return false;
    }

    public void setList(List<String> list2) {
    }

    public void setOpenProjectSettingsAfter(boolean on) {
    }

    @Nullable
    public List<Module> commit(Project project, @Nullable ModifiableModuleModel model2, ModulesProvider modulesProvider, @Nullable ModifiableArtifactModel artifactModel) {
        File destDir = Projects.getBaseDirPath((Project)project);
        try {
            boolean isExportSuccessful = (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                boolean ok;
                if (!destDir.exists() && !(ok = destDir.mkdirs())) {
                    throw new IOException("Could not create destination directory");
                }
                this.readProjects();
                if (!this.myImporter.getErrors().isEmpty()) {
                    return false;
                }
                this.myImporter.exportProject(destDir, true);
                VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
                if (projectDir != null) {
                    projectDir.refresh(false, true);
                }
                return true;
            }, "Migrating project...", false, null);
            if (!isExportSuccessful) {
                return null;
            }
        }
        catch (IOException e) {
            Logger.getInstance(AdtImportBuilder.class).error((Throwable)e);
            return null;
        }
        try {
            GradleSyncListener syncListener = new GradleSyncListener(){

                @Override
                public void syncSucceeded(@NotNull Project project) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ToolWindows.activateProjectView(project);
                        AdtImportBuilder.openSummary(project);
                    });
                }

                @Override
                public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                    ApplicationManager.getApplication().invokeLater(() -> AdtImportBuilder.openSummary(project));
                }
            };
            GradleProjectImporter importer = GradleProjectImporter.getInstance();
            if (this.myCreateProject) {
                GradleProjectImporter.Request request2 = new GradleProjectImporter.Request(project);
                request2.isNewProject = true;
                importer.importProjectNoSync(request2);
                Path projectDir = Projects.getBaseDirPath((Project)request2.project).getAbsoluteFile().toPath();
                OpenProjectTask options2 = OpenProjectTask.build().withProject(project).withForceOpenInNewFrame(true);
                ProjectManagerEx.getInstanceEx().openProject(projectDir, options2);
            } else {
                GradleSyncInvoker.getInstance().requestProjectSync(project, new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_IMPORT_ADT_MODULE), syncListener);
            }
        }
        catch (Throwable e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"ADT Project Import");
        }
        return Collections.emptyList();
    }

    public void readProjects() {
        this.myImporter.importProjects(Collections.singletonList(this.mySelectedProject));
    }

    public boolean validate(@Nullable Project current, Project dest) {
        return super.validate(current, dest);
    }

    private static void openSummary(Project project) {
        VirtualFile summary = project.getBaseDir().findChild("import-summary.txt");
        if (summary != null) {
            EditorUtil.openEditor(project, summary);
        }
    }

    @Nullable
    public static AdtImportBuilder getBuilder(@Nullable WizardContext context2) {
        if (context2 != null) {
            return (AdtImportBuilder)context2.getProjectBuilder();
        }
        return null;
    }

    @Nullable
    public Project createProject(String name, String path2) {
        return GradleProjectImporter.getInstance().createProject(name, new File(path2));
    }
}

