/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.GoToApkLocationTask;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class BuildApkAction
extends DumbAwareAction {
    private static final String ACTION_TEXT = "Build APK(s)";

    public BuildApkAction() {
        super(ACTION_TEXT);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && GradleProjectInfo.getInstance(project).isBuildWithGradle());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<Module> appModules;
        Project project = e.getProject();
        if (project != null && GradleProjectInfo.getInstance(project).isBuildWithGradle() && !(appModules = ProjectStructure.getInstance(project).getAppHolderModules().stream().flatMap(module2 -> GradleProjectSystemUtil.getModulesToBuild(module2).stream()).collect(Collectors.toList())).isEmpty()) {
            GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
            GoToApkLocationTask task2 = new GoToApkLocationTask(project, appModules, ACTION_TEXT);
            Module[] modulesToBuild = appModules.toArray(Module.EMPTY_ARRAY);
            task2.executeWhenBuildFinished(gradleBuildInvoker.assemble(modulesToBuild, TestCompileType.ALL));
        }
    }
}

