/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.android.CompileOptionsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.model.IdeBaseArtifact;
import com.android.tools.idea.gradle.model.IdeDependencies;
import com.android.tools.idea.gradle.model.IdeJavaLibrary;
import com.android.tools.idea.gradle.model.IdeJavaLibraryDependency;
import com.android.tools.idea.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class AndroidGradleJavaProjectModelModifier
extends JavaProjectModelModifier {
    @NotNull
    private static final Map<String, String> EXTERNAL_LIBRARY_VERSIONS = ImmutableMap.of((Object)"net.jcip:jcip-annotations", (Object)"1.0", (Object)"org.jetbrains:annotations-java5", (Object)"15.0", (Object)"org.jetbrains:annotations", (Object)"15.0", (Object)"junit:junit", (Object)"4.12", (Object)"org.testng:testng", (Object)"6.9.6");
    @NotNull
    private static final Set<String> ANDROID_PLUGIN_IDENTIFIERS = ImmutableSet.of((Object)"android", (Object)"android-library", (Object)"com.android.application", (Object)"com.android.library", (Object)"com.android.instantapp", (Object)"com.android.feature", (Object[])new String[]{"com.android.dynamic-feature", "com.android.test"});
    @NotNull
    private static final Set<String> JAVA_PLUGIN_IDENTIFIERS = ImmutableSet.of((Object)"java", (Object)"java-library");

    @Nullable
    public Promise<Void> addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope2, boolean exported) {
        final Project project = from.getProject();
        VirtualFile openedFile = FileEditorManagerEx.getInstanceEx((Project)from.getProject()).getCurrentFile();
        GradleProjectPath gradlePath = GradleProjectPathKt.getGradleProjectPath(to);
        final GradleBuildModel buildModel = GradleBuildModel.get(from);
        if (buildModel != null && gradlePath != null) {
            DependenciesModel dependencies2 = buildModel.dependencies();
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(from, scope2, openedFile);
            dependencies2.addModule(configurationName, gradlePath.getPath(), null);
            new WriteCommandAction(project, "Add Gradle Module Dependency", new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Throwable {
                    buildModel.applyChanges();
                    AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
                }
            }.execute();
            return AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ADD_MODULE_DEPENDENCY);
        }
        if (buildModel == null ^ gradlePath == null) {
            return Promises.rejectedPromise();
        }
        return null;
    }

    @Nullable
    public Promise<Void> addExternalLibraryDependency(@NotNull Collection<? extends Module> modules2, @NotNull ExternalLibraryDescriptor descriptor2, @NotNull DependencyScope scope2) {
        ArtifactDependencySpec dependencySpec = ArtifactDependencySpec.create(descriptor2.getLibraryArtifactId(), descriptor2.getLibraryGroupId(), AndroidGradleJavaProjectModelModifier.selectVersion(descriptor2));
        return AndroidGradleJavaProjectModelModifier.addExternalLibraryDependency(modules2, dependencySpec, scope2);
    }

    @Nullable
    public Promise<Void> addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope2, boolean exported) {
        if (!GradleFacet.isAppliedTo(from)) {
            return null;
        }
        ArtifactDependencySpec dependencySpec = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(from.getProject(), library);
        if (dependencySpec == null) {
            return Promises.rejectedPromise();
        }
        return AndroidGradleJavaProjectModelModifier.addExternalLibraryDependency((Collection<? extends Module>)ImmutableList.of((Object)from), dependencySpec, scope2);
    }

    @Nullable
    private static Promise<Void> addExternalLibraryDependency(@NotNull Collection<? extends Module> modules2, @NotNull ArtifactDependencySpec dependencySpec, @NotNull DependencyScope scope2) {
        Module firstModule = (Module)Iterables.getFirst(modules2, null);
        if (firstModule == null) {
            return null;
        }
        final Project project = firstModule.getProject();
        VirtualFile openedFile = FileEditorManagerEx.getInstanceEx((Project)firstModule.getProject()).getCurrentFile();
        final ArrayList<GradleBuildModel> buildModelsToUpdate = new ArrayList<GradleBuildModel>();
        for (Module module2 : modules2) {
            GradleBuildModel buildModel = GradleBuildModel.get(module2);
            if (buildModel == null) {
                return null;
            }
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(module2, scope2, openedFile);
            DependenciesModel dependencies2 = buildModel.dependencies();
            dependencies2.addArtifact(configurationName, dependencySpec);
            buildModelsToUpdate.add(buildModel);
        }
        new WriteCommandAction(project, "Add Gradle Library Dependency", new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                for (GradleBuildModel buildModel : buildModelsToUpdate) {
                    buildModel.applyChanges();
                }
                AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
            }
        }.execute();
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ADD_LIBRARY_DEPENDENCY);
    }

    @Nullable
    public Promise<Void> changeLanguageLevel(@NotNull Module module2, @NotNull LanguageLevel level) {
        final Project project = module2.getProject();
        if (!GradleFacet.isAppliedTo(module2)) {
            return null;
        }
        final GradleBuildModel buildModel = GradleBuildModel.get(module2);
        if (buildModel == null) {
            return null;
        }
        List<String> pluginNames = PluginModel.extractNames(buildModel.plugins());
        ArrayList<String> androidPluginNames = new ArrayList<String>(pluginNames);
        androidPluginNames.retainAll(ANDROID_PLUGIN_IDENTIFIERS);
        ArrayList<String> javaPluginNames = new ArrayList<String>(pluginNames);
        javaPluginNames.retainAll(JAVA_PLUGIN_IDENTIFIERS);
        if (!androidPluginNames.isEmpty()) {
            AndroidModel android = buildModel.android();
            CompileOptionsModel compileOptions = android.compileOptions();
            compileOptions.sourceCompatibility().setLanguageLevel(level);
            compileOptions.targetCompatibility().setLanguageLevel(level);
        }
        if (!javaPluginNames.isEmpty()) {
            JavaModel javaModel = buildModel.java();
            javaModel.sourceCompatibility().setLanguageLevel(level);
            javaModel.targetCompatibility().setLanguageLevel(level);
        }
        new WriteCommandAction(project, "Change Gradle Language Level", new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                buildModel.applyChanges();
                AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
            }
        }.execute();
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_LANGUAGE_LEVEL_CHANGED);
    }

    @NotNull
    private static String getConfigurationName(@NotNull Module module2, @NotNull DependencyScope scope2, @Nullable VirtualFile openedFile) {
        if (!scope2.isForProductionCompile()) {
            TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.getInstance(module2);
            boolean isAndroid = testScopes != null && openedFile != null && testScopes.isAndroidTestSource(openedFile);
            return isAndroid ? "androidTestImplementation" : "testImplementation";
        }
        return "implementation";
    }

    @Nullable
    private static String selectVersion(@NotNull ExternalLibraryDescriptor descriptor2) {
        GoogleMavenArtifactId library;
        String libraryArtifactId = descriptor2.getLibraryArtifactId();
        String libraryGroupId = descriptor2.getLibraryGroupId();
        String groupAndId = libraryGroupId + ":" + libraryArtifactId;
        String version2 = EXTERNAL_LIBRARY_VERSIONS.get(groupAndId);
        if (version2 == null && (library = GoogleMavenArtifactId.Companion.find(libraryGroupId, libraryArtifactId)) != null) {
            GradleCoordinate coordinate;
            Predicate<GradleVersion> filter2 = descriptor2.getMinVersion() == null ? null : v -> v.toString().startsWith(descriptor2.getMinVersion());
            String gc = RepositoryUrlManager.get().getArtifactStringCoordinate(library, filter2, false);
            if (gc == null) {
                gc = RepositoryUrlManager.get().getLibraryRevision(libraryGroupId, libraryArtifactId, filter2, false, FileSystems.getDefault());
            }
            if (gc != null && (coordinate = GradleCoordinate.parseCoordinateString((String)gc)) != null) {
                version2 = coordinate.getRevision();
            }
        }
        return version2;
    }

    @NotNull
    private static Promise<Void> requestProjectSync(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger) {
        final AsyncPromise promise = new AsyncPromise();
        GradleSyncInvoker.Request request2 = new GradleSyncInvoker.Request(trigger);
        GradleSyncInvoker.getInstance().requestProjectSync(project, request2, new GradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                promise.setResult(null);
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                promise.setError(errorMessage);
            }
        });
        return promise;
    }

    private static void registerUndoAction(final @NotNull Project project) {
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_UNDONE);
            }

            public void redo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_REDONE);
            }
        });
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Project project, @NotNull Library library) {
        if (library.getName() == null) {
            return null;
        }
        ArtifactDependencySpec result2 = null;
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            GradleAndroidModel androidModel = GradleAndroidModel.get(module2);
            if (androidModel == null || LibraryUtil.findLibrary((Module)module2, (String)library.getName()) == null) continue;
            result2 = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(library, androidModel.getSelectedVariant());
            break;
        }
        if (result2 == null) {
            result2 = AndroidGradleJavaProjectModelModifier.findNewExternalDependencyByExaminingPath(library);
        }
        return result2;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Library library, @NotNull IdeVariant selectedVariant) {
        @Nullable ArtifactDependencySpec matchedLibrary = null;
        IdeBaseArtifact artifact2 = selectedVariant.getUnitTestArtifact();
        if (artifact2 != null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, artifact2);
        }
        if (matchedLibrary == null && (artifact2 = selectedVariant.getAndroidTestArtifact()) != null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, artifact2);
        }
        if (matchedLibrary == null && (artifact2 = selectedVariant.getTestFixturesArtifact()) != null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, artifact2);
        }
        if (matchedLibrary == null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, selectedVariant.getMainArtifact());
        }
        if (matchedLibrary == null) {
            return null;
        }
        return matchedLibrary;
    }

    @Nullable
    private static ArtifactDependencySpec findMatchedLibrary(@NotNull Library library, @NotNull IdeBaseArtifact artifact2) {
        IdeDependencies dependencies2 = artifact2.getCompileClasspath();
        for (IdeJavaLibraryDependency gradleLibrary : dependencies2.getJavaLibraries()) {
            IdeJavaLibrary libraryTarget = (IdeJavaLibrary)gradleLibrary.getTarget();
            String libraryName = FileUtil.getNameWithoutExtension((File)libraryTarget.getArtifact());
            if (!libraryName.equals(library.getName())) continue;
            return ArtifactDependencySpec.create(libraryTarget.getArtifactAddress());
        }
        return null;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependencyByExaminingPath(@NotNull Library library) {
        VirtualFile[] files2 = library.getFiles(OrderRootType.CLASSES);
        if (files2.length == 0) {
            return null;
        }
        File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)files2[0]);
        String libraryName = library.getName();
        if (libraryName == null) {
            return null;
        }
        List pathSegments = FileUtil.splitPath((String)file2.getPath());
        for (int i = 1; i < pathSegments.size() - 2; ++i) {
            if (!libraryName.startsWith((String)pathSegments.get(i))) continue;
            String groupId = (String)pathSegments.get(i - 1);
            String artifactId = (String)pathSegments.get(i);
            String version2 = (String)pathSegments.get(i + 1);
            if (!libraryName.endsWith(version2)) continue;
            return ArtifactDependencySpec.create(artifactId, groupId, version2);
        }
        return null;
    }
}

