/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.tools.idea.gradle.model.IdeArtifactDependency;
import com.android.tools.idea.gradle.model.IdeJavaLibrary;
import com.android.tools.idea.gradle.project.model.ClassFileUtil;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.model.ClassJarProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidGradleClassJarProvider
implements ClassJarProvider {
    @Override
    @NotNull
    public List<File> getModuleExternalLibraries(@NotNull Module module2) {
        GradleAndroidModel model2 = GradleAndroidModel.get(module2);
        if (model2 == null) {
            return Lists.transform(AndroidRootUtil.getExternalLibraries(module2), VfsUtilCore::virtualToIoFile);
        }
        return (List)Stream.of(model2.getSelectedMainRuntimeDependencies().getAndroidLibraries().stream().map(IdeArtifactDependency::getTarget).flatMap(it -> it.getRuntimeJarFiles().stream()), model2.getSelectedMainRuntimeDependencies().getJavaLibraries().stream().map(IdeArtifactDependency::getTarget).map(IdeJavaLibrary::getArtifact)).flatMap(s -> s).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean isClassFileOutOfDate(@NotNull Module module2, @NotNull String fqcn, @NotNull VirtualFile classFile) {
        return ClassFileUtil.isClassSourceFileNewerThanClassClassFile(module2, fqcn, classFile);
    }
}

