/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.MutableFontDetail;
import com.android.ide.common.fonts.QueryParser;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class FontFamilyParser {
    FontFamilyParser() {
    }

    @NotNull
    static QueryParser.ParseResult parseFontFamily(@NotNull File xmlFile) {
        try {
            return FontFamilyParser.parseFontReference(xmlFile);
        }
        catch (QueryParser.FontQueryParserError ex) {
            return new ParseErrorResult(ex.getMessage());
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            String message2 = "Could not parse font xml file " + xmlFile;
            Logger.getInstance(FontFamilyParser.class).debug(message2, (Throwable)ex);
            return new ParseErrorResult(message2);
        }
    }

    private static QueryParser.ParseResult parseFontReference(@NotNull File xmlFile) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory2 = SAXParserFactory.newInstance();
        factory2.setNamespaceAware(true);
        SAXParser parser2 = factory2.newSAXParser();
        FontFamilyHandler handler2 = new FontFamilyHandler(xmlFile);
        parser2.parse(xmlFile, (DefaultHandler)handler2);
        return handler2.getResult();
    }

    static int parseInt(@Nullable String intAsString, int defaultValue) {
        if (intAsString == null) {
            return defaultValue;
        }
        try {
            return Math.round(Float.parseFloat(intAsString));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    static boolean parseFontStyle(@Nullable String fontStyle) {
        return fontStyle != null && fontStyle.startsWith("italic");
    }

    static class CompoundFontResult
    extends QueryParser.ParseResult {
        private Map<String, MutableFontDetail> myFonts = new LinkedHashMap<String, MutableFontDetail>();

        CompoundFontResult() {
        }

        @NotNull
        Map<String, MutableFontDetail> getFonts() {
            return this.myFonts;
        }

        private void addFont(@NotNull String fontName, int weight, int width, boolean italics, boolean hasExplicitStyle) {
            this.myFonts.put(fontName, new MutableFontDetail(weight, width, italics, hasExplicitStyle));
        }
    }

    private static class FontFamilyHandler
    extends DefaultHandler {
        private static final String FONT_FAMILY = "font-family";
        private static final String FONT = "font";
        private static final String ATTR_AUTHORITY = "fontProviderAuthority";
        private static final String ATTR_QUERY = "fontProviderQuery";
        private static final String ATTR_FONT = "font";
        private static final String ATTR_FONT_WEIGHT = "fontWeight";
        private static final String ATTR_FONT_WIDTH = "fontWidth";
        private static final String ATTR_FONT_STYLE = "fontStyle";
        private final File myFile;
        private QueryParser.ParseResult myResult;

        private FontFamilyHandler(@NotNull File file2) {
            this.myFile = file2;
        }

        @NotNull
        private QueryParser.ParseResult getResult() {
            if (this.myResult == null) {
                this.myResult = new ParseErrorResult("The font file is empty");
            }
            return this.myResult;
        }

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String name, @NotNull Attributes attributes) throws SAXException {
            switch (name) {
                case "font-family": {
                    this.myResult = this.parseQuery(FontFamilyHandler.getAttributeValue(attributes, ATTR_AUTHORITY), FontFamilyHandler.getAttributeValue(attributes, ATTR_QUERY));
                    break;
                }
                case "font": {
                    String fontName = FontFamilyHandler.getAttributeValue(attributes, "font");
                    int weight = FontFamilyParser.parseInt(FontFamilyHandler.getAttributeValue(attributes, ATTR_FONT_WEIGHT), -1);
                    int width = FontFamilyParser.parseInt(FontFamilyHandler.getAttributeValue(attributes, ATTR_FONT_WIDTH), 100);
                    String fontStyle = FontFamilyHandler.getAttributeValue(attributes, ATTR_FONT_STYLE);
                    boolean italics = FontFamilyParser.parseFontStyle(fontStyle);
                    boolean hasExplicitStyle = fontStyle != null;
                    this.myResult = this.addFont(fontName, weight, width, italics, hasExplicitStyle);
                    break;
                }
                default: {
                    Logger.getInstance(FontFamilyParser.class).warn("Unrecognized tag: " + name + " in file: " + this.myFile);
                }
            }
        }

        @Nullable
        private static String getAttributeValue(@NotNull Attributes attributes, @NotNull String attrName) {
            String value2 = attributes.getValue("http://schemas.android.com/apk/res/android", attrName);
            if (value2 != null) {
                return value2;
            }
            return attributes.getValue("http://schemas.android.com/apk/res-auto", attrName);
        }

        @Nullable
        private QueryParser.ParseResult parseQuery(@Nullable String authority, @Nullable String query) {
            if (this.myResult instanceof ParseErrorResult) {
                return this.myResult;
            }
            if (authority == null && query == null) {
                return this.myResult;
            }
            if (this.myResult != null) {
                return new ParseErrorResult("<font-family> must be the root element");
            }
            if (authority == null) {
                return new ParseErrorResult("The <font-family> tag must contain an fontProviderAuthority attribute");
            }
            if (query == null) {
                return new ParseErrorResult("The <font-family> tag must contain a fontProviderQuery attribute");
            }
            return QueryParser.parseDownloadableFont((String)authority, (String)query);
        }

        private QueryParser.ParseResult addFont(@Nullable String fontName, int weight, int width, boolean italics, boolean hasExplicitStyle) {
            if (this.myResult instanceof ParseErrorResult) {
                return this.myResult;
            }
            if (this.myResult != null && !(this.myResult instanceof CompoundFontResult)) {
                return new ParseErrorResult("<font> is not allowed in a downloadable font definition");
            }
            if (fontName == null) {
                return new ParseErrorResult("The <font> tag must contain a font attribute");
            }
            CompoundFontResult result2 = (CompoundFontResult)this.myResult;
            if (result2 == null) {
                result2 = new CompoundFontResult();
            }
            result2.addFont(fontName, weight, width, italics, hasExplicitStyle);
            return result2;
        }
    }

    static class ParseErrorResult
    extends QueryParser.ParseResult {
        private final String myMessage;

        ParseErrorResult(@NotNull String message2) {
            this.myMessage = message2;
        }

        public String getMessage() {
            return this.myMessage;
        }
    }
}

