/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.tools.idea.fonts.DownloadableFontCacheServiceImpl;
import com.android.tools.idea.fonts.FontFileDownloader;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontDownloadService {
    private static final NotificationGroup PROBLEM_NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Font Downloading Problems");
    private final DownloadableFontCacheServiceImpl myCacheService = DownloadableFontCacheServiceImpl.getInstance();
    private final File myFontPath = this.myCacheService.getFontPath();
    private final List<FontFamily> myFontsToDownload;
    private final boolean myDownloadMenuFontsOnly;
    private final Runnable mySuccess;
    private final Runnable myFailure;

    public static void download(@NotNull List<FontFamily> fontsToDownload, boolean menuFontsOnly, @Nullable Runnable success2, @Nullable Runnable failure) {
        FontDownloadService service = new FontDownloadService(fontsToDownload, menuFontsOnly, success2, failure);
        service.download();
    }

    private FontDownloadService(@NotNull List<FontFamily> fontsToDownload, boolean menuFontsOnly, @Nullable Runnable success2, @Nullable Runnable failure) {
        this.myFontsToDownload = fontsToDownload;
        this.myDownloadMenuFontsOnly = menuFontsOnly;
        this.mySuccess = success2;
        this.myFailure = failure;
    }

    public void download() {
        ApplicationManager.getApplication().executeOnPooledThread(this::performDownload);
    }

    private void performDownload() {
        block5: {
            ArrayList<DownloadableFileDescription> files2 = new ArrayList<DownloadableFileDescription>();
            for (FontFamily fontFamily : this.myFontsToDownload) {
                this.addFontFamily(files2, fontFamily);
            }
            if (this.myFontPath == null) {
                FontDownloadService.notify(this.myFailure);
                return;
            }
            FontFileDownloader downloader = new FontFileDownloader(files2);
            try {
                downloader.download(this.myFontPath);
                FontDownloadService.notify(this.mySuccess);
            }
            catch (Exception ex) {
                if (FontDownloadService.performSingleFileDownloads(this.myFontPath, files2)) {
                    FontDownloadService.notify(this.mySuccess);
                }
                if (this.myFailure == null) break block5;
                FontDownloadService.notify(this.myFailure);
            }
        }
    }

    private static void notify(@Nullable Runnable callback) {
        if (callback != null) {
            callback.run();
        }
    }

    private static boolean performSingleFileDownloads(@NotNull File fontPath, @NotNull List<DownloadableFileDescription> files2) {
        boolean success2 = true;
        for (DownloadableFileDescription file2 : files2) {
            FontFileDownloader downloader = new FontFileDownloader(Collections.singletonList(file2));
            try {
                downloader.download(fontPath);
            }
            catch (Exception ex) {
                String errorMessage = "Unable to download: " + file2.getDownloadUrl();
                Logger.getInstance(FontDownloadService.class).warn(errorMessage, (Throwable)ex);
                ApplicationManager.getApplication().invokeLater(() -> PROBLEM_NOTIFICATION_GROUP.createNotification(errorMessage, MessageType.WARNING).notify(null));
                success2 = false;
            }
        }
        return success2;
    }

    private boolean cachedFileExists(@NotNull File relativeCachedFile) {
        File file2 = new File(this.myFontPath, relativeCachedFile.getPath());
        return file2.exists();
    }

    private void addFontFamily(@NotNull List<DownloadableFileDescription> files2, @NotNull FontFamily fontFamily) {
        File file2 = this.myCacheService.getRelativeCachedMenuFile(fontFamily);
        if (file2 != null && !this.cachedFileExists(file2)) {
            files2.add(FontDownloadService.createFileDescription(fontFamily.getMenu(), file2));
        }
        if (!this.myDownloadMenuFontsOnly) {
            for (FontDetail font : fontFamily.getFonts()) {
                this.addFont(files2, font);
            }
        }
    }

    private void addFont(@NotNull List<DownloadableFileDescription> files2, @NotNull FontDetail font) {
        File file2 = this.myCacheService.getRelativeFontFile(font);
        if (file2 != null && !this.cachedFileExists(file2)) {
            files2.add(FontDownloadService.createFileDescription(font.getFontUrl(), file2));
        }
    }

    @NotNull
    private static DownloadableFileDescription createFileDescription(@NotNull String url, @NotNull File relativeFile) {
        return DownloadableFileService.getInstance().createFileDescription(url, relativeFile.getPath());
    }
}

