/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.tools.idea.compose.ComposeExperimentalConfiguration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.dsl.model.GradleDslModelExperimentalSettings;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.sync.idea.TraceSyncUtil;
import com.android.tools.idea.logcat.LogcatExperimentalSettings;
import com.android.tools.idea.rendering.RenderSettings;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ExperimentalSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final GradleExperimentalSettings mySettings;
    @NotNull
    private final RenderSettings myRenderSettings;
    private JPanel myPanel;
    private JCheckBox myUseL2DependenciesCheckBox;
    private JSlider myLayoutEditorQualitySlider;
    private JCheckBox mySkipGradleTasksList;
    private JCheckBox myTraceGradleSyncCheckBox;
    private JComboBox<TraceProfileItem> myTraceProfileComboBox;
    private TextFieldWithBrowseButton myTraceProfilePathField;
    private JCheckBox myPreviewPickerCheckBox;
    private JLabel myPreviewPickerLabel;
    private JCheckBox myEnableNewLogcatToolCheckBox;
    private BrowserLink myLogcatLearnMoreBrowserLink;
    private JCheckBox myEnableParallelSync;
    private JCheckBox myEnableVersionCatalogParsing;
    private Runnable myRestartCallback;

    public ExperimentalSettingsConfigurable(@NotNull Project project) {
        this(GradleExperimentalSettings.getInstance(), RenderSettings.getProjectSettings(project));
    }

    @VisibleForTesting
    ExperimentalSettingsConfigurable(@NotNull GradleExperimentalSettings settings, @NotNull RenderSettings renderSettings) {
        this.mySettings = settings;
        this.myRenderSettings = renderSettings;
        this.$$$setupUI$$$();
        this.myUseL2DependenciesCheckBox.setVisible(false);
        this.myEnableParallelSync.setVisible((Boolean)StudioFlags.GRADLE_SYNC_PARALLEL_SYNC_ENABLED.get());
        this.myEnableVersionCatalogParsing.setVisible((Boolean)StudioFlags.GRADLE_DSL_TOML_WRITE_SUPPORT.get());
        Hashtable<Integer, JLabel> qualityLabels = new Hashtable<Integer, JLabel>();
        qualityLabels.put(0, new JLabel("Fastest"));
        qualityLabels.put(100, new JLabel("Slowest"));
        this.myLayoutEditorQualitySlider.setLabelTable(qualityLabels);
        this.myLayoutEditorQualitySlider.setPaintLabels(true);
        this.myLayoutEditorQualitySlider.setPaintTicks(true);
        this.myLayoutEditorQualitySlider.setMajorTickSpacing(25);
        this.myPreviewPickerCheckBox.setVisible((Boolean)StudioFlags.COMPOSE_PREVIEW_ELEMENT_PICKER.get());
        this.myPreviewPickerLabel.setVisible((Boolean)StudioFlags.COMPOSE_PREVIEW_ELEMENT_PICKER.get());
        this.initTraceComponents();
        this.reset();
    }

    @NotNull
    public String getId() {
        return "gradle.experimental";
    }

    @Nls
    public String getDisplayName() {
        return "Experimental";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC != this.isUseL2DependenciesInSync() || this.mySettings.SKIP_GRADLE_TASKS_LIST != this.skipGradleTasksList() || this.mySettings.TRACE_GRADLE_SYNC != this.traceGradleSync() || this.mySettings.TRACE_PROFILE_SELECTION != this.getTraceProfileSelection() || !this.mySettings.TRACE_PROFILE_LOCATION.equals(this.getTraceProfileLocation()) || this.mySettings.ENABLE_PARALLEL_SYNC != this.enableParallelSync() || (int)(this.myRenderSettings.getQuality() * 100.0f) != this.getQualitySetting() || this.myPreviewPickerCheckBox.isSelected() != ComposeExperimentalConfiguration.getInstance().isPreviewPickerEnabled() || this.myEnableNewLogcatToolCheckBox.isSelected() != LogcatExperimentalSettings.getInstance().getLogcatV2Enabled() || this.myEnableVersionCatalogParsing.isSelected() != GradleDslModelExperimentalSettings.getInstance().isVersionCatalogEnabled();
    }

    private int getQualitySetting() {
        return this.myLayoutEditorQualitySlider.getValue();
    }

    public void apply() throws ConfigurationException {
        this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC = this.isUseL2DependenciesInSync();
        this.mySettings.SKIP_GRADLE_TASKS_LIST = this.skipGradleTasksList();
        this.mySettings.ENABLE_PARALLEL_SYNC = this.enableParallelSync();
        this.myRenderSettings.setQuality((float)this.getQualitySetting() / 100.0f);
        this.applyTraceSettings();
        ComposeExperimentalConfiguration.getInstance().setPreviewPickerEnabled(this.myPreviewPickerCheckBox.isSelected());
        GradleDslModelExperimentalSettings.getInstance().setVersionCatalogEnabled(this.myEnableVersionCatalogParsing.isSelected());
        LogcatExperimentalSettings logcatSettings = LogcatExperimentalSettings.getInstance();
        if (this.myEnableNewLogcatToolCheckBox.isSelected() != logcatSettings.getLogcatV2Enabled()) {
            logcatSettings.setLogcatV2Enabled(this.myEnableNewLogcatToolCheckBox.isSelected());
            int result2 = Messages.showYesNoDialog((String)AndroidBundle.message("android.logcat.enable.v2.restart.needed", new Object[0]), (String)IdeBundle.message((String)"dialog.title.restart.ide", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.action.restart.yes", (Object[])new Object[0]), (String)AndroidBundle.message("android.logcat.enable.v2.restart.no", new Object[0]), (Icon)Messages.getWarningIcon());
            if (result2 == 0) {
                ((ApplicationEx)ApplicationManager.getApplication()).restart(true);
            }
        }
    }

    public void disposeUIResources() {
        if (this.myRestartCallback != null) {
            this.myRestartCallback.run();
            this.myRestartCallback = null;
        }
    }

    @VisibleForTesting
    boolean isUseL2DependenciesInSync() {
        return this.myUseL2DependenciesCheckBox.isSelected();
    }

    @TestOnly
    void setUseL2DependenciesInSync(boolean value2) {
        this.myUseL2DependenciesCheckBox.setSelected(value2);
    }

    boolean skipGradleTasksList() {
        return this.mySkipGradleTasksList.isSelected();
    }

    @TestOnly
    void setSkipGradleTasksList(boolean value2) {
        this.mySkipGradleTasksList.setSelected(value2);
    }

    boolean traceGradleSync() {
        return this.myTraceGradleSyncCheckBox.isSelected();
    }

    @TestOnly
    void setTraceGradleSync(boolean value2) {
        this.myTraceGradleSyncCheckBox.setSelected(value2);
    }

    @Nullable
    TraceProfileItem getTraceProfileSelection() {
        return (TraceProfileItem)((Object)this.myTraceProfileComboBox.getSelectedItem());
    }

    @TestOnly
    void setTraceProfileSelection(@NotNull TraceProfileItem value2) {
        this.myTraceProfileComboBox.setSelectedItem((Object)value2);
    }

    @NotNull
    String getTraceProfileLocation() {
        return this.myTraceProfilePathField.getText();
    }

    @TestOnly
    void setTraceProfileLocation(@NotNull String value2) {
        this.myTraceProfilePathField.setText(value2);
    }

    boolean enableParallelSync() {
        return this.myEnableParallelSync.isSelected();
    }

    @TestOnly
    void setEnableParallelSync(boolean value2) {
        this.myEnableParallelSync.setSelected(value2);
    }

    @TestOnly
    void setEnableVersionCatalogParsing(boolean value2) {
        this.myEnableVersionCatalogParsing.setSelected(value2);
    }

    private void initTraceComponents() {
        this.myTraceGradleSyncCheckBox.addActionListener(e -> this.updateTraceComponents());
        this.myTraceProfileComboBox.addActionListener(e -> {
            this.myTraceProfilePathField.setEnabled(TraceProfileItem.SPECIFIED_LOCATION.equals(this.myTraceProfileComboBox.getSelectedItem()));
            if (this.isTraceProfileInvalid()) {
                ExternalSystemUiUtil.showBalloon((JComponent)this.myTraceProfilePathField, (MessageType)MessageType.WARNING, (String)"Invalid profile location");
            }
        });
        this.myTraceProfilePathField.addBrowseFolderListener("Trace Profile", "Please select trace profile", null, FileChooserDescriptorFactory.createSingleFileDescriptor((String)"profile"));
        this.myTraceProfileComboBox.addItem(TraceProfileItem.DEFAULT);
        this.myTraceProfileComboBox.addItem(TraceProfileItem.SPECIFIED_LOCATION);
    }

    private void updateTraceComponents() {
        this.myTraceProfileComboBox.setEnabled(this.myTraceGradleSyncCheckBox.isSelected());
        this.myTraceProfilePathField.setEnabled(this.myTraceGradleSyncCheckBox.isSelected() && TraceProfileItem.SPECIFIED_LOCATION.equals(this.myTraceProfileComboBox.getSelectedItem()));
        if (this.isTraceProfileInvalid()) {
            ExternalSystemUiUtil.showBalloon((JComponent)this.myTraceProfilePathField, (MessageType)MessageType.WARNING, (String)"Invalid profile location");
        }
    }

    private void applyTraceSettings() {
        boolean canRestart;
        String okText;
        String message2;
        int result2;
        if (this.isTraceProfileInvalid()) {
            ExternalSystemUiUtil.showBalloon((JComponent)this.myTraceProfilePathField, (MessageType)MessageType.WARNING, (String)"Invalid profile location");
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            this.saveTraceSettings();
            return;
        }
        if (!(this.mySettings.TRACE_GRADLE_SYNC == this.traceGradleSync() && this.mySettings.TRACE_PROFILE_SELECTION == this.getTraceProfileSelection() && this.mySettings.TRACE_PROFILE_LOCATION.equals(this.getTraceProfileLocation()) || (result2 = Messages.showOkCancelDialog((String)(message2 = "A restart of Android Studio is required to apply changes related to tracing.\n\nDo you want to proceed?"), (String)"Restart", (String)(okText = (canRestart = app.isRestartCapable()) ? "Restart" : "Exit"), (String)"Cancel", (Icon)Messages.getQuestionIcon())) != 0)) {
            this.saveTraceSettings();
            TraceSyncUtil.updateTraceArgsInFile();
            app.exit(false, true, true);
        }
    }

    private void saveTraceSettings() {
        this.mySettings.TRACE_GRADLE_SYNC = this.traceGradleSync();
        this.mySettings.TRACE_PROFILE_SELECTION = this.getTraceProfileSelection();
        this.mySettings.TRACE_PROFILE_LOCATION = this.getTraceProfileLocation();
    }

    @VisibleForTesting
    boolean isTraceProfileInvalid() {
        if (this.traceGradleSync() && this.getTraceProfileSelection() == TraceProfileItem.SPECIFIED_LOCATION) {
            File selectedFile = new File(this.getTraceProfileLocation());
            return !selectedFile.isFile() || !selectedFile.getName().endsWith(".profile");
        }
        return false;
    }

    public void reset() {
        this.myUseL2DependenciesCheckBox.setSelected(this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC);
        this.mySkipGradleTasksList.setSelected(this.mySettings.SKIP_GRADLE_TASKS_LIST);
        this.myLayoutEditorQualitySlider.setValue((int)(this.myRenderSettings.getQuality() * 100.0f));
        this.myTraceGradleSyncCheckBox.setSelected(this.mySettings.TRACE_GRADLE_SYNC);
        this.myTraceProfileComboBox.setSelectedItem((Object)this.mySettings.TRACE_PROFILE_SELECTION);
        this.myTraceProfilePathField.setText(this.mySettings.TRACE_PROFILE_LOCATION);
        this.myEnableParallelSync.setSelected(this.mySettings.ENABLE_PARALLEL_SYNC);
        this.updateTraceComponents();
        this.myPreviewPickerCheckBox.setSelected(ComposeExperimentalConfiguration.getInstance().isPreviewPickerEnabled());
        this.myEnableNewLogcatToolCheckBox.setSelected(LogcatExperimentalSettings.getInstance().getLogcatV2Enabled());
        this.myEnableVersionCatalogParsing.setSelected(GradleDslModelExperimentalSettings.getInstance().isVersionCatalogEnabled());
    }

    private void createUIComponents() {
        this.myLogcatLearnMoreBrowserLink = new BrowserLink("Learn more", "https://d.android.com/r/studio-ui/logcat/help");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JSlider jSlider;
        JCheckBox jCheckBox7;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(16, 8, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html><b>Note:</b> These settings are for features that are considered <b>experimental</b>.</html>");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 8, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html><br></html>");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 6, 0, 0, 0, 0, null, null, null));
        this.myUseL2DependenciesCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Use new dependency mechanism during Gradle sync");
        jPanel.add((Component)jCheckBox7, new GridConstraints(3, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Gradle");
        jPanel.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Quality Setting");
        jPanel.add((Component)jBLabel3, new GridConstraints(9, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        this.myLayoutEditorQualitySlider = jSlider = new JSlider();
        jPanel.add((Component)jSlider, new GridConstraints(9, 6, 1, 1, 0, 1, 0, 0, new Dimension(150, -1), new Dimension(90, -1), null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Layout Editor");
        jPanel.add((Component)titledSeparator2, new GridConstraints(8, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        this.mySkipGradleTasksList = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Only include test tasks in the Gradle task list generated during Gradle Sync");
        jPanel.add((Component)jCheckBox6, new GridConstraints(4, 0, 1, 7, 8, 0, 3, 0, null, null, null));
        this.myTraceGradleSyncCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Trace Gradle import with profile:");
        jPanel.add((Component)jCheckBox5, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myTraceProfileComboBox = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(5, 1, 1, 5, 8, 1, 2, 0, null, null, null));
        this.myTraceProfilePathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 6, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myEnableParallelSync = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Enable parallel Gradle Sync");
        jPanel.add((Component)jCheckBox4, new GridConstraints(6, 0, 1, 7, 8, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Jetpack Compose");
        jPanel.add((Component)titledSeparator3, new GridConstraints(10, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        this.myPreviewPickerCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Enable @Preview picker");
        jPanel.add((Component)jCheckBox3, new GridConstraints(11, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(180, 25), null));
        this.myPreviewPickerLabel = jLabel = new JLabel();
        ((Component)jLabel).setEnabled(false);
        jLabel.setText("Popup with editing tools for @Preview annotation from the Editor gutter");
        jPanel.add((Component)jLabel, new GridConstraints(12, 0, 1, 7, 8, 0, 0, 0, null, null, null, 2));
        TitledSeparator titledSeparator4 = new TitledSeparator();
        titledSeparator4.setText("Logcat");
        jPanel.add((Component)titledSeparator4, new GridConstraints(13, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        this.myEnableNewLogcatToolCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Enable new Logcat tool window");
        jPanel.add((Component)jCheckBox2, new GridConstraints(14, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        BrowserLink browserLink = this.myLogcatLearnMoreBrowserLink;
        jPanel.add((Component)browserLink, new GridConstraints(14, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(15, 0, 1, 1, 0, 2, 1, 7, null, null, null));
        this.myEnableVersionCatalogParsing = jCheckBox = new JCheckBox();
        jCheckBox.setText("Parse and write to Version Catalog files");
        jPanel.add((Component)jCheckBox, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static enum TraceProfileItem {
        DEFAULT("Default profile"),
        SPECIFIED_LOCATION("Specified location");

        private final String displayValue;

        private TraceProfileItem(String value2) {
            this.displayValue = value2;
        }

        public String toString() {
            return this.displayValue;
        }
    }
}

