/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.file.explorer.toolwindow.adbimpl;

import com.android.ddmlib.FileListingService;
import com.android.tools.idea.file.explorer.toolwindow.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.file.explorer.toolwindow.adbimpl.AdbPathUtil;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"getName", "", "result", "Ljava/util/regex/MatchResult;", "escaping", "", "processLsOutputLine", "Lcom/android/tools/idea/file/explorer/toolwindow/adbimpl/AdbFileListingEntry;", "line", "parentEntry", "intellij.android.device-file-explorer-toolwindow"})
public final class AdbFileListingKt {
    /*
     * WARNING - void declaration
     */
    private static final AdbFileListingEntry processLsOutputLine(String line2, boolean escaping, AdbFileListingEntry parentEntry) {
        if (((CharSequence)line2).length() == 0) {
            return null;
        }
        Matcher m = FileListingService.LS_L_PATTERN.matcher(line2);
        if (!m.matches()) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)m, (String)"m");
        String name = AdbFileListingKt.getName(m, escaping);
        if (Intrinsics.areEqual((Object)name, (Object)".") || Intrinsics.areEqual((Object)name, (Object)"..")) {
            return null;
        }
        String permissions = m.group(1);
        String owner = m.group(2);
        String group2 = m.group(3);
        String size = m.group(4);
        String date = m.group(5);
        String time2 = m.group(6);
        Object info2 = null;
        AdbFileListingEntry.EntryKind objectType = AdbFileListingEntry.EntryKind.OTHER;
        char c = permissions.charAt(0);
        if (c == '-') {
            objectType = AdbFileListingEntry.EntryKind.FILE;
        } else if (c == 'b') {
            objectType = AdbFileListingEntry.EntryKind.BLOCK;
        } else if (c == 'c') {
            objectType = AdbFileListingEntry.EntryKind.CHARACTER;
        } else if (c == 'd') {
            objectType = AdbFileListingEntry.EntryKind.DIRECTORY;
        } else if (c == 'l') {
            objectType = AdbFileListingEntry.EntryKind.SYMBOLIC_LINK;
        } else if (c == 's') {
            objectType = AdbFileListingEntry.EntryKind.SOCKET;
        } else if (c == 'p') {
            objectType = AdbFileListingEntry.EntryKind.FIFO;
        }
        if (objectType == AdbFileListingEntry.EntryKind.SYMBOLIC_LINK) {
            void $this$toTypedArray$iv;
            Object object = name;
            Regex regex = new Regex("\\s->\\s");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] segments = stringArray;
            if (segments.length == 2) {
                name = segments[0];
                info2 = segments[1];
            }
            info2 = "-> " + info2;
        }
        String string = AdbPathUtil.resolve(parentEntry.getFullPath(), name);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resolve(parentEntry.fullPath, name)");
        String path2 = string;
        return new AdbFileListingEntry(path2, objectType, permissions, owner, group2, date, time2, size, (String)info2);
    }

    private static final String getName(MatchResult result2, boolean escaping) {
        String string;
        String name = result2.group(7);
        if (escaping) {
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            string = StringsKt.replace$default((String)name, (String)"\\", (String)"", (boolean)false, (int)4, null);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            string = name;
        }
        return string;
    }

    public static final /* synthetic */ AdbFileListingEntry access$processLsOutputLine(String line2, boolean escaping, AdbFileListingEntry parentEntry) {
        return AdbFileListingKt.processLsOutputLine(line2, escaping, parentEntry);
    }
}

