/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.file.explorer.toolwindow;

import com.android.tools.idea.file.explorer.toolwindow.fs.DeviceFileEntry;
import com.android.tools.idea.file.explorer.toolwindow.ui.TreeUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceFileEntryNode
extends DefaultMutableTreeNode {
    @NotNull
    private DeviceFileEntry myEntry;
    private boolean myIsSymbolicLinkToDirectory;
    private boolean myLoaded;
    private boolean myDownloading;
    private boolean myUploading;
    private int myTransferringTick;
    private long myCurrentTransferredBytes;
    private long myTotalTransferredBytes;

    @Nullable
    public static DeviceFileEntryNode fromNode(@Nullable Object value2) {
        if (!(value2 instanceof DeviceFileEntryNode)) {
            return null;
        }
        return (DeviceFileEntryNode)value2;
    }

    @Override
    @NotNull
    public String toString() {
        return this.myEntry.getName();
    }

    public DeviceFileEntryNode(@NotNull DeviceFileEntry entry) {
        this.myEntry = entry;
    }

    public boolean isLoaded() {
        return this.myLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.myLoaded = loaded;
    }

    public boolean isSymbolicLinkToDirectory() {
        return this.myIsSymbolicLinkToDirectory;
    }

    public void setSymbolicLinkToDirectory(boolean value2) {
        this.myIsSymbolicLinkToDirectory = value2;
    }

    @Override
    public boolean isLeaf() {
        return !this.isExpandable();
    }

    public boolean isExpandable() {
        return this.myEntry.isDirectory() || this.myIsSymbolicLinkToDirectory;
    }

    @NotNull
    public DeviceFileEntry getEntry() {
        return this.myEntry;
    }

    public void setEntry(@NotNull DeviceFileEntry entry) {
        this.myEntry = entry;
    }

    public boolean isDownloading() {
        return this.myDownloading;
    }

    public boolean isUploading() {
        return this.myUploading;
    }

    public boolean isTransferring() {
        return this.isDownloading() || this.isUploading();
    }

    private void clearTransferInfo() {
        this.myUploading = false;
        this.myDownloading = false;
        this.myTransferringTick = 0;
        this.myCurrentTransferredBytes = 0L;
        this.myTotalTransferredBytes = 0L;
    }

    public void setDownloading(boolean downloading) {
        this.clearTransferInfo();
        this.myDownloading = downloading;
    }

    public void setUploading(boolean uploading) {
        this.clearTransferInfo();
        this.myUploading = uploading;
    }

    public int getTransferringTick() {
        return this.myTransferringTick;
    }

    public void incTransferringTick() {
        ++this.myTransferringTick;
    }

    public void setTransferProgress(long currentBytes, long totalBytes) {
        this.myCurrentTransferredBytes = currentBytes;
        this.myTotalTransferredBytes = totalBytes;
    }

    public long getCurrentTransferredBytes() {
        return this.myCurrentTransferredBytes;
    }

    public long getTotalTransferredBytes() {
        return this.myTotalTransferredBytes;
    }

    @NotNull
    public List<DeviceFileEntryNode> getChildEntryNodes() {
        return TreeUtil.getChildren(this).map(DeviceFileEntryNode::fromNode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public DeviceFileEntryNode findChildEntry(@NotNull String name) {
        return this.getChildEntryNodes().stream().filter(x -> Objects.equals(x.getEntry().getName(), name)).findFirst().orElse(null);
    }
}

