/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.file.explorer.toolwindow;

import com.android.tools.idea.file.explorer.toolwindow.DeviceExplorerModelListener;
import com.android.tools.idea.file.explorer.toolwindow.fs.DeviceFileSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceExplorerModel {
    @NotNull
    private final List<DeviceExplorerModelListener> myListeners = new ArrayList<DeviceExplorerModelListener>();
    @NotNull
    private final List<DeviceFileSystem> myDevices = new ArrayList<DeviceFileSystem>();
    @Nullable
    private DeviceFileSystem myActiveDevice;
    @Nullable
    private DefaultTreeModel myTreeModel;
    @Nullable
    private DefaultTreeSelectionModel myTreeSelectionModel;

    @NotNull
    public List<DeviceFileSystem> getDevices() {
        return this.myDevices;
    }

    @Nullable
    public DeviceFileSystem getActiveDevice() {
        return this.myActiveDevice;
    }

    public void setActiveDevice(@Nullable DeviceFileSystem activeDevice2) {
        this.myActiveDevice = activeDevice2;
        this.myListeners.forEach(x -> x.activeDeviceChanged(this.myActiveDevice));
        this.setActiveDeviceTreeModel(activeDevice2, null, null);
    }

    @Nullable
    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    @Nullable
    public DefaultTreeSelectionModel getTreeSelectionModel() {
        return this.myTreeSelectionModel;
    }

    public void addListener(@NotNull DeviceExplorerModelListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull DeviceExplorerModelListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void setActiveDeviceTreeModel(@Nullable DeviceFileSystem device2, @Nullable DefaultTreeModel treeModel, @Nullable DefaultTreeSelectionModel treeSelectionModel) {
        if (!Objects.equals(this.myActiveDevice, device2)) {
            return;
        }
        if (Objects.equals(this.myTreeModel, treeModel)) {
            return;
        }
        this.myTreeModel = treeModel;
        this.myTreeSelectionModel = treeSelectionModel;
        this.myListeners.forEach(x -> x.treeModelChanged(treeModel, treeSelectionModel));
    }

    public void addDevice(@NotNull DeviceFileSystem device2) {
        if (this.myDevices.contains(device2)) {
            return;
        }
        this.myDevices.add(device2);
        this.myListeners.forEach(l -> l.deviceAdded(device2));
    }

    public void removeDevice(@NotNull DeviceFileSystem device2) {
        if (!this.myDevices.contains(device2)) {
            return;
        }
        this.myListeners.forEach(l -> l.deviceRemoved(device2));
        this.myDevices.remove(device2);
    }

    public void updateDevice(@NotNull DeviceFileSystem device2) {
        if (!this.myDevices.contains(device2)) {
            return;
        }
        this.myListeners.forEach(l -> l.deviceUpdated(device2));
    }
}

