/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.processhandler;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.AndroidSessionInfo;
import com.android.tools.idea.execution.common.AppRunConfiguration;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessMonitorManager;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessMonitorManagerListener;
import com.android.tools.idea.execution.common.processhandler.TextEmitter;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.deployable.SwappableProcessHandler;
import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.OutputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ?2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001?B\u0089\u0001\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012<\b\u0002\u0010\u0012\u001a6\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u001a0\u0013j\u0002`\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\nH\u0007J\u0010\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0003J\b\u0010'\u001a\u00020\rH\u0017J\b\u0010(\u001a\u00020\u000bH\u0015J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\nH\u0007J\b\u0010*\u001a\u00020\rH\u0017J\b\u0010+\u001a\u00020\u000bH\u0015J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010#\u001a\u00020\nH\u0007J\u000f\u0010.\u001a\t\u0018\u00010/\u00a2\u0006\u0002\b0H\u0017J\n\u00101\u001a\u0004\u0018\u000102H\u0017J\u0010\u00103\u001a\u00020\r2\u0006\u0010#\u001a\u00020\nH\u0007J\u0018\u00104\u001a\u00020\r2\u0006\u00105\u001a\u0002062\u0006\u0010%\u001a\u000207H\u0017J\u0010\u00108\u001a\u00020\r2\u0006\u0010#\u001a\u00020\nH\u0007J\b\u00109\u001a\u00020\u000bH\u0017J\u001c\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u00072\n\u0010<\u001a\u0006\u0012\u0002\b\u00030=H\u0016J\b\u0010>\u001a\u00020\u0007H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006@"}, d2={"Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "Lcom/intellij/execution/KillableProcess;", "Lcom/android/tools/idea/run/deployable/SwappableProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "targetApplicationId", "", "finishAndroidProcessCallback", "Lkotlin/Function1;", "Lcom/android/ddmlib/IDevice;", "", "autoTerminate", "", "ansiEscapeDecoder", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "deploymentApplicationService", "Lcom/android/tools/idea/run/DeploymentApplicationService;", "androidProcessMonitorManagerFactory", "Lkotlin/Function2;", "Lcom/android/tools/idea/execution/common/processhandler/TextEmitter;", "Lkotlin/ParameterName;", "name", "textEmitter", "Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManagerListener;", "listener", "Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManager;", "Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManagerFactory;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/jvm/functions/Function1;ZLcom/intellij/execution/process/AnsiEscapeDecoder;Lcom/android/tools/idea/run/DeploymentApplicationService;Lkotlin/jvm/functions/Function2;)V", "getAutoTerminate", "()Z", "myMonitorManager", "getTargetApplicationId", "()Ljava/lang/String;", "addTargetDevice", "device", "areAnyDevicesAssociated", "executionTarget", "Lcom/android/tools/idea/execution/common/AndroidExecutionTarget;", "canKillProcess", "destroyProcessImpl", "detachDevice", "detachIsDefault", "detachProcessImpl", "getClient", "Lcom/android/ddmlib/Client;", "getExecutor", "Lcom/intellij/execution/Executor;", "Lorg/jetbrains/annotations/Nullable;", "getProcessInput", "Ljava/io/OutputStream;", "isAssociated", "isRunningWith", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "Lcom/intellij/execution/ExecutionTarget;", "killClientAndRestartMonitor", "killProcess", "notifyTextAvailable", "text", "outputType", "Lcom/intellij/openapi/util/Key;", "toString", "Companion", "intellij.android.execution.common"})
public final class AndroidProcessHandler
extends ProcessHandler
implements KillableProcess,
SwappableProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @VisibleForTesting
    @NotNull
    private final String targetApplicationId;
    private final boolean autoTerminate;
    @NotNull
    private final AnsiEscapeDecoder ansiEscapeDecoder;
    @NotNull
    private final DeploymentApplicationService deploymentApplicationService;
    @NotNull
    private final AndroidProcessMonitorManager myMonitorManager;
    @NotNull
    private static Logger LOG;

    @JvmOverloads
    public AndroidProcessHandler(@NotNull Project project, @NotNull String targetApplicationId, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback, boolean autoTerminate, @NotNull AnsiEscapeDecoder ansiEscapeDecoder, @NotNull DeploymentApplicationService deploymentApplicationService, @NotNull Function2<? super TextEmitter, ? super AndroidProcessMonitorManagerListener, AndroidProcessMonitorManager> androidProcessMonitorManagerFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        Intrinsics.checkNotNullParameter((Object)ansiEscapeDecoder, (String)"ansiEscapeDecoder");
        Intrinsics.checkNotNullParameter((Object)deploymentApplicationService, (String)"deploymentApplicationService");
        Intrinsics.checkNotNullParameter(androidProcessMonitorManagerFactory, (String)"androidProcessMonitorManagerFactory");
        this.project = project;
        this.targetApplicationId = targetApplicationId;
        this.autoTerminate = autoTerminate;
        this.ansiEscapeDecoder = ansiEscapeDecoder;
        this.deploymentApplicationService = deploymentApplicationService;
        this.putCopyableUserData(SwappableProcessHandler.EXTENSION_KEY, this);
        this.myMonitorManager = (AndroidProcessMonitorManager)androidProcessMonitorManagerFactory.invoke((Object)new TextEmitter(this){
            final /* synthetic */ AndroidProcessHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void emit(@NotNull String message2, @NotNull Key<?> key) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Intrinsics.checkNotNullParameter(key, (String)"key");
                this.this$0.notifyTextAvailable(message2, key);
            }
        }, (Object)new AndroidProcessMonitorManagerListener(this){
            final /* synthetic */ AndroidProcessHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAllTargetProcessesTerminated() {
                if (this.this$0.getAutoTerminate()) {
                    AndroidProcessHandler.access$notifyProcessTerminated(this.this$0, 0);
                }
            }
        });
    }

    public /* synthetic */ AndroidProcessHandler(Project project, final String string, Function1 function1, boolean bl, AnsiEscapeDecoder ansiEscapeDecoder, final DeploymentApplicationService deploymentApplicationService, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = (Function1)new Function1<IDevice, Unit>(){

                public final void invoke(@NotNull IDevice device2) {
                    Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                    device2.forceStop(string);
                }
            };
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            ansiEscapeDecoder = new AnsiEscapeDecoder();
        }
        if ((n & 0x20) != 0) {
            deploymentApplicationService = DeploymentApplicationService.Companion.getInstance();
        }
        if ((n & 0x40) != 0) {
            function2 = (Function2)new Function2<TextEmitter, AndroidProcessMonitorManagerListener, AndroidProcessMonitorManager>((Function1<? super IDevice, Unit>)function1){
                final /* synthetic */ Function1<IDevice, Unit> $finishAndroidProcessCallback;
                {
                    this.$finishAndroidProcessCallback = $finishAndroidProcessCallback;
                    super(2);
                }

                @NotNull
                public final AndroidProcessMonitorManager invoke(@NotNull TextEmitter textEmitter, @NotNull AndroidProcessMonitorManagerListener listener2) {
                    Intrinsics.checkNotNullParameter((Object)textEmitter, (String)"textEmitter");
                    Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
                    return new AndroidProcessMonitorManager(string, deploymentApplicationService, textEmitter, listener2, this.$finishAndroidProcessCallback, null, 32, null);
                }
            };
        }
        this(project, string, (Function1<? super IDevice, Unit>)function1, bl, ansiEscapeDecoder, deploymentApplicationService, (Function2<? super TextEmitter, ? super AndroidProcessMonitorManagerListener, AndroidProcessMonitorManager>)function2);
    }

    @NotNull
    public final String getTargetApplicationId() {
        return this.targetApplicationId;
    }

    public final boolean getAutoTerminate() {
        return this.autoTerminate;
    }

    public void notifyTextAvailable(@NotNull String text2, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        this.ansiEscapeDecoder.escapeText(text2, outputType, new AnsiEscapeDecoder.ColoredTextAcceptor(this){
            final /* synthetic */ AndroidProcessHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public final void coloredTextAvailable(@NotNull String processedText, @NotNull Key attributes) {
                Intrinsics.checkNotNullParameter((Object)processedText, (String)"processedText");
                Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
                AndroidProcessHandler.access$notifyTextAvailable$s-394112517(this.this$0, processedText, attributes);
            }
        });
    }

    @AnyThread
    public final void addTargetDevice(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.myMonitorManager.add(device2);
        LOG.info("Adding device " + device2.getName() + " to monitor for launched app: " + this.targetApplicationId);
    }

    @WorkerThread
    public final boolean killClientAndRestartMonitor(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return this.myMonitorManager.closeAndReplace(device2) != null;
    }

    @WorkerThread
    public final void detachDevice(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.myMonitorManager.detachDevice(device2);
        if (this.myMonitorManager.isEmpty()) {
            this.detachProcess();
        }
    }

    @AnyThread
    public final boolean isAssociated(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return this.myMonitorManager.isAssociated(device2);
    }

    @WorkerThread
    @Nullable
    public final Client getClient(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return this.isAssociated(device2) ? (Client)CollectionsKt.firstOrNull(this.deploymentApplicationService.findClient(device2, this.targetApplicationId)) : (Client)null;
    }

    @AnyThread
    protected void destroyProcessImpl() {
        AppExecutorUtil.getAppExecutorService().submit(new Runnable(this){
            final /* synthetic */ AndroidProcessHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public final void run() {
                AndroidProcessHandler.access$getMyMonitorManager$p(this.this$0).close();
                AndroidProcessHandler.access$notifyProcessTerminated(this.this$0, 0);
            }
        });
    }

    @AnyThread
    protected void detachProcessImpl() {
        AppExecutorUtil.getAppExecutorService().submit(new Runnable(this){
            final /* synthetic */ AndroidProcessHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public final void run() {
                AndroidProcessHandler.access$getMyMonitorManager$p(this.this$0).detachAndClose();
                AndroidProcessHandler.access$notifyProcessDetached(this.this$0);
            }
        });
    }

    @AnyThread
    public boolean detachIsDefault() {
        return false;
    }

    @AnyThread
    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    @AnyThread
    public boolean canKillProcess() {
        ExecutionTarget executionTarget = ExecutionTargetManager.getInstance((Project)this.project).getActiveTarget();
        Intrinsics.checkNotNullExpressionValue((Object)executionTarget, (String)"getInstance(project).activeTarget");
        ExecutionTarget activeTarget = executionTarget;
        if (activeTarget == DefaultExecutionTarget.INSTANCE || !(activeTarget instanceof AndroidExecutionTarget)) {
            return false;
        }
        return this.areAnyDevicesAssociated((AndroidExecutionTarget)activeTarget);
    }

    @AnyThread
    public void killProcess() {
        this.destroyProcess();
    }

    @Override
    @AnyThread
    @Nullable
    public Executor getExecutor() {
        AndroidSessionInfo androidSessionInfo = (AndroidSessionInfo)this.getUserData(AndroidSessionInfo.KEY);
        return androidSessionInfo != null ? androidSessionInfo.getExecutor() : null;
    }

    @Override
    @AnyThread
    public boolean isRunningWith(@NotNull RunConfiguration runConfiguration, @NotNull ExecutionTarget executionTarget) {
        boolean sameRunningApp;
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)executionTarget, (String)"executionTarget");
        boolean bl = sameRunningApp = runConfiguration instanceof AppRunConfiguration && Intrinsics.areEqual((Object)((AppRunConfiguration)runConfiguration).getAppId(), (Object)this.targetApplicationId);
        if (!sameRunningApp) {
            return false;
        }
        if (executionTarget instanceof AndroidExecutionTarget) {
            return this.areAnyDevicesAssociated((AndroidExecutionTarget)executionTarget);
        }
        return false;
    }

    @AnyThread
    private final boolean areAnyDevicesAssociated(AndroidExecutionTarget executionTarget) {
        boolean bl;
        block3: {
            Collection<IDevice> collection2 = executionTarget.getRunningDevices();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"executionTarget.runningDevices");
            Iterable $this$any$iv = collection2;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IDevice it = (IDevice)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!this.isAssociated(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return "AndroidProcessHandler[" + this.targetApplicationId + "]";
    }

    @JvmOverloads
    public AndroidProcessHandler(@NotNull Project project, @NotNull String targetApplicationId, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback, boolean autoTerminate, @NotNull AnsiEscapeDecoder ansiEscapeDecoder, @NotNull DeploymentApplicationService deploymentApplicationService) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        Intrinsics.checkNotNullParameter((Object)ansiEscapeDecoder, (String)"ansiEscapeDecoder");
        Intrinsics.checkNotNullParameter((Object)deploymentApplicationService, (String)"deploymentApplicationService");
        this(project, targetApplicationId, finishAndroidProcessCallback, autoTerminate, ansiEscapeDecoder, deploymentApplicationService, null, 64, null);
    }

    @JvmOverloads
    public AndroidProcessHandler(@NotNull Project project, @NotNull String targetApplicationId, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback, boolean autoTerminate, @NotNull AnsiEscapeDecoder ansiEscapeDecoder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        Intrinsics.checkNotNullParameter((Object)ansiEscapeDecoder, (String)"ansiEscapeDecoder");
        this(project, targetApplicationId, finishAndroidProcessCallback, autoTerminate, ansiEscapeDecoder, null, null, 96, null);
    }

    @JvmOverloads
    public AndroidProcessHandler(@NotNull Project project, @NotNull String targetApplicationId, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback, boolean autoTerminate) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        this(project, targetApplicationId, finishAndroidProcessCallback, autoTerminate, null, null, null, 112, null);
    }

    @JvmOverloads
    public AndroidProcessHandler(@NotNull Project project, @NotNull String targetApplicationId, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        this(project, targetApplicationId, finishAndroidProcessCallback, false, null, null, null, 120, null);
    }

    @JvmOverloads
    public AndroidProcessHandler(@NotNull Project project, @NotNull String targetApplicationId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        this(project, targetApplicationId, null, false, null, null, null, 124, null);
    }

    public static final /* synthetic */ void access$notifyTextAvailable$s-394112517(AndroidProcessHandler $this, String p0, Key p1) {
        super.notifyTextAvailable(p0, p1);
    }

    public static final /* synthetic */ AndroidProcessMonitorManager access$getMyMonitorManager$p(AndroidProcessHandler $this) {
        return $this.myMonitorManager;
    }

    public static final /* synthetic */ void access$notifyProcessTerminated(AndroidProcessHandler $this, int p0) {
        $this.notifyProcessTerminated(p0);
    }

    public static final /* synthetic */ void access$notifyProcessDetached(AndroidProcessHandler $this) {
        $this.notifyProcessDetached();
    }

    static {
        Logger logger2 = Logger.getInstance(AndroidProcessHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(AndroidProcessHandler::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.execution.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

