/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.debug.utils;

import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ThrowableRunnable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/execution/common/debug/utils/ProcessNameReader;", "", "()V", "LOCAL_PROCESS_NAME_SEPARATOR", "", "hasGlobalProcess", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "processName", "readGlobalProcessNames", "", "intellij.android.execution.common"})
public final class ProcessNameReader {
    @NotNull
    public static final ProcessNameReader INSTANCE = new ProcessNameReader();
    @NotNull
    public static final String LOCAL_PROCESS_NAME_SEPARATOR = ":";

    private ProcessNameReader() {
    }

    public final boolean hasGlobalProcess(@NotNull AndroidFacet facet2, @NotNull String processName) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        return this.readGlobalProcessNames(facet2).stream().anyMatch(new Predicate(processName){
            final /* synthetic */ String $processName;
            {
                this.$processName = $processName;
            }

            public final boolean test(@NotNull String globalProcessName) {
                Intrinsics.checkNotNullParameter((Object)globalProcessName, (String)"globalProcessName");
                return Intrinsics.areEqual((Object)this.$processName, (Object)globalProcessName);
            }
        });
    }

    private final List<String> readGlobalProcessNames(AndroidFacet facet2) {
        VirtualFile virtualFile = SourceProviderManager.Companion.getInstance(facet2).getMainManifestFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile manifestFile = virtualFile;
        List result2 = new LinkedList();
        ReadAction.run((ThrowableRunnable)new ThrowableRunnable(facet2, manifestFile, result2){
            final /* synthetic */ AndroidFacet $facet;
            final /* synthetic */ VirtualFile $manifestFile;
            final /* synthetic */ List<String> $result;
            {
                this.$facet = $facet;
                this.$manifestFile = $manifestFile;
                this.$result = $result;
            }

            public final void run() {
                PsiFile psiFile = PsiManager.getInstance((Project)this.$facet.getModule().getProject()).findFile(this.$manifestFile);
                XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
                if (xmlFile == null) {
                    return;
                }
                XmlFile xmlFile2 = xmlFile;
                xmlFile2.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(this.$result){
                    final /* synthetic */ List<String> $result;
                    {
                        this.$result = $result;
                    }

                    public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                        String value2;
                        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
                        if (Intrinsics.areEqual((Object)"process", (Object)attribute.getLocalName()) && (value2 = attribute.getValue()) != null && !StringsKt.startsWith$default((String)value2, (String)":", (boolean)false, (int)2, null)) {
                            String string = value2;
                            Locale locale = Locale.getDefault();
                            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                            String string2 = string.toLowerCase(locale);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
                            this.$result.add(string2);
                        }
                    }
                });
            }
        });
        return result2;
    }
}

