/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.debug.utils;

import com.android.tools.idea.execution.common.debug.utils.ProcessNameReader;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/execution/common/debug/utils/FacetFinder;", "", "()V", "findFacetForProcess", "Lorg/jetbrains/android/facet/AndroidFacet;", "project", "Lcom/intellij/openapi/project/Project;", "processName", "", "intellij.android.execution.common"})
public final class FacetFinder {
    @NotNull
    public static final FacetFinder INSTANCE = new FacetFinder();

    private FacetFinder() {
    }

    @Nullable
    public final AndroidFacet findFacetForProcess(@NotNull Project project, @NotNull String processName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        List<AndroidFacet> facets = ProjectSystemUtil.getAndroidFacets(project);
        for (AndroidFacet facet2 : facets) {
            try {
                String facetPackageName;
                Intrinsics.checkNotNullExpressionValue((Object)ProjectSystemUtil.getModuleSystem(facet2).getApplicationIdProvider().getPackageName(), (String)"facet.getModuleSystem().\u2026nIdProvider().packageName");
                if (Intrinsics.areEqual((Object)processName, (Object)facetPackageName)) {
                    return facet2;
                }
                if (StringsKt.startsWith$default((String)processName, (String)(facetPackageName + ":"), (boolean)false, (int)2, null)) {
                    return facet2;
                }
                if (!ProcessNameReader.INSTANCE.hasGlobalProcess(facet2, processName)) continue;
                return facet2;
            }
            catch (ApkProvisionException e) {
                Logger.getInstance(FacetFinder.class).warn((Throwable)e);
            }
        }
        return null;
    }
}

