/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.debug;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.debug.AndroidDebugger;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerState;
import com.android.tools.idea.execution.common.debug.DebugSessionStarter;
import com.android.tools.idea.execution.common.debug.ReattachingProcessHandler;
import com.android.tools.idea.execution.common.debug.utils.UtilsKt;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001'BM\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0006\u0010\f\u001a\u00028\u0000\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/execution/common/debug/ReattachingDebuggerListener;", "S", "Lcom/android/tools/idea/execution/common/debug/AndroidDebuggerState;", "Lcom/android/ddmlib/AndroidDebugBridge$IClientChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "masterProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "applicationId", "", "androidDebugger", "Lcom/android/tools/idea/execution/common/debug/AndroidDebugger;", "androidDebuggerState", "consoleViewToReuse", "Lcom/intellij/execution/ui/ConsoleView;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "processHandlerForOpenedTab", "Lcom/android/tools/idea/execution/common/debug/ReattachingProcessHandler;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/process/ProcessHandler;Ljava/lang/String;Lcom/android/tools/idea/execution/common/debug/AndroidDebugger;Lcom/android/tools/idea/execution/common/debug/AndroidDebuggerState;Lcom/intellij/execution/ui/ConsoleView;Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/android/tools/idea/execution/common/debug/ReattachingProcessHandler;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getAndroidDebuggerState", "()Lcom/android/tools/idea/execution/common/debug/AndroidDebuggerState;", "Lcom/android/tools/idea/execution/common/debug/AndroidDebuggerState;", "getEnvironment", "()Lcom/intellij/execution/runners/ExecutionEnvironment;", "clientChanged", "", "client", "Lcom/android/ddmlib/Client;", "changeMask", "", "handleError", "e", "", "isClientForDebug", "", "Companion", "intellij.android.execution.common"})
public final class ReattachingDebuggerListener<S extends AndroidDebuggerState>
implements AndroidDebugBridge.IClientChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ProcessHandler masterProcessHandler;
    @NotNull
    private final String applicationId;
    @NotNull
    private final AndroidDebugger<S> androidDebugger;
    @NotNull
    private final S androidDebuggerState;
    @Nullable
    private final ConsoleView consoleViewToReuse;
    @NotNull
    private final ExecutionEnvironment environment;
    @NotNull
    private ReattachingProcessHandler processHandlerForOpenedTab;
    @NotNull
    private final Logger LOG;
    public static final int CHANGE_MASK = 3;

    public ReattachingDebuggerListener(@NotNull Project project, @NotNull ProcessHandler masterProcessHandler, @NotNull String applicationId2, @NotNull AndroidDebugger<S> androidDebugger, @NotNull S androidDebuggerState, @Nullable ConsoleView consoleViewToReuse, @NotNull ExecutionEnvironment environment, @NotNull ReattachingProcessHandler processHandlerForOpenedTab) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)masterProcessHandler, (String)"masterProcessHandler");
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkNotNullParameter(androidDebugger, (String)"androidDebugger");
        Intrinsics.checkNotNullParameter(androidDebuggerState, (String)"androidDebuggerState");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)((Object)processHandlerForOpenedTab), (String)"processHandlerForOpenedTab");
        this.project = project;
        this.masterProcessHandler = masterProcessHandler;
        this.applicationId = applicationId2;
        this.androidDebugger = androidDebugger;
        this.androidDebuggerState = androidDebuggerState;
        this.consoleViewToReuse = consoleViewToReuse;
        this.environment = environment;
        this.processHandlerForOpenedTab = processHandlerForOpenedTab;
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)new Disposable(){

            public final void dispose() {
                AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            }
        });
        Logger logger2 = Logger.getInstance(ReattachingDebuggerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(ReattachingD\u2026ggerListener::class.java)");
        this.LOG = logger2;
    }

    @NotNull
    public final S getAndroidDebuggerState() {
        return this.androidDebuggerState;
    }

    @NotNull
    public final ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    private final boolean isClientForDebug(Client client2, int changeMask) {
        String clientDescription = client2.getClientData().getClientDescription();
        if (Intrinsics.areEqual((Object)this.applicationId, (Object)clientDescription) && (changeMask & 3) != 0 && client2.getClientData().getDebuggerConnectionStatus() == ClientData.DebuggerStatus.WAITING) {
            this.LOG.debug("Client waiting for debugger, PORT: " + client2.getDebuggerListenPort() + ", PID: " + client2.getClientData().getPid() + "\n");
            return true;
        }
        return false;
    }

    private final void handleError(Throwable e) {
        try {
            this.masterProcessHandler.destroyProcess();
        }
        catch (Exception destroyError) {
            this.LOG.warn((Throwable)destroyError);
        }
        if (e instanceof ExecutionException) {
            ExecutionException executionException = (ExecutionException)e;
            String string = this.environment.getRunProfile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"environment.runProfile.name");
            UtilsKt.showError(this.project, executionException, string);
        } else {
            this.LOG.error(e);
        }
    }

    public void clientChanged(@NotNull Client client2, int changeMask) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        if (this.isClientForDebug(client2, changeMask) && !this.masterProcessHandler.isProcessTerminating() && !this.masterProcessHandler.isProcessTerminated()) {
            this.LOG.info("Attaching debugger to a client, PID: " + client2.getClientData().getPid());
            IDevice iDevice = client2.getDevice();
            Intrinsics.checkNotNullExpressionValue((Object)iDevice, (String)"client.device");
            String string = client2.getClientData().getClientDescription();
            Intrinsics.checkNotNull((Object)string);
            DebugSessionStarter.attachDebuggerToStartedProcess$default(DebugSessionStarter.INSTANCE, iDevice, string, this.environment, this.androidDebugger, this.androidDebuggerState, (Function1)new Function1<IDevice, Unit>(client2){
                final /* synthetic */ Client $client;
                {
                    this.$client = $client;
                    super(1);
                }

                public final void invoke(@NotNull IDevice it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = this.$client.getClientData().getClientDescription();
                    Intrinsics.checkNotNull((Object)string);
                    it.forceStop(string);
                }
            }, this.consoleViewToReuse, 0L, 128, null).onSuccess(new Consumer(this){
                final /* synthetic */ ReattachingDebuggerListener<S> this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(XDebugSessionImpl session) {
                    ReattachingDebuggerListener.access$getProcessHandlerForOpenedTab$p(this.this$0).detachProcess();
                    ReattachingDebuggerListener.access$setProcessHandlerForOpenedTab$p(this.this$0, new ReattachingProcessHandler(ReattachingDebuggerListener.access$getMasterProcessHandler$p(this.this$0)));
                    ReattachingProcessHandler reattachingProcessHandler = ReattachingDebuggerListener.access$getProcessHandlerForOpenedTab$p(this.this$0);
                    ProcessHandler processHandler2 = session.getDebugProcess().getProcessHandler();
                    Intrinsics.checkNotNullExpressionValue((Object)processHandler2, (String)"session.debugProcess.processHandler");
                    reattachingProcessHandler.subscribeOnDebugProcess(processHandler2);
                    session.getRunContentDescriptor().setProcessHandler((ProcessHandler)ReattachingDebuggerListener.access$getProcessHandlerForOpenedTab$p(this.this$0));
                    ReattachingDebuggerListener<S> reattachingDebuggerListener = this.this$0;
                    ModalityState modalityState$iv = null;
                    boolean $i$f$runInEdt = false;
                    Application app$iv = ApplicationManager.getApplication();
                    if (app$iv.isDispatchThread()) {
                        boolean bl = false;
                        try {
                            session.showSessionTab();
                        }
                        catch (Throwable e) {
                            ReattachingDebuggerListener.access$handleError(reattachingDebuggerListener, e);
                        }
                    } else {
                        boolean $i$f$invokeLater = false;
                        ApplicationManager.getApplication().invokeLater(new Runnable(session, reattachingDebuggerListener){
                            final /* synthetic */ XDebugSessionImpl $session$inlined;
                            final /* synthetic */ ReattachingDebuggerListener this$0;
                            {
                                this.$session$inlined = xDebugSessionImpl;
                                this.this$0 = reattachingDebuggerListener;
                            }

                            public final void run() {
                                boolean bl = false;
                                try {
                                    this.$session$inlined.showSessionTab();
                                }
                                catch (Throwable e) {
                                    ReattachingDebuggerListener.access$handleError(this.this$0, e);
                                }
                            }
                        }, ModalityState.defaultModalityState());
                    }
                }
            }).onError(new Consumer(this){
                final /* synthetic */ ReattachingDebuggerListener<S> this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(Throwable it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    ReattachingDebuggerListener.access$handleError(this.this$0, it);
                }
            });
        }
    }

    public static final /* synthetic */ ReattachingProcessHandler access$getProcessHandlerForOpenedTab$p(ReattachingDebuggerListener $this) {
        return $this.processHandlerForOpenedTab;
    }

    public static final /* synthetic */ void access$setProcessHandlerForOpenedTab$p(ReattachingDebuggerListener $this, ReattachingProcessHandler reattachingProcessHandler) {
        $this.processHandlerForOpenedTab = reattachingProcessHandler;
    }

    public static final /* synthetic */ ProcessHandler access$getMasterProcessHandler$p(ReattachingDebuggerListener $this) {
        return $this.masterProcessHandler;
    }

    public static final /* synthetic */ void access$handleError(ReattachingDebuggerListener $this, Throwable e) {
        $this.handleError(e);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/execution/common/debug/ReattachingDebuggerListener$Companion;", "", "()V", "CHANGE_MASK", "", "intellij.android.execution.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

